# vim: set ft=spec: -*- rpm-spec -*-

%define pkgname tmail

Name: ruby-%pkgname
Version: 1.2.3.1
Release: alt3.1

Summary: Mail handling library for Ruby
License: GPL
Group: Development/Ruby
URL: http://tmail.rubyforge.org/

BuildArch: noarch

# Automatically added by buildreq on Tue Jul 08 2008 (-bi)
BuildRequires: rpm-build-ruby ruby-racc ruby-test-unit ruby-tool-rdoc ruby-tool-setup

# http://rubyforge.org/frs/?group_id=4512
Source: %pkgname-%version.tar
Patch: %name-%version-%release.patch

%description
TMail is mail handling library for Ruby. TMail can extract data from mail,
and write data to mail following by RFC procedures.

%package doc
Summary: Documentation files for %name
Group: Documentation

%description doc
Documentation files for %name

%prep
%setup -q -n %pkgname-%version
%patch -p1
%update_setup_rb

# leftovers of indeterminate origin
rm -f lib/tmail/require_arch.rb
# will regenerate
rm -f lib/tmail/parser.rb
# epic fail
rm -f test/test_encode.rb

%build
%ruby_config --without-ext
%ruby_build
pushd lib/tmail
%make_build parser.rb
popd
%ruby_test_unit test

%install
%ruby_install
%rdoc lib/

%files
%doc CHANGES LICENSE NOTES README
%ruby_sitelibdir/*

%files doc
%doc sample
%ruby_ri_sitedir/TMail*

%changelog
