Name: sbcl
Version: 1.1.5
Release: alt1

Summary: Steel Bank Common ANSI Common Lisp
License: Distributable
Group: Development/Lisp
URL: http://sbcl.sourceforge.net/
Packager: Ilya Mashkin <oddity@altlinux.ru>

Source: %name-%version-source.tar.bz2

Patch1: %name-1.0-lib_dir.patch
Patch2: %name-1.0-no-as-needed.patch
Patch3: %name-1.0.5-test-passed.patch
Patch4: %name-1.0.44-prefix.patch
Patch5: %name-1.0.44-runtime.patch

BuildRequires: sbcl /usr/bin/tex
BuildRequires: /proc

%description
Steel Bank Common Lisp (SBCL) is an open source (free software) compiler 
and runtime system for ANSI Common Lisp. It provides an interactive 
environment including an integrated native compiler, a debugger, 
and many extensions.

SBCL runs on many UNIX and UNIX-like systems.

SBCL is a fork off of the main branch of CMU CL. Broadly speaking,
SBCL is distinguished from CMU CL by a greater emphasis on
maintainability. Maybe someday this will translate into better
stability, better ANSI compliance, and so forth, but for now, the big
advantage is that an SBCL system is built directly from scratch, as an
ordinary software system is.

SBCL also places less emphasis than CMU CL does on non-ANSI
extensions, either on backward compatibility with the old CMU CL
non-ANSI extensions or on adding new non-ANSI extensions.

SBCL derives most of its code from CMU CL, created at Carnegie Mellon
University. Radical changes have been made to some parts of the system
(particularly bootstrapping) but most fundamentals (like the mapping
of Lisp abstractions onto the underlying hardware, the basic
architecture of the compiler, and most of the runtime support code)
are only slightly changed. Enough changes have been made to the
interface and architecture that calling the new system CMU Common Lisp
would cause confusion - the world does not need multiple incompatible
systems named CMU CL. But it's appropriate to acknowledge the descent
from the CMU hackers (and post-CMU CMU CL hackers) who did most of the
heavy lifting to make the system work. So the system is named Steel
Bank after the industries where Andrew Carnegie and Andrew Mellon,
respectively, made the big bucks.

%prep
%setup -q

%patch1 -p1
%patch2 -p1
%patch3 -p1
#patch4 -p1
%patch5 -p1

#__subst "s|/usr/local/lib/sbcl/|%_libdir/sbcl/|" src/runtime/runtime.c
%__subst "s|/usr/lib/sbcl/|%_libdir/sbcl/|" src/runtime/runtime.c

%build
export CFLAGS="$RPM_OPT_FLAGS -D_LARGEFILE64_SOURCE"
#export CFLAGS="$RPM_OPT_FLAGS -D_GNU_SOURCE -D_LARGEFILE64_SOURCE"
export SBCL_HOME=%_libdir/sbcl/
export INSTALL_ROOT=%_prefix 
sh ./make.sh  

# comment 30102010
cd doc
sh ./make-doc.sh
cd ..



# docs, two strings from FC
#make -C doc/manual html info

# shorten long doc file names close to maxpathlen
#pushd doc/manual/sbcl
#method_sockets=$(basename $(ls Method-sb*sockets*.html) .html)
#mv "${method_sockets}.html" Method-sockets.html
#sed -i -e "s|${method_sockets}|Method-sockets|" General-Sockets.html
#popd





# pretending that sb-bsd-sockets and sb-posix passed 
#touch contrib/sb-bsd-sockets/test-passed
#touch contrib/sb-posix/test-passed


%install
%define _compress_method skip
mkdir -p %buildroot%_bindir
mkdir -p %buildroot%_libdir/sbcl/
mkdir -p %buildroot%_mandir/man1/

unset SBCL_HOME 
export INSTALL_ROOT=%buildroot%_prefix
export LIB_DIR=%buildroot%_libdir 
sh ./install.sh


cp BUGS COPYING CREDITS INSTALL NEWS PRINCIPLES OPTIMIZATIONS README \
   TLA TODO %buildroot%_docdir/%name/

# remove files used by Mac OS X
find $RPM_BUILD_ROOT -name '._*' -size 1 -print0 | xargs -0 grep -lZ 'Mac OS X' -- | xargs -0 rm -f

%files
%_bindir/*
%_libdir/sbcl
%_mandir/man?/*
%_docdir/*


%changelog
