%set_verify_elf_method unresolved=relaxed
%define hdf5_version 1.8.9
# TODO problem with package freehep-util
%def_without freehep

Name:     scilab
Version:  5.5.1
Release:  alt0.M70P.1
Summary:  A high-level language and system for numerical computations

License:  CeCILL
Group:    Sciences/Mathematics

Packager: Andrey Cherepanov <cas@altlinux.org>

Obsoletes:%name-doc

Source0: %name-%version.tar.bz2
Source1: scilab-desktop-ru.tar

Patch1:  scilab-5.4.0-find-jhall.patch
Patch2:  scilab-5.4.0-find-jgoodies-looks.patch
Patch3:  scilab-5.4.0-find-xml-apis-ext.patch
Patch4:	 scilab-fix-make-doc-ja_JP.patch

URL: http://www.scilab.org
AutoReq: yes, noshell

# See https://bugzilla.redhat.com/show_bug.cgi?id=993239
ExcludeArch:   %{arm}

BuildRequires(pre): rpm-build-java
BuildRequires: gcc-fortran
BuildRequires: gcc-c++
BuildRequires: libxml2-devel

# Numerical libraries
# see "http://wiki.scilab.org/Linalg performances"
BuildRequires: liblapack-devel
BuildRequires: libarpack-ng-devel

# GUI/Console
BuildRequires: jpackage-utils
BuildRequires: java-1.7.0-openjdk-devel
BuildRequires: /proc
BuildRequires: ant

BuildRequires: flexdock >= 1.0
BuildRequires: gluegen2
BuildRequires: jogl2
BuildRequires: scirenderer
BuildRequires: libGL-devel
BuildRequires: jrosetta >= 1.0.4

BuildRequires: apache-commons-logging
BuildRequires: javahelp2
BuildRequires: jlatexmath >= 1.0.2
BuildRequires: jlatexmath-fop >= 1.0.2
BuildRequires: jgraphx
BuildRequires: fop
BuildRequires: jeuclid
BuildRequires: batik
BuildRequires: xmlgraphics-commons
BuildRequires: ecj
%if_with freehep
BuildRequires: freehep-graphics2d
BuildRequires: freehep-util
%endif

# TCL/TK features
BuildRequires: tcl-devel
BuildRequires: tk-devel

Requires:      tcl
Requires:      tk

# Modelica
BuildRequires: ocaml

# Documentation
BuildRequires: saxon
BuildRequires: docbook-style-xsl

# All optional dependencies are needed to provide a full-featured Scilab
BuildRequires: gettext-devel
BuildRequires: libfftw3-devel
BuildRequires: libmatio-devel
BuildRequires: libsuitesparse-devel
BuildRequires: libhdf5-devel
#?BuildRequires: jhdf5
BuildRequires: xml-commons-jaxp-1.3-apis
BuildRequires: checkstyle

BuildRequires: libncurses-devel
BuildRequires: libgomp-devel
BuildRequires: libatlas-devel
BuildRequires: libpcre-devel
BuildRequires: libcurl-devel

# For generated documentation
BuildRequires: fonts-ttf-liberation

Requires: flexdock scirenderer jrosetta
Requires: apache-commons-logging
Requires: javahelp2
Requires: jlatexmath >= 1.0.2
Requires: jlatexmath-fop >= 1.0.2
Requires: jgraphx
Requires: fop
Requires: jeuclid
Requires: batik
Requires: xmlgraphics-commons
Requires: xml-commons-jaxp-1.3-apis
Requires: libfftw3
%if_with freehep
Requires: freehep-graphics2d
Requires: freehep-util
%endif

#Requires: jgoodies-looks skinlf ant-commons-logging avalon-framework
#Requires: docbook-style-xsl saxon

%description
Scilab is the free software for numerical computation providing a powerful
computing environment for engineering and scientific applications. It
includes hundreds of mathematical functions. It has a high level programming
language allowing access to advanced data structures, 2-D and 3-D graphical
functions.

%prep
%setup -q
tar xf %SOURCE1
%patch1 -p2
%patch2 -p2
%patch3 -p2
%patch4 -p1

# Update saxon dependency
# http://bugzilla.scilab.org/show_bug.cgi?id=8479
sed -i "s/com.icl.saxon.Loader/net.sf.saxon.Version/g" m4/docbook.m4 configure

# Fix Class-Path in manifest
sed -i '/name="Class-Path"/d' build.incl.xml

# Fix file-not-utf8
iconv -f ISO_8859-1 -t UTF-8 COPYING >COPYING.utf8
mv COPYING.utf8 COPYING


%build
#%%define _configure_target %{_arch}-pc-linux-gnu
export LDFLAGS="$LDFLAGS -Wl,--no-as-needed"
aclocal
%configure --enable-shared \
           --enable-static=no \
           --with-tk \
           --with-gfortran \
           --with-hdf5-include=%_libdir/hdf5-seq/include/ \
           --with-tcl-library=%_libdir \
           --with-tk-library=%_libdir \
           --with-pic \
%if_without freehep
	   --without-emf \
%endif
	   --disable-static-system-lib \
           --enable-build-help

%make
%make doc

%install
%makeinstall_std
%find_lang %name

# Remove more advanced repl, user should use CLI options instead
rm -fr %buildroot%_desktopdir/%{name}-*.desktop
# Remove la files
rm -fr %buildroot%_libdir/%name/*.la
# Remove MIME package
rm -f %buildroot%_xdgmimedir/packages/scilab.xml

%files -f %name.lang
%doc README_Unix COPYING license.txt
%_bindir/*
%_libdir/pkgconfig/*
%_libdir/%name
%_includedir/%name
%_datadir/%name
%_desktopdir/*.desktop
%_iconsdir/*/*/*/*.png

%changelog
