%define lang_path 	./data/lang
%define data_path 	./data
%define ru_tips 	%lang_path/tips_RU.txt
%define ru_tutor 	%lang_path/tutorial_RU.xml
%define ru_lang_res 	%lang_path/lang_RU.resource

Name:    scorched3d
Version: 43.3d
Release: alt2.1
License: GPL
Group:   Games/Arcade

Summary: A 3D version of the classic DOS game Scorched Earth
Summary(ru_RU.UTF8): 3D версия классической DOS игрушки - Scorched Earth.

URL: http://www.scorched3d.co.uk

Source: %name-%version.tar.gz
Source1: %name.desktop
Source2: %name-16.png
Source3: %name-32.png
Source4: %name-48.png
Patch1:  configure.ac.patch
Patch2: scorched3d-43.3d-alt-gcc4.7.patch
Patch3: scorched3d-43.3d-alt-libpng15.patch


Packager: Evgeny V. Shishkov <shev@altlinux.org>

# Automatically added by buildreq on Wed Feb 25 2009
BuildRequires: gcc-c++ libGL-devel libSDL-devel libSDL_net-devel
BuildRequires: libexpat-devel libfftw3-devel libjpeg-devel
BuildRequires: libopenal-devel libpango-devel libpng-devel
BuildRequires: libvorbis-devel libwxGTK-devel libogg-devel
BuildPreReq: libalut-devel hd2u findutils

Requires: %name-data = %version-%release

%description
Scorched 3D is a game based loosely on the classic DOS game Scorched
Earth "The Mother Of All Games".

%description -l ru_RU.UTF-8
Scorched 3D — компьютерная игра, римейк пошаговой артиллерийской стратегии Scorched Earth.
Игра полностью переработана на трёхмерную графику. В отличии от оригинальной Scorched Earth,
которая является shareware-игрой, Scorched 3D является полностью бесплатной и распостраняется на
условиях лицензии GNU. Играть можно против компьютерного соперника или по сети. Присутствует также
коллективная игра, за одним компьютером могут играть до 24 игрока. (c) wiki

%package data
Summary: Data files for Scorched 3D
Group: Games/Arcade
BuildArch: noarch

%description data
Scorched 3D is a game based loosely on the classic DOS game Scorched
Earth "The Mother Of All Games".

This package contains data files for Scorched 3D.

%prep
%setup -n scorched
%patch1 -p1
%patch2 -p3
%patch3 -p3

%build
/bin/touch {INSTALL,AUTHORS,COPYING,ChangeLog,NEWS}
export OPENAL_CONFIG=%_bindir/openal-config
export FREEALUT_CONFIG=%_bindir/freealut-config

#repocop Thumbs.db
find \( -name 'Thumbs.db' -o -name 'Thumbs.db.gz' \) -print -delete

echo RU > %lang_path/language.ini
dos2unix %ru_tips
%__mv -f %ru_tips %data_path/tips.txt
dos2unix %ru_tutor
%__mv -f %ru_tutor %data_path/tutorial.xml
dos2unix %ru_lang_res

chmod +x autogen.sh
./autogen.sh
%configure \
	--bindir=%_gamesbindir \
	--datadir=%_gamesdatadir/%name \
	--libdir=%_libdir \
	--with-wx=%prefix \
	--with-wx-config=%_bindir/wx-config \
	--with-vorbis=%prefix \
	--with-fftw=%prefix \
	--with-sdl=%prefix \
	--with-gl=%prefix

%make_build

%install
%makeinstall_std
%make_install DESTDIR="%buildroot/" install
install -pD -m644 %SOURCE1 %buildroot%_desktopdir/%name.desktop
install -pD -m644 %SOURCE2 %buildroot%_miconsdir/%name.png
install -pD -m644 %SOURCE3 %buildroot%_niconsdir/%name.png
install -pD -m644 %SOURCE4 %buildroot%_liconsdir/%name.png

%files
%_gamesbindir/scorched3d*
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%_desktopdir/%name.desktop
%doc AUTHORS README documentation/*

%files data
%_gamesdatadir/*

%changelog
