Name: screen
Version: 4.0.3
Release: alt10.M70P.1

Summary: A screen manager that supports multiple sessions on one terminal
License: GPLv2+
Group: Terminals
Url: http://www.gnu.org/software/screen/

Source: screen-%version.tar
Patch: screen-%version-%release.patch

Requires(post): libutempter >= 1.0.6, pam_tcb >= 0.9.7.1, coreutils

BuildPreReq: libutempter-devel >= 1.0.6

# Automatically added by buildreq on Wed Apr 18 2007
BuildRequires: libncurses-devel libutempter-devel pam_userpass-devel

%description
The screen utility allows you to run interactive text-mode programs
(such as login shells) even if it is not possible to control them
interactively all the time (for example, because you are limited by
the way of access to a remote machine.)

For instance, you can do several interactive tasks on the same
physical terminal (a remote shell session) by switching from one virtual
terminal to another with the help of screen utility installed on the
remote machine. Another option would be running a program that needs a
terminal without attaching it to any physical terminal at all
(its start may be scheduled in crontab, or you may want to detach it
when you break the connection to the remote machine).

Install the screen package if you may need to use virtual terminals
managed by the screen utility.

%prep
%setup -q -n screen-%version
%patch -p1

%build
autoconf
%add_optflags -D_GNU_SOURCE
%if_enabled debug
%add_optflags -DDEBUG
%endif
%configure \
	--with-sys-screenrc=/etc/screenrc \
	--with-socket-dir=/var/run/screen \
	--enable-pam \
	--enable-telnet \
	--enable-colors256 \
	--enable-rxvt_osc \
	#

# Does it work at all?
#__perl -pi -e 's|.*#undef HAVE_BRAILLE.*|#define HAVE_BRAILLE 1|' config.h

%make_build CFLAGS="%optflags"
bzip2 -9kf doc/*.ps

%install
%makeinstall_std

pushd %buildroot%_bindir
	rm -f screen.old screen
	mv screen-%version screen
popd

install -pD -m644 screenrc %buildroot/etc/screenrc
install -pD -m644 screencap %buildroot/etc/screencap

install -pD -m644 screen.pamd %buildroot/etc/pam.d/screen

mkdir -p %buildroot{/var/run/screen,/etc/tmpfiles.d}
echo 'd /var/run/screen 0775 root screen' > %buildroot/etc/tmpfiles.d/screen.conf

mkdir -p %buildroot%_libexecdir/screen
touch %buildroot%_libexecdir/screen/{tcb_chkpwd,utempter}

%pre
/usr/sbin/groupadd -r -f screen

%post
ln -f %_libexecdir/chkpwd/tcb_chkpwd %_libexecdir/screen/
ln -f %_libexecdir/utempter/utempter %_libexecdir/screen/

%preun
if [ $1 -eq 0 ]; then
	rm -f %_libexecdir/screen/{tcb_chkpwd,utempter}
fi

%triggerin -- pam_tcb >= 0.9.7.1
ln -f %_libexecdir/chkpwd/tcb_chkpwd %_libexecdir/screen/

%triggerin -- libutempter >= 1.0.6
ln -f %_libexecdir/utempter/utempter %_libexecdir/screen/

%files
%attr(2711,root,screen) %_bindir/screen
%attr(710,root,screen) %dir %_libexecdir/screen
%attr(2711,root,shadow) %ghost %_libexecdir/screen/tcb_chkpwd
%attr(2711,root,utmp) %ghost %_libexecdir/screen/utempter
%attr(775,root,screen) %dir /var/run/screen/

%_datadir/screen
%_man1dir/screen.*
%_infodir/*.info*
%config(noreplace) /etc/screenrc
%config(noreplace) /etc/screencap
%config(noreplace) /etc/pam.d/screen
/etc/tmpfiles.d/screen.conf

%doc etc/*screenrc
%doc NEWS README FAQ doc/README.DOTSCREEN doc/*.ps.*

%changelog
