%def_with	lightning
%def_without 	system_mozldap
%def_without 	enigmail

%define sm_prefix	%_libdir/%name
%define sm_datadir	%_datadir/%name
%define sm_version	%name-%version
%define sm_arch_extensionsdir	%sm_prefix/extensions
%define sm_noarch_extensionsdir	%sm_datadir/extensions
%define sm_cid		\{92650c4d-4b8e-4d2a-b7eb-24ecf4f6b63a}
%define enigmail_ciddir	%sm_arch_extensionsdir/\{847b3a00-7ab1-11d4-8f02-006008948af5\}
%define sm_idldir       %_datadir/idl/%name
%define sm_includedir   %_includedir/%name
%define sm_develdir     %sm_prefix-devel

Name: 	 seamonkey
Version: 2.40
Release: alt1.M70P.1
Epoch:   1
Summary: Web browser and mail reader
License: MPL/NPL
Group:   Networking/WWW

Packager:   Andrey Cherepanov <cas@altlinux.org>

Url: http://www.mozilla.org/projects/seamonkey/

Source0:	%name-%version.source.tar.xz
Source2:	mozilla-searchplugins.tar
Source3:	seamonkey-alt-browser.desktop
Source4:	seamonkey-alt-mail.desktop
Source5:	seamonkey-prefs.js
Source6:	enigmail.tar
Source7:	seamonkey-mozconfig
Source8:	rpm-build.tar

Patch: 		seamonkey-fix-installdirs.patch
Patch1:		seamonkey-2.2-alt-machOS-fix.patch
Patch2:		seamonkey-2.0.14-alt-fix-plugin-path.patch
Patch3:		xulrunner-noarch-extensions.patch
%if_with system_mozldap
Patch5:		thunderbird-with-system-mozldap.patch
%endif
Patch6:		seamonkey-2.13.2-alt-fix-build.patch
Patch7:     	seamonkey-2.19-elfhack.patch
Patch8:		seamonkey-2.26-enable-addons.patch
Patch9:		mozilla-js-makefile.patch
Patch10:	firefox-32-baseline-disable.patch

PreReq:		urw-fonts

#Obsoletes
Obsoletes:	seamonkey-dom-inspector
Provides:	seamonkey-dom-inspector
Obsoletes:	seamonkey-enigmail
Provides:	seamonkey-enigmail
Obsoletes:	seamonkey-irc
Provides:	seamonkey-irc
Obsoletes:	seamonkey-js-debugger
Provides:	seamonkey-js-debugger
Obsoletes:	seamonkey-mail
Provides:	seamonkey-mail
Obsoletes:	seamonkey-plugins-common
Provides:	seamonkey-plugins-common
Obsoletes:	seamonkey-psm
Provides:	seamonkey-psm
Obsoletes:	seamonkey-spellchecker
Provides:	seamonkey-spellchecker

BuildRequires(pre): rpm-macros-alternatives
BuildRequires(pre): browser-plugins-npapi-devel

# Automatically added by buildreq on Sun Jul 16 2006
%if_with system_mozldap
BuildPreReq: mozldap-devel
%endif
BuildRequires: gcc-c++ libdnet-devel libgtk+2-devel libIDL-devel wget libarchive-devel lbzip2 libpixman-devel
BuildRequires: libjpeg-devel libpng-devel libXinerama-devel libXext-devel
BuildRequires: libXp-devel libXt-devel makedepend net-tools unzip libalsa-devel yasm libwireless-devel
BuildRequires: xorg-cf-files zip libXft-devel libvpx-devel
BuildRequires: desktop-file-utils libcurl-devel libhunspell-devel libsqlite3-devel
BuildRequires: autoconf_2.13 chrpath alternatives libGL-devel
BuildRequires: libstartup-notification-devel libfreetype-devel fontconfig-devel libnotify-devel
BuildRequires: libffi-devel libgio-devel
BuildRequires: gst-plugins-devel >= 0.10.25
BuildRequires: libpulseaudio-devel
BuildRequires: libXcomposite-devel
BuildRequires: libXdamage-devel
BuildRequires: libGConf-devel

# Mozilla requires
BuildRequires:	libnspr-devel       >= 4.9.2-alt1
BuildRequires:	libnss-devel        >= 3.15.1-alt1
BuildRequires:	libnss-devel-static >= 3.15.1-alt1

# Python requires
BuildRequires: python-module-distribute
BuildRequires: python-modules-compiler
BuildRequires: python-modules-logging
BuildRequires: python-modules-sqlite3
BuildRequires: python-modules-json

%set_autoconf_version 2.13
%add_findprov_lib_path %sm_prefix

%description
SeaMonkey is an open-source web browser, designed for standards
compliance, performance and portability.

%if_with lightning
%package lightning
%define lightning_ciddir %sm_arch_extensionsdir/\{e2fda1a4-762b-4020-b5ad-a41df1933103\}
Summary: An integrated calendar for Seamonkey
Group: Office
Url: http://www.mozilla.org/projects/calendar/lightning/
Requires: %name = %epoch:%version-%release

%description lightning
An integrated calendar for Seamonkey.
%endif

%package devel
Summary:	Seamonkey development kit.
Group:		Development/C++
Requires: %name = %epoch:%version-%release

Requires:	python-base
AutoReq:	yes, nopython

%description devel
Seamonkey development kit.

%package -n rpm-build-seamonkey
Summary: 	RPM helper macros to rebuild seamonkey packages
Group:		Development/Other
BuildArch:	noarch

Requires:	mozilla-common-devel
Requires:	rpm-build-mozilla.org

%description -n rpm-build-seamonkey
These helper macros provide possibility to rebuild
seamonkey packages by some Alt Linux Team Policy compatible way.

%prep
%setup

### Moved enigmail to mailnews
%if_with enigmail
tar -xf %SOURCE6 -C mailnews/extensions/
%endif

%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p0
%if_with system_mozldap
%patch5 -p1 -b .mozldap
%endif
%patch6 -p2
%patch7 -p2
#%%patch8 -p2
%patch9 -p2

# https://bugzilla.altlinux.org/30322
%ifarch %{ix86}
pushd mozilla
%patch10 -p2
popd
%endif

### Copying .mozconfig to build directory
cp -f %SOURCE7 .mozconfig

%if_with lightning
echo 'ac_add_options --enable-calendar' >> .mozconfig
%endif

%build
%add_optflags %optflags_shared
%add_findprov_lib_path %sm_prefix

# Add fake RPATH
rpath="/$(printf %%s '%sm_prefix' |tr '[:print:]' '_')"
export LDFLAGS="$LDFLAGS -Wl,-rpath,$rpath"
export LIBIDL_CONFIG=/usr/bin/libIDL-config-2

export MOZ_BUILD_APP=suite

%ifarch x86_64
export CFLAGS="$CFLAGS -DHAVE_USR_LIB64_DIR=1"
%endif

export PREFIX="%_prefix"
export LIBDIR="%_libdir"
export SHELL="/bin/bash"
export srcdir="$PWD"
export MOZILLA_SRCDIR="$srcdir/mozilla"

autoconf

# On x86 architectures, Mozilla can build up to 4 jobs at once in parallel,
# however builds tend to fail on other arches when building in parallel.
%ifarch %ix86 x86_64
[ "%__nprocs" -ge 2 ] && MOZ_SMP_FLAGS=-j2
[ "%__nprocs" -ge 4 ] && MOZ_SMP_FLAGS=-j4
%endif

# a kludge since 2.26 ...
mkdir objdir
ln -s ../objdir mozilla/objdir

%make_build -f client.mk build \
	mozappdir=%sm_prefix \
	STRIP="/bin/true" \
	MOZ_MAKE_FLAGS="$MOZ_SMP_FLAGS"

%if_with enigmail
cd mailnews/extensions/enigmail
    ./makemake -r
cd -

dir="$PWD/objdir"

cd $dir/mailnews/extensions/enigmail
	make \
		STRIP="/bin/true" \
		MOZ_MAKE_FLAGS="$MOZ_SMP_FLAGS"
	make xpi
	mv -f -- $dir/mozilla/dist/bin/enigmail-*.xpi $dir/mozilla/dist/xpi-stage/
	make clean
cd -
%endif

%install
dir="$PWD/objdir"

mkdir -p \
	%buildroot/%_bindir \
	%buildroot/%sm_prefix/plugins \
	%buildroot/%sm_arch_extensionsdir \
	%buildroot/%sm_noarch_extensionsdir \
	%buildroot/%_datadir/applications \
	#

%makeinstall -C objdir \
	idldir=%buildroot/%sm_idldir \
	includedir=%buildroot/%sm_includedir \
	mozappdir=%buildroot/%sm_prefix \
	#

ln -sf -- $(relative "%sm_noarch_extensionsdir" "%sm_prefix/") \
    %buildroot/%sm_prefix/extensions-noarch

(set +x
    for f in %buildroot/%sm_develdir/*; do
	[ -L "$f" ] || continue

	t="$(readlink "$f")"
	r="$(relative "${t#%buildroot}" "${f#%buildroot}")"

	ln -vnsf -- "$r" "$f"
    done
)

(set +x
    rm -vrf -- %buildroot/%sm_prefix/dictionaries/*
    for suf in aff dic; do
	t="$(relative %_datadir/myspell/en_US.$suf %sm_prefix/dictionaries/)"
	ln -vs "$t" %buildroot/%sm_prefix/dictionaries/en-US.$suf
    done
)

rm -rf -- \
	%buildroot/%_bindir/seamonkey \
	%buildroot/%sm_prefix/js \
	%buildroot/%sm_prefix/regxpcom \
	%buildroot/%sm_prefix/xpcshell \
	%buildroot/%sm_prefix/xpidl \
	%buildroot/%sm_prefix/xpt_dump \
	%buildroot/%sm_prefix/xpt_link \
	%buildroot/%sm_prefix/nsinstall \
	%buildroot/%sm_prefix/removed-files \
	%buildroot/%sm_prefix/seamonkey \
	%buildroot/%sm_prefix/run-mozilla.sh \
	%buildroot/%sm_prefix/README.txt \
	#

dir="$PWD/objdir"

###From Enigmail
%if_with enigmail
mkdir -p %buildroot/%enigmail_ciddir
unzip -q -u -d %buildroot/%enigmail_ciddir -- \
    $dir/mozilla/dist/xpi-stage/enigmail*.xpi
%endif

###From Lightning
%if_with lightning
mkdir -p %buildroot/%lightning_ciddir
unzip -q -u -d %buildroot/%lightning_ciddir -- \
    $dir/dist/xpi-stage/lightning*.xpi

rm -f -- %buildroot/%lightning_ciddir/application.ini
%endif

# rpm-build-seamonkey files
mkdir -p %buildroot/%_sysconfdir/rpm/macros.d
tar -xf %SOURCE8
cp -a rpm-build/rpm.macros.seamonkey %buildroot/%_sysconfdir/rpm/macros.d/%name


# install altlinux-specific configuration
install -D -m 644 %SOURCE5 %buildroot/%sm_prefix/defaults/preferences/all-altlinux.js

# install icons
	install -D suite/branding/nightly/icons/gtk/default16.png \
	%buildroot%_miconsdir/%name.png
	install -D suite/branding/nightly/icons/gtk/default.png \
	%buildroot%_niconsdir/%name.png
	install -D suite/branding/nightly/icons/gtk/%name.png \
	%buildroot%_iconsdir/hicolor/128x128/apps/%name.png

# install search plugins
tar -C %buildroot%sm_prefix -xf %SOURCE2

# install browser menu file
install -D -m 644 %SOURCE3 %buildroot%_datadir/applications/seamonkey-alt-browser.desktop
# install mail menu file
install -D -m 644 %SOURCE4 %buildroot%_datadir/applications/seamonkey-alt-mail.desktop

# main startup script
cat>%buildroot/%_bindir/seamonkey<<-EOF
#!/bin/sh -e
    export MOZ_APP_LAUNCHER="\${MOZ_APP_LAUNCHER:-\$0}"
    export MOZ_PLUGIN_PATH="%browser_plugins_path\${MOZ_PLUGIN_PATH:+:\$MOZ_PLUGIN_PATH}"
    export NSS_SSL_ENABLE_RENEGOTIATION=1
    %sm_prefix/seamonkey-bin \${1:+"\$@"}
EOF


chmod 755 %buildroot/%_bindir/seamonkey

# Add alternatives
mkdir -p %buildroot%_altdir
printf '%_bindir/xbrowser\t%_bindir/%name\t100\n' > %buildroot%_altdir/%name

# Add real RPATH
(set +x
    rpath="/$(printf %%s '%sm_prefix' |tr '[:print:]' '_')"

    find \
	%buildroot/%sm_prefix \
	%buildroot/%sm_develdir \
	%buildroot/%sm_arch_extensionsdir \
    -type f |
    while read f; do
	t="$(readlink -ev "$f")"

	file "$t" | fgrep -qs ELF || continue

	if chrpath -l "$t" | fgrep -qs "RPATH=$rpath"; then
	chrpath -r "%sm_prefix" "$t"
	fi
    done
)

%files
%dir %sm_datadir
%_altdir/%name
%_bindir/%name
%_datadir/applications/*.desktop
%sm_prefix
%sm_noarch_extensionsdir
%_miconsdir/%name.png
%_niconsdir/%name.png
%_iconsdir/hicolor/128x128/apps/%name.png
%if_with lightning
%exclude %lightning_ciddir
%endif

%if_with lightning
%files lightning
%lightning_ciddir
%endif

%files devel
%dir %sm_idldir
%sm_idldir
%sm_includedir
%sm_develdir

%files -n rpm-build-seamonkey
%_sysconfdir/rpm/macros.d/%name

%changelog
