Name: sed
Version: 4.2.2
Release: alt2
Epoch: 1

Summary: A GNU stream text editor
Group: Editors
License: GPLv3+
Url: http://www.gnu.org/software/sed/

%define srcname %name-%version-%release
# git://git.altlinux.org/people/ldv/packages/sed refs/heads/sed-current
Source0: %srcname.tar
# git://git.altlinux.org/people/ldv/packages/sed refs/heads/po-current
Source1: po-%version-%release.tar
Source2: subst.tar
# git://git.altlinux.org/people/ldv/packages/sed sed-current..sed-alt
Patch: %srcname.patch

%def_enable selinux

BuildRequires: gnulib >= 0.0.7901.076ac82

# for acl copying support.
BuildRequires: libacl-devel

%{?_enable_selinux:BuildRequires: libselinux-devel}

%description
The sed (Stream EDitor) editor is a stream or batch (non-interactive)
editor.  Sed takes text as input, performs an operation or set of
operations on the text and outputs the modified text.  The operations
that sed performs (substitutions, deletions, insertions, etc.) can be
specified in a script file or from the command line.

%prep
%setup -n %srcname -a1 -a2
%patch -p1

# Build scripts expect to find package version in this file.
echo -n %version-%release > .tarball-version

# Fix "gettext infrastructure mismatch" error.
sed -i 's/^\(AM_GNU_GETTEXT_VERSION\).*/\1('"$(gettext --version | sed -n 's/^gettext.* \([0-9][^ ]*\)$/\1/p')"')/' configure.ac

# Generate LINGUAS file.
ls po/*.po 2>/dev/null |
	sed 's|.*/||; s|\.po$||' > po/LINGUAS

# Use bootstrap from gnulib
install -pm755 %_datadir/gnulib/build-aux/bootstrap .

# Compress docs for packaging.
bzip2 -9 doc/*.txt
bzip2 -9k NEWS

%build
%make_build -C subst
./subst/subst -p 's,@DOCDIR@,%_docdir/%name-%version,' \
	doc/sed-in.texi doc/sed.x

./bootstrap --force --skip-po --gnulib-srcdir=%_datadir/gnulib
%configure --bindir=/bin
%make_build -C po update-po
%make_build

%install
%makeinstall_std
%makeinstall_std -C subst

%check
%make_build -C testsuite -f Makefile.tests
%make_build -k check

%find_lang %name

%files -f %name.lang
/bin/*
%_bindir/*
%_mandir/man?/*
%_infodir/*.info*
%doc BUGS NEWS.bz2 README THANKS doc/*.txt.bz2

%changelog
