Name: sendmail

%define tarbolversion 8.14.9

Version: %tarbolversion
Release: alt0.M70T.1

Packager: Sergey Y. Afonin <asy@altlinux.ru>

Summary: A widely used Mail Transport Agent (MTA)
License: %sendmail_license
Group: System/Servers
URL: http://www.sendmail.org

Source0: %name.%tarbolversion.tar.gz
Source1: %name.init
Source2: %name-submit.init
Source3: %name-aliases
Source4: %name.sysconfig
Source5: %name-etc-mail-Makefile
Source6: %name-alt.mc

Source7: %name-sasl.conf
Source8: %name.pam
Source10: %name-README.alt
Source11: %name-submit.mc
Source12: %name-rhsbl.m4
Source13: %name-cf-8.13-0.4.1.corvax.tar.bz2
Source14: %name-virtuserdomains
Source15: %name-certs.sh
Source16: %name-milters_watchdog

Source20: %name-access.main
Source21: %name-access.dynamic
Source22: %name-access.spam
Source23: %name-access.virus
Source24: %name-access.other
Source25: %name-access.sendmail.org

# Cyrus-imap integration
Source30: %name-README.cyrus-imap
Source31: %name-mrs.m4
Source32: %name-mrs_cyrus.m4
Source33: %name-cyrusv2.m4
Source34: %name-cyrus-imap-mailertable.mc
Source36: %name-cyrus-imap-localrelay.mc

Source9: %name-real-time.mc
Source106: %name-alt.old.mc
Source134: %name-cyrus-imap-mailertable.old.mc
Source136: %name-cyrus-imap-localrelay.old.mc

Patch0: %name-8.14.0-alt.patch
Patch1: %name-8.10.0-makemapman.patch
Patch2: %name-8.14.3-smrsh.patch
Patch3: %name-8.8.7-rmail.patch
Patch4: %name-8.12.2-aliasesDoS.patch
Patch5: %name-8.11.1-up-limit.patch
Patch6: %name-8.11.0-m4path.patch

# experimental
Patch7: %name-8.14.4-BODY_7BIT_IGNORED-srvrsmtp.c.patch

# Cyrus-imap integration
Patch10: %name-mrs-8.12.11.patch

Patch50: %name-contrib-expn.pl-tempfile.patch

#errata
#Patch100:

%add_findreq_skiplist */include/*

Provides: MTA, MailTransportAgent, smtpdaemon

Conflicts: postfix, meta1, exim-common

PreReq: sendmail-common
Requires: %name-submit = %{version}-%{release}, makemap = %{version}-%{release}

BuildConflicts: bind-devel
BuildPreReq: libpam0-devel rpm-build-licenses

# Not detected by buildreq
BuildRequires: openssl
# Automatically added by buildreq on Thu Apr 21 2005
BuildRequires: glibc-devel groff-base libdb4-devel libgdbm-devel libldap-devel libsasl2-devel libssl-devel libwrap-devel

%description
The Sendmail program is a widely used Mail Transport Agent (MTA).
MTAs send mail from one machine to another.

Sendmail is not a client program, which you use to read your e-mail.
Sendmail is a behind-the-scenes program which actually moves your
e-mail over networks or the Internet to where you want it to go.

If you ever need to reconfigure Sendmail, you'll also need to have the
sendmail-cf package installed. If you need documentation on Sendmail,
you can install the sendmail-doc package (sendmail-doc contains ALT Linux
specific recomendations README.alt and README.cyrus-imap).

%package submit
Summary: sendmail's submit service
License: %sendmail_license
Group: System/Servers
Conflicts: postfix
AutoReq: yes, noshell

%description submit
This package need for sending mail from command line

%package -n makemap
Summary: makemap utility of sendmail
License: %sendmail_license
Group: Databases

%description -n makemap
Makemap creates the database maps used by the keyed map lookups in
sendmail(8) and in some other software. It's working with Berkeley DB.

%package doc
Summary: Documentation about the Sendmail Mail Transport Agent program
License: %sendmail_license
Group: System/Servers
AutoReq: yes, noshell
Conflicts: %name < %version-%release, %name > %version-%release
BuildArch: noarch

%description doc
The %name-doc package contains documentation about the Sendmail
Mail Transport Agent (MTA) program, including release notes, the
Sendmail FAQ and a few papers written about Sendmail. The papers are
provided in PostScript(TM) and troff formats.

Install the %name-doc package if you need documentation about
Sendmail.

%package cf
Summary: The files needed to reconfigure Sendmail
License: %sendmail_license
Group: System/Servers
Requires: make, m4
Conflicts: %name < %version-%release, %name > %version-%release
BuildArch: noarch

%description cf
This package includes the configuration files which you'd need to generate the
%name.cf file distributed with the %name package.

You'll need the %name-cf package if you ever need to reconfigure and rebuild
your %name.cf file. For example, the default %name.cf file is not
configured for UUCP. If someday you needed to send and receive mail over UUCP,
you'd need to install the %name-cf package to help you reconfigure Sendmail.

Install the %name-cf package if you need to reconfigure your
%name.cf file.

%package devel
Summary: Sendmail static libraries and headers file
Group: Development/Other
Requires: libmilter = %{version}-%{release}
Conflicts: %name < %version-%release, %name > %version-%release

%description devel
This package includes the static libraries and header files

%package -n libmilter
Summary: Sendmail's shared libraries (libmilter only)
Group: System/Libraries
Conflicts: %name < %version-%release, %name > %version-%release
Provides: sendmail-libs

%description -n libmilter
This package includes the shared libraries of Senadmail (now only 
libmilter.so). Main packadge isn't use shared libraries.

%package -n vacation
Summary: E-mail auto-responder
Group: Networking/Mail

%description -n vacation
Vacation returns a message, ~/.vacation.msg by default, to the sender informing 
them that you are currently not reading your mail.

%prep
%setup -q -n %name-%tarbolversion
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1

%patch10 -p1

%patch50 -p1

#errata
#patch100 -p0

%__sed -e 's|@@PATH@@|\.\.|' < %SOURCE6 > cf/cf/altlinux.mc
%__sed -e 's|@@PATH@@|\.\.|' < %SOURCE11> cf/cf/submit.mc
%__sed -e 's|@@PATH@@|\.\.|' < %SOURCE34> cf/cf/cyrus-imap-mailertable.mc
%__sed -e 's|@@PATH@@|\.\.|' < %SOURCE36> cf/cf/cyrus-imap-localrelay.mc

%__cp %{SOURCE31} cf/feature/mrs.m4
%__cp %{SOURCE32} cf/feature/mrs_cyrus.m4
%__cp -f %{SOURCE33} cf/mailer/cyrusv2.m4

#__tar xjf %{SOURCE13} -C cf

%build
%make_build
#CFLAGS="$RPM_OPT_FLAGS %optflags_shared"

pushd cf/cf
m4 altlinux.mc > altlinux.cf
#m4 real-time.mc > real-time.cf
m4 cyrus-imap-mailertable.mc > cyrus-imap-mailertable.cf
m4 cyrus-imap-localrelay.mc > cyrus-imap-localrelay.cf
popd

%install
for i in %_bindir %_libdir %_mandir/man{1,5,8} %_sbindir %_logdir %_spooldir %_datadir/%name-cf %_initdir %_sysconfdir/sysconfig %_spooldir/mqueue/queue00{1,2} %_sysconfdir/smrsh %_sysconfdir/mail %_spooldir/clientmqueue var/run/%name %_sysconfdir/pam.d %_includedir ; do
	%__mkdir_p "$RPM_BUILD_ROOT/$i"
done

OBJDIR=obj.$(uname -s).$(uname -r).$(arch)

# fix default id and gid during install steps
export ID=" SBINOWN=`id -nu` UBINOWN=`id -nu` \
	    SBINGRP=`id -ng` UBINGRP=`id -ng` \
	    MSPQOWN=`id -nu` GBINGRP=`id -ng` \
	    GBINOWN=`id -nu` \
	    CFOWN=`id -nu` CFGRP=`id -ng` \
	    BINOWN=`id -nu` BINGRP=`id -ng` \
	    MANOWN=`id -nu` MANGRP=`id -ng` \
	    LIBOWN=`id -nu` LIBGRP=`id -ng` LIBMODE=644 \
	    INCOWN=`id -nu` INCGRP=`id -ng` INCMODE=644 \
	    MANROOT=%_mandir/man CFMODE=0644"

%makeinstall LIBDIR=%_libdir DESTDIR=$RPM_BUILD_ROOT CF=real-time $ID
rm -f $RPM_BUILD_ROOT%_libdir/*.a

#mailq and newaliases provided by sendmail-common package
rm -f $RPM_BUILD_ROOT%_bindir/{mailq,newaliases}

%make_build DESTDIR=$RPM_BUILD_ROOT $ID force-install -C $OBJDIR/rmail
%make_build DESTDIR=$RPM_BUILD_ROOT $ID force-install -C $OBJDIR/mail.local

# generate shared libmilter
pushd $OBJDIR
rm -f libmilter/*.a
cd libmilter
gcc -shared -o libmilter.so.3 -Wl,-soname,libmilter.so.3 *.o -lpthread
cd ..
popd

# install include & libs
#find $OBJDIR/lib* -name "*.a" -exec %__cp {} $RPM_BUILD_ROOT%_libdir \;
find $OBJDIR/lib* -name "*.so*" -exec %__cp {} $RPM_BUILD_ROOT%_libdir \;

# genegate symlink for *.so (only libmilter.so.2 now)
pushd $RPM_BUILD_ROOT%_libdir
find *.so.* -type f|\
 while read f; do \
    temp_name=`echo -n $f|sed -r "s/^(\w+)\..*/\1/g"`; \
    %__ln_s -f $f $temp_name.so; \
 done
popd

%__ln_s -f ../sbin/makemap $RPM_BUILD_ROOT%_bindir/makemap

%__cp -ar include $RPM_BUILD_ROOT%prefix

# install docs by hand
%__mkdir_p $RPM_BUILD_DIR/%name-%tarbolversion/docs
%__cp -ar FAQ LICENSE KNOWNBUGS README RELEASE_NOTES doc $RPM_BUILD_DIR/%name-%tarbolversion/docs/
%__cp smrsh/README $RPM_BUILD_DIR/%name-%tarbolversion/docs/README.smrsh
%__cp sendmail/README $RPM_BUILD_DIR/%name-%tarbolversion/docs/README.sendmail
%__cp sendmail/SECURITY $RPM_BUILD_DIR/%name-%tarbolversion/docs/
%__cp sendmail/TRACEFLAGS $RPM_BUILD_DIR/%name-%tarbolversion/docs/
%__cp sendmail/TUNING $RPM_BUILD_DIR/%name-%tarbolversion/docs/
%__cp mail.local/README $RPM_BUILD_DIR/%name-%tarbolversion/docs/README.mail.local
%__cp cf/README $RPM_BUILD_DIR/%name-%tarbolversion/docs/README.cf
%__cp cf/cf/README $RPM_BUILD_DIR/%name-%tarbolversion/docs/README.install-cf
%__cp %SOURCE10 $RPM_BUILD_DIR/%name-%tarbolversion/docs/README.alt
%__cp %SOURCE30 $RPM_BUILD_DIR/%name-%tarbolversion/docs/README.cyrus-imap
%__cp libmilter/README $RPM_BUILD_DIR/%name-%tarbolversion/docs/README.libmilter
%__cp -ar libmilter/docs/ $RPM_BUILD_DIR/%name-%tarbolversion/docs/libmilter
%__cp %SOURCE15 $RPM_BUILD_DIR/%name-%tarbolversion/docs/

# Dadou: Remove ugly bad dependencies in doc package
find contrib -type f |xargs fgrep -l /usr/local/bin/perl |
	xargs -r %__subst -p 's|/usr/local/bin/perl|%_bindir/perl|g'

#	perl -pi -e 's|/usr/local/bin/perl|%_bindir/perl|g'
find contrib -type f |xargs fgrep -l '!/bin/perl' |
	xargs -r %__subst -p 's|#!/bin/perl|%_bindir/perl|g'

#	xargs -r perl -pi -e 's|#!/bin/perl|#!%_bindir/perl|g'

# install the cf files
%make_build DESTDIR=$RPM_BUILD_ROOT $ID CF=altlinux install-cf -C cf/cf
pushd cf
%__cp -ar * $RPM_BUILD_ROOT%_datadir/%name-cf
%__rm -f $RPM_BUILD_ROOT%_datadir/%name-cf/*/*.m4path
%__make -C cf altlinux.cf
popd

# Create /etc/mail/ files

%__sed -e 's|@@PATH@@|%_datadir/%name-cf|' < %SOURCE6 > $RPM_BUILD_ROOT%_sysconfdir/mail/%name-alt.mc
%__sed -e 's|@@PATH@@|%_datadir/%name-cf|' < %SOURCE11> $RPM_BUILD_ROOT%_sysconfdir/mail/submit.mc

echo "# local-host-names - include all aliases for your machine here." > $RPM_BUILD_ROOT%_sysconfdir/mail/local-host-names
echo -n >$RPM_BUILD_ROOT%_logdir/%name.st
( echo "# trusted-users - users that can send mail as others without a warning"
echo "# apache, mailman, majordomo, uucp, are good candidates" ) \
	> $RPM_BUILD_ROOT%_sysconfdir/mail/trusted-users

# /etc/mail/access parts
%__mkdir_p $RPM_BUILD_ROOT/%_sysconfdir/mail/access.d.shared
%__mkdir_p $RPM_BUILD_ROOT/%_sysconfdir/mail/access.d
%__sed -e 's|@@NAMEDOCVERSION@@|%name-doc-%version|' < %SOURCE20 > $RPM_BUILD_ROOT%_sysconfdir/mail/access.main
%__cp %SOURCE21 $RPM_BUILD_ROOT%_sysconfdir/mail/access.d.shared/dynamic.access
%__cp %SOURCE22 $RPM_BUILD_ROOT%_sysconfdir/mail/access.d.shared/spam.access
%__cp %SOURCE23 $RPM_BUILD_ROOT%_sysconfdir/mail/access.d.shared/virus.access
%__cp %SOURCE24 $RPM_BUILD_ROOT%_sysconfdir/mail/access.d/other.access
%__cp %SOURCE25 $RPM_BUILD_ROOT%_sysconfdir/mail/access.d/sendmail.org.access

for map in virtusertable access domaintable mailertable; do
    touch $RPM_BUILD_ROOT%_sysconfdir/mail/${map}
    %__chmod 0644 $RPM_BUILD_ROOT%_sysconfdir/mail/${map}
done
%__install -m644 %SOURCE3 $RPM_BUILD_ROOT%_sysconfdir/mail/aliases
%__install -m644 %SOURCE14 $RPM_BUILD_ROOT%_sysconfdir/mail/virtuserdomains
%__install -m644 %SOURCE5 $RPM_BUILD_ROOT%_sysconfdir/mail/Makefile

%__ln_s %_sysconfdir/mail/aliases $RPM_BUILD_ROOT%_sysconfdir/aliases

# other /etc/
%__install -m644 %SOURCE4 $RPM_BUILD_ROOT%_sysconfdir/sysconfig/%name
%__install -m755 %SOURCE1 $RPM_BUILD_ROOT%_initdir/%name
%__install -m755 %SOURCE2 $RPM_BUILD_ROOT%_initdir/%name-submit
%__install -m644 %SOURCE8 $RPM_BUILD_ROOT%_sysconfdir/pam.d/smtp

# configugations for libsasl2 in /etc/sasl2/ in AltLinux
%__install -m755 -d $RPM_BUILD_ROOT/%_sysconfdir/sasl2
%__install -m644 %SOURCE7 $RPM_BUILD_ROOT/%_sysconfdir/sasl2//Sendmail.conf

# add certs directory for STARTTLS
%__mkdir -p $RPM_BUILD_ROOT/%_sysconfdir/mail/certs
## create placeholder certs
#pushd $RPM_BUILD_ROOT/%_sysconfdir/mail/certs
#sh %{SOURCE15}
#popd

# create fake *.db
pushd $RPM_BUILD_ROOT/%_sysconfdir/mail
touch access.db domaintable.db mailertable.db virtusertable.db
popd

%__install -m755 %SOURCE16 %buildroot%_bindir/sendmail-milters_watchdog
%__install -m755 -d %buildroot%_sysconfdir/cron.d
cat <<EOF >%buildroot%_sysconfdir/cron.d/sendmail-milters_watchdog
#*/5 * * * *       root    %_bindir/sendmail-milters_watchdog
EOF
cat <<EOF >%buildroot%_sysconfdir/mail/milters_watchdog.conf
#MILTERS_LIST="mailfromd"
EOF

%pre

%post

# rebuild *.db (possibe new DB)
{
    pushd %_sysconfdir/mail
    touch virtusertable access domaintable mailertable aliases
    make db
    popd
} &>/dev/null ||:

%post_service %name

%preun
%preun_service %name

%pre submit
%_sbindir/groupadd -r -f smmsp
%_sbindir/useradd -M -r -g smmsp -s /dev/null -c smmsp smmsp &>/dev/null ||:

%post submit
%post_service %name-submit

%preun submit
%preun_service %name-submit

%files
%_bindir/hoststat
%_bindir/purgestat
%_bindir/rmail
%_bindir/sendmail-milters_watchdog

%_sbindir/editmap
%_sbindir/mail.local
%_sbindir/mailstats
%_sbindir/praliases
%_sbindir/smrsh

%attr(644,root,root) %_mandir/man?/*
%exclude  %_mandir/man1/vacation.*
%exclude  %_mandir/man8/makemap.*
%attr(640,root,root) %_logdir/%name.st
%attr(640,root,root) %_logdir/statistics

%dir %_sysconfdir/smrsh

%dir %_sysconfdir/mail/certs
#%attr(0600,root,root) %config(noreplace) %_sysconfdir/mail/certs/*

%attr(0444,root,wheel) %config(noreplace) %_sysconfdir/mail/%name.cf

%exclude %_sysconfdir/mail/submit.mc
%attr(0644,root,root) %config %_sysconfdir/mail/*.mc

%attr(0640,root,root) %config(noreplace) %_sysconfdir/mail/local-host-names
%attr(0640,root,root) %config(noreplace) %_sysconfdir/mail/trusted-users
%attr(0640,root,root) %config(noreplace) %_sysconfdir/mail/aliases
%_sysconfdir/aliases
%attr(0644,root,root) %config(noreplace) %_sysconfdir/mail/virtuserdomains
%attr(0644,root,root) %config(noreplace) %_sysconfdir/mail/virtusertable

%ghost %_sysconfdir/mail/*.db

%ghost %_sysconfdir/mail/access
%config(noreplace) %_sysconfdir/mail/access.main
%dir %_sysconfdir/mail/access.d
%config(noreplace) %_sysconfdir/mail/access.d/*.access
%dir %_sysconfdir/mail/access.d.shared
%config(noreplace) %_sysconfdir/mail/access.d.shared/*.access

%attr(0644,root,root) %config(noreplace) %_sysconfdir/mail/domaintable
%attr(0644,root,root) %config(noreplace) %_sysconfdir/mail/mailertable
%attr(0640,root,root) %config(noreplace) %_sysconfdir/mail/helpfile
%attr(0644,root,root) %config(noreplace) %_sysconfdir/mail/milters_watchdog.conf

%config(noreplace) %_sysconfdir/sysconfig/%name

%config %_sysconfdir/mail/Makefile

%attr(0755,root,root) %config(noreplace) %_initdir/%name

%attr(0750,root,wheel) %dir %_spooldir/mqueue
%attr(0750,root,wheel) %dir %_spooldir/mqueue/queue*

%config(noreplace) %_sysconfdir/sasl2/Sendmail.conf
%config(noreplace) %_sysconfdir/pam.d/smtp
%config(noreplace) %_sysconfdir/cron.d/*
%doc docs/LICENSE

%files submit
%dir %_sysconfdir/mail
%attr(2711,root,smmsp) %_sbindir/%name
%attr(0444,root,wheel) %config(noreplace) %_sysconfdir/mail/submit.cf
%attr(0644,root,root) %config %_sysconfdir/mail/submit.mc
%attr(0770,smmsp,smmsp) %dir %_spooldir/clientmqueue
%ghost %dir /var/run/%name
%attr(0755,root,root) %config(noreplace) %_initdir/%name-submit
%doc docs/LICENSE

%files -n makemap
%_bindir/makemap
%_sbindir/makemap
%_mandir/man8/makemap.*
%doc docs/LICENSE

%files cf
%_datadir/%name-cf

%files doc
%doc contrib docs

%files devel
%doc libsm/{*.html,README} docs/{libmilter,README.libmilter}
%_includedir/lib*
%_includedir/sendmail
%_includedir/sm
%_libdir/lib*.so

%files -n libmilter
%exclude %_libdir/lib*.so
%_libdir/lib*.so*

%files -n vacation
%_bindir/vacation
%_mandir/man1/vacation.*
%doc docs/LICENSE

%changelog
