Name:       sensorfw
Summary:    Sensor Framework
Version:    0.7.2
Group:      System/Kernel and hardware
Release:    alt1.83.3
License:    LGPLv2+
URL:        http://gitorious.org/sensorfw
Source0:    %{name}-%{version}.tar.gz
Source1:    sensorfw-rpmlintrc
Source2:    sensord.service
Source3:    sensord-daemon-conf-setup
Source4:    sensord-aava.conf
Source5:    sensord-icdk.conf
Source6:    sensord-exopc.conf
Source7:    sensord-mrst_cdk.conf
Source8:    sensord-oaktrail.conf
Source9:    sensord-sysconfig.filetrigger
Source100:  sensorfw.yaml
Patch0:     sensorfw-0.7.1-tests-directories.patch
Patch1:     sensorfw-0.7.1-pegatron-accel.patch
Patch2:     sensorfw-0.7.1-oemtablet-accel.patch
Patch3:     sensorfw-0.7.1-oaktrail-accel.patch
Patch4:     sensorfw-0.7.1-oemtablet-als.patch
Patch5:     sensorfw-0.7.1-oemtablet-gyroscope.patch
Patch6:     sensorfw-0.7.1-alsadaptor-ascii-rangefile.patch
Patch7:     fix-initctl.patch
Patch8:     fix-missing-unistd.h.patch
Patch9:     fix-method-call.patch
Patch10:    fix-project-libs.patch
#Requires:   qt
#Requires:   GConf-dbus
Requires:   %{name}-configs
#Requires:   systemd
#Requires(preun): systemd
#Requires(post): /sbin/ldconfig
#Requires(post): systemd
#Requires(postun): /sbin/ldconfig
#Requires(postun): systemd
BuildRequires:  pkgconfig(QtCore)
BuildRequires:  pkgconfig(gconf-2.0)
BuildRequires:  pkgconfig(contextprovider-1.0)
BuildRequires:  doxygen
BuildRequires:  graphviz
BuildRequires:  gcc-c++
BuildRequires:  gdb
Obsoletes:   sensorframework


%description
Sensor Framework provides an interface to hardware sensor drivers through logical sensors. This package contains sensor framework daemon and required libraries.



%package devel
Summary:    Sensor framework daemon libraries development headers
Group:      Development/C++
Requires:   %{name} = %{version}-%{release}
#Requires:   qt-devel

%description devel
Development headers for sensor framework daemon and libraries.


%package tests
Summary:    Unit test cases for sensord
Group:      Development/C++
Requires:   %{name} = %{version}-%{release}
#Requires:   testrunner-lite
#Requires:   python

%description tests
Contains unit test cases for CI environment.


%package contextfw-tests
Summary:    Test cases for sensord acting as context provider
Group:      Development/C++
Requires:   %{name} = %{version}-%{release}
#Requires:   sensorfw-tests
#Requires:   contextkit >= 0.3.6

%description contextfw-tests
Contains test cases for CI environment, for ensuring that sensord provides context properties correctly.


%package doc
Summary:    API documentation for libsensord
Group:      Development/Documentation
Requires:   %{name} = %{version}-%{release}

%description doc
Doxygen-generated API documentation for sensord.


%package configs
Summary:    Sensorfw configuration files
Group:      System/Configuration/Other
BuildArch:    noarch
Requires:   %{name} = %{version}
Provides:   sensord-config
Provides:   config-n900
Provides:   config-aava
Provides:   config-icdk
Provides:   config-ncdk
Provides:   config-oemtablet
Provides:   config-oaktrail

%description configs
Sensorfw configuration files.



%prep
%setup -q -n %{name}-%{version}

# sensorfw-0.7.1-tests-directories.patch
%patch0 -p1
# sensorfw-0.7.1-pegatron-accel.patch
%patch1 -p1
# sensorfw-0.7.1-oemtablet-accel.patch
%patch2 -p1
# sensorfw-0.7.1-oaktrail-accel.patch
%patch3 -p1
# sensorfw-0.7.1-oemtablet-als.patch
%patch4 -p1
# sensorfw-0.7.1-oemtablet-gyroscope.patch
%patch5 -p1
# sensorfw-0.7.1-alsadaptor-ascii-rangefile.patch
%patch6 -p1
# fix-initctl.patch
%patch7 -p2
# fix-missing-unistd.h.patch
%patch8 -p1
# fix-method-call.patch
%patch9 -p1
# fix-project-libs.patch
%patch10
# >> setup
# << setup
find . -type f -name \*.pr\? | while read f; do sed -i 's|/usr/lib|%_libdir|' $f; done

%build
#unset LD_AS_NEEDED
# >> build pre
#export LD_RUN_PATH=/usr/lib/sensord/
# << build pre

PATH=$PATH:%_qt4dir/bin qmake \
    CONFIG+=mce_disable

%make_build

# >> build post
# << build post
%install
rm -rf %{buildroot}
# >> install pre
# << install pre
%make_install INSTALL_ROOT=%buildroot install

# >> install post
install -D -m644 %{SOURCE2} $RPM_BUILD_ROOT/%{_lib}/systemd/system/sensord.service
install -D -m750 %{SOURCE3} $RPM_BUILD_ROOT/%{_bindir}/sensord-daemon-conf-setup
install -m644 %{SOURCE4} $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/
install -m644 %{SOURCE5} $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/
install -m644 %{SOURCE6} $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/
install -m644 %{SOURCE7} $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/
install -m644 %{SOURCE8} $RPM_BUILD_ROOT%{_sysconfdir}/%{name}/
install -D -m755 sensord.init %buildroot%_initdir/sensord

mkdir -p %{buildroot}/%{_lib}/systemd/system/basic.target.wants
ln -s ../sensord.service %{buildroot}/%{_lib}/systemd/system/basic.target.wants/sensord.service
# << install post

# Install the filetrigger for sensord sysconfig
install -D -m755 %{SOURCE9} %buildroot%_rpmlibdir/sensord-sysconfig.filetrigger

# Generate the default sysconfig for sensord:
mkdir -p -m0755 %buildroot%_sysconfdir/sysconfig
SYSCONFDIR="%buildroot%_sysconfdir" %{SOURCE9}


#%preun
#if systemctl -q is-active sensord.service; then systemctl stop sensord.service; fi

#%post
#/sbin/ldconfig
#if systemctl daemon-reload; then systemctl reload-or-try-restart sensord.service; fi

#%postun
#/sbin/ldconfig
#systemctl daemon-reload ||:

%files
%defattr(-,root,root,-)
# >> files
%attr(755,root,root)%{_sbindir}/sensord
%dir %{_libdir}/sensord
%{_libdir}/sensord/*.so
%{_libdir}/*.so.*
%config %{_sysconfdir}/dbus-1/system.d/sensorfw.conf
%config %{_sysconfdir}/sensorfw/sensord.conf
%dir %{_sysconfdir}/%{name}
%dir %{_sysconfdir}/%{name}/sensord.conf.d/
%{_datadir}/contextkit/providers/com.nokia.SensorService.context
%doc debian/copyright debian/README COPYING
/%{_lib}/systemd/system/sensord.service
/%{_lib}/systemd/system/basic.target.wants/sensord.service
%exclude %{_bindir}/sensord-daemon-conf-setup
%_initdir/sensord
%_rpmlibdir/sensord-sysconfig.filetrigger
%{_sysconfdir}/sysconfig/sensord
# << files


%files devel
%defattr(-,root,root,-)
# >> files devel
%{_libdir}/*.so
%{_libdir}/pkgconfig/*
%dir %{_includedir}/sensord
%{_includedir}/sensord/*
%{_datadir}/qt4/mkspecs/features/sensord.prf
# << files devel

%files tests
%defattr(-,root,root,-)
# >> files tests
%dir %{_libdir}/sensord/testing
%{_libdir}/sensord/testing/*
%dir %{_datadir}/sensorfw-tests
%attr(755,root,root)%{_datadir}/sensorfw-tests/*.p*
%attr(644,root,root)%{_datadir}/sensorfw-tests/*.xml
%attr(644,root,root)%{_datadir}/sensorfw-tests/*.conf
%attr(755,root,root)%{_bindir}/*
%exclude %_bindir/sensord-daemon-conf-setup
# << files tests

%files contextfw-tests
%defattr(-,root,root,-)
# >> files contextfw-tests
%dir %{_datadir}/sensorfw-contextfw-tests
%attr(755,root,root)%{_datadir}/sensorfw-contextfw-tests/*.sh
%attr(755,root,root)%{_datadir}/sensorfw-contextfw-tests/*.p*
%attr(644,root,root)%{_datadir}/sensorfw-contextfw-tests/*.xml
# << files contextfw-tests

%files doc
%defattr(-,root,root,-)
# >> files doc
%dir %{_defaultdocdir}/sensord
%dir %{_defaultdocdir}/sensord/html
%attr(644,root,root)%{_defaultdocdir}/sensord/html/*
# << files doc

%files configs
%defattr(-,root,root,-)
# >> files configs
%config %{_sysconfdir}/%{name}/sensord.conf.d/*.conf
%config %{_sysconfdir}/%{name}/*.conf
%exclude %{_sysconfdir}/sensorfw/sensord.conf
# << files configs

%changelog
