Packager: Igor Vlasenko <viy@altlinux.ru>
BuildRequires: cssparser apache-commons-discovery
BuildRequires: /proc
BuildRequires: jpackage-compat
# Copyright (c) 2000-2008, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#


# If you don't want to build with maven, and use straight ant instead,
# give rpmbuild option '--without maven'

%define with_maven %{!?_without_maven:1}%{?_without_maven:0}
%define without_maven %{?_without_maven:1}%{!?_without_maven:0}

# Optionally omit build of shale-tiles while bootstrapping
%define bootstrap %{?_with_bootstrap:1}%{!?_with_bootstrap:%{?_without_bootstrap:0}%{!?_without_bootstrap:%{?_bootstrap:%{_bootstrap}}%{!?_bootstrap:0}}}
# Set to true for now, as module not compatible with current tiles2 
%define bootstrap 1


Name:           shale
Version:        1.0.4
Release:        alt12_1jpp5
Epoch:          0
Summary:        Shale Framework
License:        Apache Software License 2.0
Group:          Development/Java
URL:            http://shale.apache.org/
Source0:        http://www.apache.org/dist/shale/framework/shale-framework-1.0.4.zip

Source1:        %{name}-master-2.pom
Source2:        %{name}-jpp-depmap.xml
Source3:        %{name}-settings.xml
Source4:        %{name}-autogenerated-files.tar.gz
Patch0:         %{name}-test-pom.patch
Patch1:         %{name}-test-CargoTestSetup.patch
Patch2:         %{name}-dialog-basic-pom.patch
Patch3:         %{name}-pom.patch
Patch4:         %{name}-notiles-pom.patch

Patch33: shale-alt-no-site-pom.patch


BuildArch:      noarch
BuildRequires: jpackage-utils >= 0:1.7.4
BuildRequires: ant >= 0:1.6.5
BuildRequires: ant-junit3
BuildRequires: junit3
%if %{with_maven}
BuildRequires: maven2-common-poms
BuildRequires: maven2 >= 0:2.0.7
BuildRequires: maven2-plugin-ant
BuildRequires: maven2-plugin-antrun
BuildRequires: maven2-plugin-compiler
BuildRequires: maven2-plugin-install
BuildRequires: maven2-plugin-jar
BuildRequires: maven2-plugin-javadoc
BuildRequires: maven2-plugin-plugin
BuildRequires: maven2-plugin-resources
BuildRequires: maven-surefire-plugin
BuildRequires: maven2-plugin-war
BuildRequires: mojo-maven2-plugin-cobertura
%endif
BuildRequires: cargo
BuildRequires: el_1_0_api
BuildRequires: htmlunit1
BuildRequires: apache-commons-beanutils
BuildRequires: apache-commons-chain
BuildRequires: apache-commons-collections
BuildRequires: apache-commons-digester
BuildRequires: apache-commons-logging
BuildRequires: apache-commons-scxml
BuildRequires: apache-commons-validator
BuildRequires: jmock1
BuildRequires: jsf_1_2_api
BuildRequires: jsp_2_1_api
BuildRequires: myfaces
BuildRequires: servlet_2_5_api
#BuildRequires: spring-beans
#BuildRequires: spring-context
#BuildRequires: spring-core
#BuildRequires: spring-web
%if ! %{bootstrap}
BuildRequires: tiles
%endif

Requires: apache-commons-logging >= 0:1.1
Requires: el_1_0_api
Requires: jsf_1_2_api
Requires: jsp_2_1_api
Requires: servlet_2_5_api

Requires(post): jpackage-utils >= 0:1.7.4
Requires(postun): jpackage-utils >= 0:1.7.4

%description
Shale is a modern web application framework, fundamentally 
based on JavaServer Faces. Architecturally, Shale is a set 
of loosely coupled services that can be combined as needed 
to meet particular application requirements. Shale provides 
additional functionality such as application event callbacks, 
dialogs with conversation-scoped state, a view technology 
called Clay, annotation-based functionality to reduce 
configuration requirements and support for remoting. Shale 
also provides integration links for other frameworks, to ease 
development when combinations of technologies are required.

%package application
Summary:        Shale Application Control
Group:          Development/Java
Requires: %{name} = %{epoch}:%{version}-%{release}
Requires: apache-commons-chain
Requires: apache-commons-digester >= 0:1.8

%description application
%{summary}.

%package clay
Summary:        Shale Clay
Group:          Development/Java
Requires: %{name} = %{epoch}:%{version}-%{release}

%description clay
%{summary}.

%package dialog
Summary:        Shale Dialog Manager
Group:          Development/Java
Requires: %{name} = %{epoch}:%{version}-%{release}

%description dialog
%{summary}.

%package dialog-basic
Summary:        Shale Dialog Manager Basic Impl
Group:          Development/Java
Requires: %{name}-dialog = %{epoch}:%{version}-%{release}
Requires: apache-commons-beanutils >= 0:1.7.0
Requires: apache-commons-digester >= 0:1.8

%description dialog-basic
%{summary}.

%package dialog-scxml
Summary:        Shale Dialog Manager SCXML Impl
Group:          Development/Java
Requires: %{name}-dialog = %{epoch}:%{version}-%{release}
Requires: apache-commons-digester >= 0:1.8
Requires: apache-commons-scxml >= 0:0.7

%description dialog-scxml
%{summary}.

%package remoting
Summary:        Shale Remoting
Group:          Development/Java
Requires: %{name} = %{epoch}:%{version}-%{release}
Requires: apache-commons-chain

%description remoting
%{summary}.

%package spring
Summary:        Shale Spring Integration
Group:          Development/Java
Requires: %{name} = %{epoch}:%{version}-%{release}
Requires: spring-beans >= 0:1.2.9
Requires: spring-context >= 0:1.2.9
Requires: spring-core >= 0:1.2.9
Requires: spring-web >= 0:1.2.9

%description spring
%{summary}.

%package test
Summary:        Shale Test Framework
Group:          Development/Java
Requires: htmlunit1
Requires: jmock1
Requires: junit3
Requires: cargo
Requires: %{name} = %{epoch}:%{version}-%{release}

%description test
%{summary}.

%if 0
%package tiger
Summary:        Shale Tiger Extensions
Group:          Development/Java
Requires: %{name} = %{epoch}:%{version}-%{release}
Requires: %{name}-view = %{epoch}:%{version}-%{release}
Requires: apache-commons-digester >= 0:1.8

%description tiger
%{summary}.
%endif

%if ! %{bootstrap}
%package tiles
Summary:        Shale Tiles Integration
Group:          Development/Java
Requires: %{name} = %{epoch}:%{version}-%{release}
Requires: tiles-core

%description tiles
%{summary}.
%endif

%package validator
Summary:        Shale Validator Integration
Group:          Development/Java
Requires: %{name} = %{epoch}:%{version}-%{release}
Requires: apache-commons-validator >= 0:1.3.1
Requires: jakarta-oro

%description validator
%{summary}.

%package view
Summary:        Shale View Controller
Group:          Development/Java
Requires: %{name} = %{epoch}:%{version}-%{release}

%description view
%{summary}.


%package javadoc
Summary:        Javadoc for %{name}
Group:          Development/Documentation
BuildArch: noarch

%description javadoc
%{summary}.

%package manual
Summary:        Documents for %{name}
Group:          Development/Documentation
BuildArch: noarch

%description manual
%{summary}.

%prep
%setup -q -n %{name}-framework-%{version}
for j in $(find . -name "*.jar"); do
    mv $j $j.no
done
%if %{without_maven}
gzip -dc %{SOURCE4} | tar xf -
%endif
%patch0 -b .sav0
%patch1 -b .sav1
%patch2 -b .sav2
%patch3 -b .sav3
%if %{bootstrap}
# omit tiles while bootstrapping
# always omitting for now
%patch4 -b .sav4
%endif
%patch33 -p0

find . -type d -name site -exec rm -rf {} \; ||:

sed -i -e 's,<module>shale-spring</module>,<!-- module>shale-spring</module -->,' pom.xml

%build

%if %{with_maven}
export MAVEN_REPO_LOCAL=$(pwd)/.m2/repository
mkdir -p $MAVEN_REPO_LOCAL/JPP/maven2/default_poms/
cp %{SOURCE1} .m2/repository/JPP/maven2/default_poms/org.apache.shale-shale-master.pom
install -Dm644 %{SOURCE1} .m2/repository/org/apache/shale/shale-master/2/shale-master-2.pom

mkdir external_repo
ln -s %{_javadir} external_repo/JPP

export M2_SETTINGS=$(pwd)/settings.xml
mvn-jpp -Dmaven.compile.target=1.5 -Dmaven.javadoc.source=1.5  -Dmaven.compile.target=1.5 -Dmaven.javadoc.source=1.5  \
        -e \
        -Dmaven.test.skip=true \
        -Dmaven.test.failure.ignore=true \
        -Dmaven2.jpp.depmap.file=%{SOURCE2} \
        -Dmaven.repo.local=$MAVEN_REPO_LOCAL \
        ant:ant install javadoc:javadoc
%else
#[INFO] Reactor build order: 
#[INFO]   Apache Shale Framework Parent POM
#[INFO]   Shale Test Framework
#[INFO]   Shale Core
#[INFO]   Shale Application Controller
#[INFO]   Shale Clay
#[INFO]   Shale Dialog Manager
#[INFO]   Shale Dialog Manager (Basic Implementation)
#[INFO]   Shale Dialog Manager (SCXML Implementation)
#[INFO]   Shale Remoting
#[INFO]   Shale Spring Integration
#[INFO]   Shale Validator Integration
#[INFO]   Shale View Controller
#[INFO]   Shale Tiger Extensions
export OPT_JAR_LIST="ant/ant-junit3 junit"
export CLASSPATH=$(build-classpath \
cargo/cargo-ant \
cargo/cargo-core-api-container \
cargo/cargo-core-api-generic \
cargo/cargo-core-api-util \
cargo/cargo-core-container-tomcat \
el_1_0_api \
htmlunit \
jmock \
jmock-cglib \
jsf_1_2_api \
servlet_2_5_api \
)
CLASSPATH=$CLASSPATH:target/classes:target/test-classes
pushd shale-test
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -Dmaven.settings.offline=true -Dbuild.sysclasspath=only jar javadoc
popd
export CLASSPATH=$(build-classpath \
commons-logging \
el_1_0_api \
jsf_1_2_api \
jsp_2_1_api \
servlet_2_5_api \
)
CLASSPATH=$CLASSPATH:$(pwd)/shale-test/target/shale-test-%{version}.jar
CLASSPATH=$CLASSPATH:target/classes:target/test-classes
pushd shale-core
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -Dmaven.settings.offline=true -Dbuild.sysclasspath=only jar javadoc
popd
export CLASSPATH=$(build-classpath \
commons-chain \
commons-logging \
jsf_1_2_api \
servlet_2_5_api \
)
CLASSPATH=$CLASSPATH:$(pwd)/shale-test/target/shale-test-%{version}.jar
CLASSPATH=$CLASSPATH:$(pwd)/shale-core/target/shale-core-%{version}.jar
CLASSPATH=$CLASSPATH:target/classes:target/test-classes
pushd shale-application
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -Dmaven.settings.offline=true -Dbuild.sysclasspath=only jar javadoc
popd
export CLASSPATH=$(build-classpath \
commons-beanutils \
commons-chain \
commons-collections \
commons-digester \
commons-logging \
el_1_0_api \
jsf_1_2_api \
jsp_2_1_api \
servlet_2_5_api \
)
CLASSPATH=$CLASSPATH:$(pwd)/shale-test/target/shale-test-%{version}.jar
CLASSPATH=$CLASSPATH:$(pwd)/shale-core/target/shale-core-%{version}.jar
CLASSPATH=$CLASSPATH:target/classes:target/test-classes
pushd shale-clay
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -Dmaven.settings.offline=true -Dbuild.sysclasspath=only jar javadoc
popd
export CLASSPATH=$(build-classpath \
commons-logging \
jsf_1_2_api \
servlet_2_5_api \
)
CLASSPATH=$CLASSPATH:$(pwd)/shale-test/target/shale-test-%{version}.jar
CLASSPATH=$CLASSPATH:$(pwd)/shale-core/target/shale-core-%{version}.jar
CLASSPATH=$CLASSPATH:target/classes:target/test-classes
pushd shale-dialog
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -Dmaven.settings.offline=true -Dbuild.sysclasspath=only jar javadoc
popd
export CLASSPATH=$(build-classpath \
commons-beanutils \
commons-digester \
commons-logging \
jsf_1_2_api \
servlet_2_5_api \
)
CLASSPATH=$CLASSPATH:$(pwd)/shale-test/target/shale-test-%{version}.jar
CLASSPATH=$CLASSPATH:$(pwd)/shale-core/target/shale-core-%{version}.jar
CLASSPATH=$CLASSPATH:$(pwd)/shale-dialog/target/shale-dialog-%{version}.jar
CLASSPATH=$CLASSPATH:target/classes:target/test-classes
pushd shale-dialog-basic
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -Dmaven.settings.offline=true -Dbuild.sysclasspath=only jar javadoc
popd
export CLASSPATH=$(build-classpath \
commons-beanutils \
commons-digester \
commons-logging \
commons-scxml \
jsf_1_2_api \
servlet_2_5_api \
)
CLASSPATH=$CLASSPATH:$(pwd)/shale-test/target/shale-test-%{version}.jar
CLASSPATH=$CLASSPATH:$(pwd)/shale-core/target/shale-core-%{version}.jar
CLASSPATH=$CLASSPATH:$(pwd)/shale-dialog/target/shale-dialog-%{version}.jar
CLASSPATH=$CLASSPATH:target/classes:target/test-classes
pushd shale-dialog-scxml
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -Dmaven.settings.offline=true -Dbuild.sysclasspath=only jar javadoc
popd
export CLASSPATH=$(build-classpath \
commons-chain \
commons-logging \
el_1_0_api \
jsf_1_2_api \
servlet_2_5_api \
)
CLASSPATH=$CLASSPATH:$(pwd)/shale-test/target/shale-test-%{version}.jar
CLASSPATH=$CLASSPATH:$(pwd)/shale-core/target/shale-core-%{version}.jar
CLASSPATH=$CLASSPATH:target/classes:target/test-classes
pushd shale-remoting
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -Dmaven.settings.offline=true -Dbuild.sysclasspath=only jar javadoc
popd
CLASSPATH=$CLASSPATH:$(pwd)/shale-test/target/shale-test-%{version}.jar
CLASSPATH=$CLASSPATH:$(pwd)/shale-core/target/shale-core-%{version}.jar
CLASSPATH=$CLASSPATH:target/classes:target/test-classes
export CLASSPATH=$(build-classpath \
commons-beanutils \
commons-digester \
commons-logging \
commons-validator \
el_1_0_api \
jsp_2_1_api \
jsf_1_2_api \
oro \
servlet_2_5_api \
)
CLASSPATH=$CLASSPATH:$(pwd)/shale-test/target/shale-test-%{version}.jar
CLASSPATH=$CLASSPATH:$(pwd)/shale-core/target/shale-core-%{version}.jar
CLASSPATH=$CLASSPATH:target/classes:target/test-classes
pushd shale-validator
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -Dmaven.settings.offline=true -Dbuild.sysclasspath=only jar javadoc
popd
export CLASSPATH=$(build-classpath \
commons-logging \
el_1_0_api \
jsf_1_2_api \
jsp_2_1_api \
servlet_2_5_api \
)
CLASSPATH=$CLASSPATH:$(pwd)/shale-test/target/shale-test-%{version}.jar
CLASSPATH=$CLASSPATH:$(pwd)/shale-core/target/shale-core-%{version}.jar
CLASSPATH=$CLASSPATH:target/classes:target/test-classes
pushd shale-view
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -Dmaven.settings.offline=true -Dbuild.sysclasspath=only jar javadoc
popd
export CLASSPATH=$(build-classpath \
commons-digester \
commons-logging \
el_1_0_api \
jsf_1_2_api \
servlet_2_5_api \
)
CLASSPATH=$CLASSPATH:$(pwd)/shale-test/target/shale-test-%{version}.jar
CLASSPATH=$CLASSPATH:$(pwd)/shale-core/target/shale-core-%{version}.jar
CLASSPATH=$CLASSPATH:$(pwd)/shale-view/target/shale-view-%{version}.jar
CLASSPATH=$CLASSPATH:target/classes:target/test-classes
pushd shale-tiger
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 -Dmaven.settings.offline=true -Dbuild.sysclasspath=only jar javadoc
popd
%endif

%install
# jars/poms
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}/%{name}
install -d -m 755 $RPM_BUILD_ROOT%{_mavenpomdir}

for module in \
           application \
           clay \
           core \
           dialog-basic \
           dialog-scxml \
           dialog \
           remoting \
           test \
%if ! %{bootstrap}
           tiger \
           tiles \
%endif
           validator \
           view \
           ; do
install -m 644 shale-$module/target/shale-$module-%{version}.jar \
               $RPM_BUILD_ROOT%{_javadir}/%{name}/$module-%{version}.jar
%add_to_maven_depmap org.apache.shale shale-$module %{version} JPP/shale $module
install -m 644 shale-$module/pom.xml $RPM_BUILD_ROOT/%{_mavenpomdir}/JPP.shale-$module.pom

install -d -m 755 $RPM_BUILD_ROOT%{_javadocdir}/%{name}-%{version}/$module
cp -pr shale-$module/target/site/apidocs/* \
                    $RPM_BUILD_ROOT%{_javadocdir}/%{name}-%{version}/$module
done

%add_to_maven_depmap org.apache.shale shale-master 2 JPP/shale master
install -m 644 %{SOURCE1} $RPM_BUILD_ROOT/%{_mavenpomdir}/JPP.shale-master.pom

%add_to_maven_depmap org.apache.shale shale-parent %{version} JPP/shale parent
install -m 644 pom.xml $RPM_BUILD_ROOT/%{_mavenpomdir}/JPP.shale-parent.pom

(cd $RPM_BUILD_ROOT%{_javadir}/%{name} && for jar in *-%{version}*; do ln -sf ${jar} `echo $jar| sed  "s|-%{version}||g"`; done)

ln -s %{name}-%{version} $RPM_BUILD_ROOT%{_javadocdir}/%{name} # ghost symlink

install -d -m 755 $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
cp -pr docs $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}
install -m 644 LICENSE.txt $RPM_BUILD_ROOT%{_docdir}/%{name}-%{version}

%post javadoc
rm -f %{_javadocdir}/%{name}
ln -s %{name}-%{version} %{_javadocdir}/%{name}

%postun javadoc
if [ "$1" = "0" ]; then
  rm -f %{_javadocdir}/%{name}
fi

%files
%dir %{_javadir}/%{name}
%{_javadir}/%{name}/core*.jar
%{_mavenpomdir}/*
%{_mavendepmapfragdir}/*
%doc %{_docdir}/%{name}-%{version}/LICENSE.txt
# hack; explicitly added docdir if not owned
%doc %dir %{_docdir}/%{name}-%{version}

%files application
%{_javadir}/%{name}/application*.jar

%files clay
%{_javadir}/%{name}/clay*.jar

%files dialog
%{_javadir}/%{name}/dialog-%{version}.jar
%{_javadir}/%{name}/dialog.jar

%files dialog-basic
%{_javadir}/%{name}/dialog-basic*.jar

%files dialog-scxml
%{_javadir}/%{name}/dialog-scxml*.jar

%files remoting
%{_javadir}/%{name}/remoting*.jar

#%files spring
#%{_javadir}/%{name}/spring*.jar

%files test
%{_javadir}/%{name}/test*.jar

#%files tiger
#%{_javadir}/%{name}/tiger*.jar

%if ! %{bootstrap}
%files tiles
%{_javadir}/%{name}/tiles*.jar
%endif

%files validator
%{_javadir}/%{name}/validator*.jar

%files view
%{_javadir}/%{name}/view*.jar

%files javadoc
%doc %{_javadocdir}/%{name}-%{version}
%ghost %doc %{_javadocdir}/%{name}

%files manual
%doc %{_docdir}/%{name}-%{version}/docs
# hack; explicitly added docdir if not owned
%doc %dir %{_docdir}/%{name}-%{version}

%changelog
