%def_disable static

Name:           slimdata
Version:        2.6.4
Release:        alt1
Summary:        Tools and library for reading and writing slim compressed data

Group:          System/Libraries
License:        GPLv3+
URL:            http://slimdata.sourceforge.net/
Source:         slim_%version.tgz

Patch0:         slimdata-name-change.diff

# Automatically added by buildreq on Fri Sep 16 2011 (-bi)
# optimized out: elfutils libstdc++-devel python-base python-module-numpy python-module-numpy-testing python-modules python-modules-ctypes tex-common texlive-base texlive-base-bin texlive-common texlive-latex-base
BuildRequires: doxygen gcc-c++ python-module-numpy-addons

BuildPreReq: texlive-latex-base

%description
Slim is a data compression system for scientific data sets, both a binary and a
library with C linkage. Slim works with integer data from one or more channels
in a file, which it can compress more rapidly than general tools like gzip.

%package devel
Group:  Development/C
Summary: Headers required when building programs against getdata
Requires: %name = %version-%release
Requires: pkgconfig

%description devel
Headers required when building projects that use the slimdata library.

%if_enabled static
%package devel-static
Summary: Static libraries for %name
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
Static libs for building statically linked software that uses %name
%endif


%prep
%setup -q -n slim_2.6.4
%patch0 -p1

# remove prebuilt pdf file
rm -f doc/*.pdf
# remove binary files
rm -f test/generate_random_data
# change opttimization flags
subst 's/-O3/-O2/g' test/Makefile

%build
%configure
%make_build OPT=''
make doc

%check
# set PATH to slim binary files
export PATH=$PATH:`pwd`/bin
make test

%install
#make DESTDIR=%buildroot SUID_ROOT="" install
%makeinstall_std

#chmod a+x %buildroot/%_libdir/libslim.so.0.0

#Rename binary to slimdata; upstream will follow in subsequent releases.
mv %buildroot/%_bindir/slim %buildroot/%_bindir/%name
rm %buildroot/%_bindir/unslim %buildroot/%_bindir/slimcat
#Don't forget the man page: BZ 506141
mv %buildroot/%_mandir/man1/slim.1 %buildroot/%_mandir/man1/%name.1
subst 's/slim/%name/' %buildroot/%_mandir/man1/slimcat.1
subst 's/slim/%name/' %buildroot/%_mandir/man1/unslim.1
pushd .
cd %buildroot/%_bindir
ln -s slimdata unslim
ln -s slimdata slimcat
popd

%files
%doc README COPYING AUTHORS TODO VERSIONS
%_bindir/*slim*
%_libdir/libslim.so.*
%_mandir/man1/*slim*

%files devel
%doc doc/slim_format.pdf doc/html/*
%_includedir/slim*.h
%_libdir/libslim.so

%if_enabled static
%files devel-static
%_libdir/libslim.a
%endif

%changelog
