# -*- rpm-spec -*-
# $Id: smalltalk,v 1.13 2002/10/05 12:54:06 lioka Exp $

%def_disable jit
%def_disable preemption
%def_disable checking
%def_disable static

Name: smalltalk
Version: 3.2.4
Release: alt1.git.263.ga839464.2

Summary: Smalltalk free language implementation
License: GPL
Group: Development/Other
Url: http://smalltalk.gnu.org/

Packager: Ildar Mulyukov <ildar@altlinux.ru>

#git://git.sv.gnu.org/smalltalk.git
Source: %name-%version.tar
#Source: ftp://ftp.gnu.org/gnu/smalltalk/%name-%version.tar
#Source.gz
Source1: VisualGST.desktop
Source2: http://upload.wikimedia.org/wikipedia/commons/0/08/GNU_Smalltalk_logo.svg
Provides: VisualGST
Obsoletes: VisualGST

%if_enabled jit
BuildPreReq: lightning
%endif

# Automatically added by buildreq on Wed Feb 22 2012 (-bi)
# optimized out: cpio elfutils emacs-base emacs-common fontconfig fontconfig-devel glib2-devel libGL-devel libGLU-devel libICE-devel libSDL-devel libX11-devel libX11-locales libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libncurses-devel libpango-devel libtinfo-devel pkg-config python-base tcl-devel termutils tzdata xorg-xproto-devel
BuildRequires: chrpath emacs-nox flex libSDL_image-devel libSDL_mixer-devel libSDL_sound-devel libSDL_ttf-devel libSM-devel libexpat-devel libffi-devel libfreeglut-devel libgdbm-devel libgmp-devel libgtk+2-devel libltdl7-devel libpq-devel libreadline-devel libsigsegv-devel libsqlite3-devel python-module-distribute tk-devel zip zlib-devel

Requires: %_bindir/ginstall %_bindir/zip

%description
GNU Smalltalk is a Free (or Open Source) implementation that closely
follows the Smalltalk-80 language as described in the book Smalltalk-80:
the Language and its Implementation by Adele Goldberg and David
Robson. GNUSmalltalk runs on most versions of Unix or Unix like
systems (GNU/Linux, FreeBSD, etc...).
There is even a version for commercial operating systems like MS-NT.

%if_enabled static

%package static
Summary: static libraries for %name
Group: Development/Other
Requires: %name = %version-%release

%description static
static libraries for %name

%endif

%package -n emacs-mode-%name
Summary: SmallTalk mode for GNU Emacs
Group: Editors
BuildArch: noarch
Requires: %name = %version-%release

%description -n emacs-mode-%name
SmallTalk mode for GNU Emacs

%package -n emacs-mode-%name-el
Summary: The Emacs Lisp sources for bytecode included in emacs-mode-%name
Group: Editors
BuildArch: noarch
Requires: emacs-mode-%name = %version-%release

%description -n emacs-mode-%name-el
The Emacs Lisp sources for bytecode included in emacs-mode-%name

%package doc
Summary: GNU Smalltalk html doc
Group: Development/Other
BuildArch: noarch

%description doc
GNU Smalltalk html doc

%prep
%setup

%build
%autoreconf
%configure --with-tcl=%_libdir --with-tk=%_libdir \
	--with-imagedir=/var/lib/smalltalk \
	%{subst_enable jit} \
	%{subst_enable preemption} \
	%{subst_enable checking} \
	--enable-disassembler \
	--with-system-libffi \
	--with-system-libsigsegv \

rm -rf libffi sigsegv
# parallel build is broken
#make_build lispstartdir=%_sysconfdir/emacs/site-start.d
%make lispstartdir=%_sysconfdir/emacs/site-start.d LIBTHREAD=-lpthread
make -C doc html
bzip2 ChangeLog ||:

%check
%make_build -k check

%install
mkdir -p \
	%buildroot%_desktopdir \
	%buildroot%_iconsdir/hicolor/scalable/apps
%make install DESTDIR=%buildroot lispstartdir=%_sysconfdir/emacs/site-start.d
install -p %SOURCE1 %buildroot%_desktopdir
install -p %SOURCE2 %buildroot%_iconsdir/hicolor/scalable/apps

#FIXME: remove RPATH while building
find %buildroot%_libdir -name \*.so\* -type f -print
find %buildroot -type f \( -path %buildroot%_libdir/\*.so\* -or -path %buildroot%_bindir/\* \) -print -exec sh -c \
	"chrpath -l {} | egrep RPATH=%_libdir$ && \
		chrpath -d {}
	" \;

%find_lang %name
%add_findreq_skiplist %_datadir/smalltalk/examples/shell

%files -f %name.lang
%_bindir/*
%_includedir/gst*.h
%_libdir/libgst*.so*
%_pkgconfigdir/gnu-smalltalk.pc
%_libdir/%name
%_libexecdir/%name
%exclude %_libdir/%name/*.a
%exclude %_libdir/%name/*.la
%_datadir/aclocal/gst*
%_desktopdir/*.desktop
%_iconsdir/hicolor/scalable/apps/GNU_Smalltalk_logo.svg
%_infodir/*.info*
%_man1dir/gst*
%_datadir/%name
/var/lib/smalltalk
%doc AUTHORS NEWS README THANKS TODO ChangeLog*

%files -n emacs-mode-%name
%_emacslispdir/*.elc
%_sysconfdir/emacs/site-start.d/*.elc

%files -n emacs-mode-%name-el
%_emacslispdir/*.el
%_sysconfdir/emacs/site-start.d/*.el

%if_enabled static
%files static
%_libdir/%name/*.a
%_libdir/libgst.a
%endif

%files doc
%doc doc/html/*

%changelog
