Name: solfege
Version: 3.20.7
Release: alt1

Summary: Eartraining program for GNOME
License: GPLv3
Group: Education

#Url: http://solfege.sourceforge.net
Url: http://www.solfege.org
Source: http://download.sourceforge.net/solfege/%name-%version.tar.gz
Patch: solfege-3.14.2-alt-desktop.patch
Packager: Alex Karpov <karpov@altlinux.org>

%define python_ver 2.4
%define pygnome_ver 2.6.0
%define pygtk_ver 2.12.0
%define gtkhtml_ver 1.99.6

BuildArch: noarch

# Automatically added by buildreq on Thu Jul 15 2010
BuildRequires: docbook-style-xsl gnome-doc-utils librsvg-utils libuuid-devel lilypond python-devel python-module-pygobject python-modules-logging swig

#BuildRequires: python-devel = %__python_version

BuildRequires: python-devel >= %python_ver
BuildRequires: python-module-pygtk-devel >= %pygtk_ver
BuildRequires: python-module-pygnome >= %pygnome_ver
BuildRequires: libgtkhtml2-devel >= %gtkhtml_ver

BuildRequires: xsltproc >= 1.0.30-alt2
BuildRequires: gnome-doc-utils
# ...or something like 1.23-alt1, but *before* 1.29-alt1

Requires: pygtk2 >= %pygtk_ver, libgtkhtml2 >= %gtkhtml_ver
Requires: python >= %python_ver, gnome-python2 >= %pygnome_ver
Requires: python-module-pygnome-bonobo python-module-pygnome-canvas pyorbit
Requires: python-module-pygnome-gtkhtml2
Requires: python-modules-sqlite3

Summary(ru_RU.KOI8-R):   .
Summary(uk_UA.KOI8-U):   .

AutoReqProv: yes, nopython
# Requires: python-strict

%description
Solfege is an eartraining program for X written in python, using the
GTK+ and GNOME libraries. This is a development release, things might
be broken. See INSTALL file if you have problems running or installing
Solfege. Report your problems to solfege-devel@lists.sourceforge.net

Eartraining is a big subject with many connections to music theory and
performance of music, so I won't even try to make "a complete
computerbased eartraining course". But I hope someone find this
software useful.

%description -l ru_RU.KOI8-R
Solfege --    ,   Python 
  GTK+  GNOME.

  --   ,      
 .       " ",   
 ,     .

%description -l uk_UA.KOI8-U
Solfege --    ,    Python  
¦̦ GTK+  GNOME.

%prep
%setup
#patch -p1

%build
XSLPATH=`echo "system http://docbook.sourceforge.net/release/xsl/current" \
	| xmlcatalog --shell \
	| sed 's,^.*file://,,' \
	| head -1`
[ -n "$XSLPATH" ] && {
	XSLOPT="--enable-docbook-stylesheet=$XSLPATH/html/chunk.xsl"
} || {
	XSLOPT="--with-local-xmlcatalog"
}
export PYTHON=%__python
%configure \
	--with-gtkhtml \
	--disable-oss-sound \
#	$XSLOPT
#	--enable-tuner \
#	--with-swig13 \

%make_build

%install
%makeinstall nopycompile=YES
# WITH_SWIG13=yes

rm -f %buildroot%_pixmapsdir/%name.png
#install -pDm644 graphics/%name.png %buildroot%_niconsdir/%name.png
install -pD %name.desktop %buildroot%_desktopdir/%name.desktop

# force python to optimize generated bytecode
subst 's@!%__python\(.*\)@!%__python\1 -O@' %buildroot%_bindir/%name

%find_lang --output=%name.lang %name %name-intervallnames

find %buildroot%_datadir/%name/ -name '*.pyc' -delete

# put only optimized bytecode and necessary .py's into the package
%files -f %name.lang
%_bindir/*
%dir %_datadir/%name
%_datadir/%name
#_niconsdir/*
%_desktopdir/*
%_man1dir/*
#_libdir/%name

%config(noreplace) %_sysconfdir/*
%doc AUTHORS FAQ README COPYING INSTALL changelog

%changelog
