Epoch: 0
BuildRequires: /proc
BuildRequires: jpackage-compat
%global shortname gossip

Name:             sonatype-gossip
Version:          1.7
Release:          alt1_5jpp7
Summary:          SLF4j Gossip Provider
Group:            Development/Java
License:          ASL 2.0
URL:              http://github.com/jdillon/gossip

# git clone git://github.com/jdillon/gossip.git
# cd gossip/ && git checkout gossip-1.7
# git archive --format=tar --prefix=gossip-1.7/ gossip-1.7 | xz > gossip-1.7.tar.xz
Source0:          %{shortname}-%{version}.tar.xz
Patch0:           %{shortname}-%{version}-use-java5-modello.patch

BuildArch:        noarch

BuildRequires:    jpackage-utils
BuildRequires:    maven
BuildRequires:    maven-compiler-plugin
BuildRequires:    maven-license-plugin
BuildRequires:    maven-install-plugin
BuildRequires:    maven-jar-plugin
BuildRequires:    maven-javadoc-plugin
BuildRequires:    maven-release-plugin
BuildRequires:    maven-surefire-plugin
BuildRequires:    junit4
BuildRequires:    slf4j
BuildRequires:    maven-surefire-provider-junit4
BuildRequires:    animal-sniffer
BuildRequires:    modello
BuildRequires:    jansi
BuildRequires:    fusesource-pom

Requires:         jpackage-utils
Requires:         slf4j
Source44: import.info

%description
Gossip is a plugin for SLF4j which has simple and flexible configuration.

%package javadoc
Summary:          Javadocs for %{name}
Group:            Development/Java
Requires:         jpackage-utils
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q -n %{shortname}-%{version}
%patch0 -p1

%build
mvn-rpmbuild install javadoc:aggregate

%install
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}/%{name}
install -d -m 755 $RPM_BUILD_ROOT%{_mavenpomdir}

for sub in bootstrap bootstrap-slf4j support core slf4j extra; do
  # JAR
  cp -p %{shortname}-${sub}/target/%{shortname}-${sub}-%{version}.jar $RPM_BUILD_ROOT%{_javadir}/%{name}/%{name}-${sub}.jar

  # POM
  install -pm 644 %{shortname}-${sub}/pom.xml $RPM_BUILD_ROOT%{_mavenpomdir}/JPP.%{name}-%{name}-${sub}.pom

  # DEPMAP
  %add_maven_depmap JPP.%{name}-%{name}-${sub}.pom %{name}/%{name}-${sub}.jar
done

# Parent POM
install -pm 644 pom.xml $RPM_BUILD_ROOT%{_mavenpomdir}/JPP.%{name}-%{name}.pom
# Parent DEPMAP
%add_maven_depmap JPP.%{name}-%{name}.pom

# JAVADOC
mkdir -p $RPM_BUILD_ROOT%{_javadocdir}/%{name}
cp -rp target/site/apidocs/* $RPM_BUILD_ROOT%{_javadocdir}/%{name}

%files
%{_mavenpomdir}/*
%{_mavendepmapfragdir}/*
%{_javadir}/*
%doc README.md header.txt

%files javadoc
%{_javadocdir}/%{name}
%doc header.txt

%changelog
