%define ver_major 3.4

Name: sound-juicer
Version: %ver_major.0
Release: alt1
Summary: Clean and lean CD ripper
Group: Sound
License: GPLv2+
Url: http://live.gnome.org/SoundJuicer
Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Requires: gst-plugins-base gst-plugins-good

Source: http://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

BuildPreReq: gnome-common
BuildRequires: intltool desktop-file-utils gcc-c++
BuildRequires: gnome-doc-utils-xslt gnome-doc-utils
BuildRequires: glib2-devel >= 2.18
BuildRequires: libbrasero-devel >= 3.0.0
BuildRequires: libgtk+3-devel >= 2.90.0
BuildRequires: GConf libGConf-devel
BuildRequires: libgio-devel libdbus-glib-devel libdbus-devel
BuildRequires: libcanberra-devel libcanberra-gtk3-devel
BuildRequires: gstreamer-devel gst-plugins-devel gst-plugins-base gst-plugins-good gstreamer-utils
BuildRequires: libgnome-media-profiles-devel >= 3.0.0
BuildRequires: libmusicbrainz3-devel  >= 3.0.2 libdiscid-devel

%description
GStreamer-based CD ripping tool. Saves audio CDs to audio formats,
supported by GStreamer.

%prep
%setup -q

%build
%configure \
	--disable-static \
	--disable-schemas-install \
	--disable-scrollkeeper

%make_build

%install
%make_install install DESTDIR=%buildroot

%find_lang --with-gnome %name
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=DiscBurning \
	--add-category=GTK \
	%buildroot%_desktopdir/sound-juicer.desktop

%post
%gconf2_install %name

%preun
if [ $1 = 0 ]; then
    %gconf2_uninstall %name
fi

%files -f %name.lang
%_bindir/*
%_datadir/%name
%_datadir/applications/*
%_datadir/icons/*/*/*/*
%_man1dir/*
%config %_sysconfdir/gconf/schemas/*
%doc AUTHORS README NEWS

%changelog
