%def_enable static

Name: speex
Version: 1.2
%define prerel pre1
Release: alt0.5.pre1
Summary: An open-source, patent-free speech codec
License: BSD-style
Group: Sound
Url: http://www.speex.org
%define pkgdocdir %_docdir/%name-%version
Packager: Denis Smirnov <mithraen@altlinux.ru>

# %url/download/%name-%version%prerel.tar.bz2
Source: %name-%version.tar
Requires: lib%name = %version-%release

BuildRequires: libogg-devel >= 1.1

%description
Speex is a patent-free audio codec designed especially for voice
(unlike Vorbis which targets general audio) signals and providing good
narrowband and wideband quality. This project aims to be complementary
to the Vorbis codec.

%package -n lib%name
Summary: Speex shared library
Group: System/Libraries

%description -n lib%name
This package contains shared library required by Speex-based software.

%package -n lib%name-devel
Summary: Speex development file
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains heade files required to develop
Speex-based softwae.

%package -n lib%name-devel-doc
Summary: Speex development documentation
Group: Development/C
Conflicts: %name < %version
BuildArch: noarch

%description -n lib%name-devel-doc
The Speex programming manual in PDF format.

%if_enabled static
%package -n lib%name-devel-static
Summary: Speex static libraries
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains static library required to develop
Speex-based software.
%endif

%prep
%setup

%build
%add_optflags -DRELEASE
%autoreconf -fisv
%configure \
%ifarch pentium4 x86_64 athlon_xp k8 nocona
    --enable-sse \
%endif
%{subst_enable static}
%make_build

%install
%make_install DESTDIR=%buildroot docdir=%pkgdocdir install
install -m 0644 COPYING AUTHORS NEWS README %buildroot%pkgdocdir/

%files
%_bindir/*
%_man1dir/*
%dir %pkgdocdir
%pkgdocdir/COPYING
%pkgdocdir/AUTHORS
%pkgdocdir/NEWS
%pkgdocdir/README

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_pkgconfigdir/*
%_datadir/aclocal/*
%_includedir/*

%files -n lib%name-devel-doc
%dir %pkgdocdir
%pkgdocdir/manual.pdf

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
