Name: spl
Version: 0.6.3
Release: alt1
Summary: Solaris Porting Layer (SPL)
License: GPLv2+
Group: System/Kernel and hardware
URL: http://zfsonlinux.org
Source: http://archive.zfsonlinux.org/downloads/zfsonlinux/%name/%name-%version.tar
#Patch: %name-%version-%release.patch

BuildRequires: rpm-build-kernel

%description
The Solaris Porting Layer (SPL) is a Linux kernel module which provides many of
the Solaris kernel APIs. This shim layer makes it possible to run Solaris kernel
code in the Linux kernel with relatively minimal modification. This can be
particularly useful when you want to track upstream Solaris development closely
and don't want the overhead of maintaining a large patch which converts Solaris
primitives to Linux primitives.


%package utils
Summary: SPL modules sources for Linux kernel
Group: System/Kernel and hardware
Provides: splat = %version-%release

%description utils
The Solaris Porting Layer (SPL) is a Linux kernel module which provides many of
the Solaris kernel APIs. This shim layer makes it possible to run Solaris kernel
code in the Linux kernel with relatively minimal modification. This can be
particularly useful when you want to track upstream Solaris development closely
and don't want the overhead of maintaining a large patch which converts Solaris
primitives to Linux primitives.
This package contains splat - Solaris Porting LAyer Tests. This utility uses the
splat.ko kernel module to test the spl.ko kernel module.


%package -n kernel-source-%name
Summary: SPL modules sources for Linux kernel
Group: Development/Kernel
BuildArch: noarch
Provides: kernel-src-%name = %version-%release

%description -n kernel-source-%name
The Solaris Porting Layer (SPL) is a Linux kernel module which provides many of
the Solaris kernel APIs. This shim layer makes it possible to run Solaris kernel
code in the Linux kernel with relatively minimal modification. This can be
particularly useful when you want to track upstream Solaris development closely
and don't want the overhead of maintaining a large patch which converts Solaris
primitives to Linux primitives.
This package contains SPL modules sources for Linux kernel.


%prep
%setup -q
#patch -p1
sed -i '/^AC_OUTPUT/itest "x$SPL_CONFIG" != "xkernel" || ac_config_files="module/Makefile module/spl/Makefile module/splat/Makefile"\n' configure.ac


%build
./autogen.sh

tar -C .. \
	--exclude .gitignore \
	--exclude 'include/*Makefile.*' \
	-cJf %name-%version.tar.xz \
	%name-%version/module \
	%name-%version/config/{{install-,ltmain.}sh,config.{awk,guess,sub},missing} \
	%name-%version/include \
	%name-%version/{AUTHORS,COPYING,DISCLAIMER,META,configure,%name{.release,_config.h}.in}

%configure --with-config=user --with-gnu-ld
%make_build


%install
install -pD -m 0644 {,%kernel_srcdir/}%name-%version.tar.xz
%makeinstall_std


%files utils
%doc AUTHORS DISCLAIMER META README*
%_sbindir/*
%_man1dir/*
%_man5dir/*

%files -n kernel-source-%name
%_usrsrc/kernel


%changelog
