# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: gcc-c++ libSDL_sound-devel libgcrypt-devel libgnutls-devel libgpg-error-devel libidn-devel libogg-devel libuuid-devel libvorbis-devel perl(FileHandle.pm) perl(Text/Wrap.pm) pkgconfig(ogg) pkgconfig(vorbis) pkgconfig(vorbisfile) zlib-devel
# END SourceDeps(oneline)
# undefined symbol: L_*, LOG_*, parse32 in libFileSystem
# those are from static libUtil, in main binary
%set_verify_elf_method unresolved=relaxed
BuildRequires: boost-devel boost-filesystem-devel boost-signals-devel libpng-devel
%define fedora 19
Name:			springlobby
Version:		0.169
Release:		alt1_2
Summary:		A lobby client for the spring RTS game engine

Group:			Games/Other
# License clarification: http://springlobby.info/issues/show/810
License:		GPLv2
URL:			http://springlobby.info
Source0:		http://www.springlobby.info/tarballs/springlobby-%{version}.tar.bz2
#Patch0:			springlobby-gtkfix.patch

BuildRequires: ctest cmake
BuildRequires:	wxGTK-devel libtorrent-rasterbar-devel
BuildRequires:	libSDL-devel SDL_sound-devel libSDL_mixer-devel
BuildRequires:	desktop-file-utils gettext
BuildRequires:	libopenal-devel libcurl-devel
BuildRequires:	libalure-devel

# There are other "lobbies" for spring, make a virtual-provides
Provides:		spring-lobby = %{version}-%{release}

Requires:		icon-theme-hicolor
# Springlobby is completely useless without the spring package
Requires:		springrts
# Spring does not build on PPC, exclude it here too
ExcludeArch:	ppc ppc64
Source44: import.info
Patch33: springlobby-0.169-alt-linkage.patch

%description
SpringLobby is a free cross-platform lobby client for the Spring RTS project.

%prep
%setup -q
%patch33 -p1
#%patch0 -p0 -b .springlobby-gtkfix

%build
# Use boost filesystem 2 explicitly (bug 654807)
%if 0%{?fedora} >= 18
export CFLAGS="$CFLAGS -DBOOST_FILESYSTEM_VERSION=3"
export CXXFLAGS="$CXXFLAGS -DBOOST_FILESYSTEM_VERSION=3"
%else
export CFLAGS="$CFLAGS -DBOOST_FILESYSTEM_VERSION=2"
export CXXFLAGS="$CXXFLAGS -DBOOST_FILESYSTEM_VERSION=2"
%endif
%{fedora_cmake}
make %{?_smp_mflags}

%install
%makeinstall_std

# Manually copy the missing libraries.
mkdir -p $RPM_BUILD_ROOT/%{_libdir}
cp ./src/downloader/lib/src/libCurlWrapper.so $RPM_BUILD_ROOT/%{_libdir}
cp ./src/downloader/lib/src/FileSystem/libFileSystem.so $RPM_BUILD_ROOT/%{_libdir}

# Handled in %%doc
rm -rf $RPM_BUILD_ROOT%{_datadir}/doc/
# Useless file
rm -f $RPM_BUILD_ROOT%{_prefix}/config.h

# Fix Icon entry
sed -i -e 's/^Icon=\(.*\).svg/Icon=\1/g' \
		$RPM_BUILD_ROOT%{_datadir}/applications/%{name}.desktop
desktop-file-install	\
	--dir $RPM_BUILD_ROOT%{_datadir}/applications \
	--remove-category Application \
	--delete-original \
	$RPM_BUILD_ROOT%{_datadir}/applications/%{name}.desktop

%find_lang %{name}

%files -f %{name}.lang
%doc AUTHORS NEWS README COPYING THANKS
%{_bindir}/*
%{_libdir}/*
# wildcard _libdir/*
%exclude %_prefix/lib/debug
%{_datadir}/applications/*.desktop
%{_datadir}/icons/hicolor/scalable/apps/*.svg

%changelog
