%define _unpackaged_files_terminate_build 1
%def_disable debug

Name: springrts
Version: 91.0
Release: alt1.git20120830.qa1

Summary: Real time strategy game engine with many mods
License: GPL2+ or Artistic
Group: Games/Strategy 
Url: http://springrts.com/

BuildRequires(pre): rpm-build-xdg rpm-macros-cmake

BuildRequires: cmake cmake-modules java-devel /proc libGL-devel libGLU-devel gcc-c++
BuildRequires: boost-devel boost-program_options-devel boost-asio-devel boost-signals-devel
BuildRequires: libICE-devel libSM-devel libX11-devel libXdamage-devel libXfixes-devel libXrender-devel 
BuildRequires: libXt-devel libfreetype-devel libogg-devel libstdc++-devel 
BuildRequires: xorg-inputproto-devel xorg-kbproto-devel xorg-xextproto-devel xorg-xf86miscproto-devel 
BuildRequires: xorg-xineramaproto-devel xorg-xproto-devel zlib-devel p7zip libXcursor-devel
BuildRequires: libdevil-devel libfreeglut-devel libglew-devel libopenal1-devel 
BuildRequires: libvorbis-devel  python-devel libSDL-devel
BuildPreReq: docbook5-style-xsl asciidoc libminizip-devel
BuildPreReq: libXres-devel libXtst-devel libXau-devel libXcomposite-devel
BuildPreReq: libXdmcp-devel libXext-devel libXft-devel libXi-devel
BuildPreReq: libXinerama-devel libxkbfile-devel libXmu-devel libXpm-devel
BuildPreReq: libXrandr-devel libXScrnSaver-devel libXv-devel
BuildPreReq: libXxf86misc-devel libXxf86vm-devel

Requires: %name-data = %version-%release
# git://springrts.git.sourceforge.net/gitroot/springrts/springrts
Source0: %name-%version.tar

%description
Spring is an open source RTS (Real time Strategy) engine originally
designed to recreate the experience of Total Annihilation.  Spring now
supports many different games ("mods"), including both remakes of the
original Total Annihilation and completely new games.

This package contains the game engine and default AI, but no maps, mods,
or user interface.

%package data
Summary: data files for Spring RTS engine
Group: Games/Strategy
BuildArch: noarch

%description data
data files for Spring RTS engine

%package dedicated
Summary: springrts dedicated server
Group: Games/Strategy
Requires: %name-data = %version-%release

%description dedicated
springrts dedicated server

%prep
%setup 

%build
%cmake \
%if_enabled debug
        -DCMAKE_BUILD_TYPE=Debug \
%else
        -DCMAKE_BUILD_TYPE=Release \
%endif
        -DLIBDIR=%_libdir \
        -DBINDIR=%_gamesbindir \
        -DAI_LIBS_DIR=%_libdir/spring \
        -DAI_DATA_DIR=%_gamesdatadir/spring \
				-DDOCDIR=share/doc/%name-%version \
				-DDOCBOOK_XSL=%_datadir/sgml/docbook/xsl-ns-stylesheets/manpages/docbook.xsl
%make_build -C BUILD VERBOSE=1

%install
%makeinstall_std -C BUILD VERBOSE=1
mkdir %buildroot%_gamesdatadir/spring/{mods,maps}

%if_enabled debug
%add_strip_skiplist %_bindir/*
%add_strip_skiplist %_libdir/*
%endif

%files 
%_gamesbindir/spring
%_gamesbindir/spring-headless
%_gamesbindir/spring-multithreaded
%_libdir/spring
%doc %_docdir/%name-%version
%_man6dir/*
%exclude %_man6dir/spring-dedicated.6*

%files data
%_gamesdatadir/*
%_pixmapsdir/*
%_xdgmimedir/packages/*
%_desktopdir/*

%files dedicated
%_gamesbindir/spring-dedicated
%_libdir/*.so
%_man6dir/spring-dedicated.6*

%post data
  [ -f %_gamesdatadir/spring/base/otacontent.sdz ] && \
  [ -f %_gamesdatadir/spring/base/tacontent_v2.sdz ] && \
  [ -f %_gamesdatadir/spring/base/tatextures_v062.sdz ] && exit 0

  echo " ================= Non-free content not included  ==================="
  echo "  Please download and install additional non-free content which      "
  echo "  could not be included in this package.                             "
  echo ""
  echo "   1. download http://files.simhost.org/Spring/base-ota-content.zip  "
  echo "   2. extract it to %_gamesdatadir/spring/base                       "
  echo " ===================================================================="

%changelog
