Name: sqlite3
Version: 3.7.15.2
Release: alt1
Summary: An Embeddable SQL Database Engine
License: Public Domain
Group: Development/Databases
URL: http://www.sqlite.org/

Requires: lib%name = %version-%release

Source0: sqlite-%version.tar

Patch1: sqlite3-alt-fts3.patch
Patch2: sqlite3-alt-tcl.patch
Patch3: sqlite3-alt-version-script.patch

BuildRequires(Pre): tcl-devel
BuildRequires: libreadline-devel

%description
SQLite is a C library that implements an SQL database engine.
Programs that link with the SQLite library can have SQL database
access without running a separate RDBMS process.

%package -n lib%name
Summary: An Embeddable SQL Database Engine (shared library)
Group: System/Libraries
Provides: sqlite(SECURE_DELETE) sqlite(COLUMN_METADATA) sqlite(FTS3) sqlite(UNLOCK_NOTIFY)
Provides: %name-fts3 = %version-%release
Obsoletes: %name-fts3 < %version-%release

%description -n lib%name
SQLite is a C library that implements an SQL database engine.
Programs that link with the SQLite library can have SQL database
access without running a separate RDBMS process.

%package -n lib%name-devel
Summary: An Embeddable SQL Database Engine (header files)
Group: Development/Databases
Requires: lib%name = %version-%release

%description -n lib%name-devel
SQLite is a C library that implements an SQL database engine.
Programs that link with the SQLite library can have SQL database
access without running a separate RDBMS process.

%package -n lib%name-devel-static
Summary: An Embeddable SQL Database Engine (static library)
Group: Development/Databases
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
SQLite is a C library that implements an SQL database engine.
Programs that link with the SQLite library can have SQL database
access without running a separate RDBMS process.

%package tcl
Summary: An Embeddable SQL Database Engine (TCL bindings)
Group: Development/Tcl
Requires: lib%name = %version-%release

%description tcl
SQLite is a C library that implements an SQL database engine.
Programs that link with the SQLite library can have SQL database
access without running a separate RDBMS process.

%package doc
Summary: An Embeddable SQL Database Engine (documentation)
Group: Development/Documentation
Conflicts: %name < 3.3.8-alt1
BuildArch: noarch

%description doc
SQLite is a C library that implements an SQL database engine.
Programs that link with the SQLite library can have SQL database
access without running a separate RDBMS process.

%package -n lemon
Summary: The Lemon Parser Generator
Group: Development/Other

%description -n lemon
Lemon is an LALR(1) parser generator for C or C++. It does the same
job as bison and yacc. But lemon is not another bison or yacc
clone. It uses a different grammar syntax which is designed to reduce
the number of coding errors. Lemon also uses a more sophisticated
parsing engine that is faster than yacc and bison and which is both
reentrant and thread-safe. Furthermore, Lemon implements features
that can be used to eliminate resource leaks, making is suitable for
use in long-running programs such as graphical user interfaces or
embedded controllers.

%prep
%setup -q -n sqlite-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1

%build
export TCLLIBDIR=%_tcllibdir
export TCLDATADIR=%_tcldatadir/%name
export CFLAGS="%optflags -DSQLITE_CORE=1 -DSQLITE_SECURE_DELETE=1 -DSQLITE_ENABLE_COLUMN_METADATA=1 -DSQLITE_ENABLE_FTS3=1 -DSQLITE_ENABLE_UNLOCK_NOTIFY=1 "
autoreconf -i
%configure \
	--enable-threadsafe \
	--disable-amalgamation \
	--enable-load-extension

%make_build all

%check
subst 's|-DSQLITE_ENABLE_FTS3=1||' Makefile
%make test

%install
%make_install install tcl_install DESTDIR=%buildroot

install -pD -m644 %name.1 %buildroot%_man1dir/%name.1

install -pD -m755 lemon %buildroot%_bindir/lemon
install -pD -m644 lempar.c %buildroot%_datadir/lemon/lempar.c

# for perl-DBD-SQLite
install -p -m644 ext/fts3/fts3.h ext/fts3/fts3_*.h %buildroot%_includedir/

%define pkgdocdir %_docdir/%name
mkdir -p %buildroot%pkgdocdir
cp -a doc %buildroot%pkgdocdir/html
install -pD -m644 doc/lemon.html %buildroot%_docdir/lemon/lemon.html

%files
%_bindir/%name
%_man1dir/%name.*

%files -n lib%name
%_libdir/lib%name.so.*

%files -n lib%name-devel
%_includedir/sqlite3.h
%_includedir/sqlite3ext.h
%_includedir/fts3.h
%_includedir/fts3_*.h
%_libdir/lib%name.so
%_pkgconfigdir/%name.pc

%files -n lib%name-devel-static
%_libdir/lib%name.a

%files tcl
%_tcllibdir/libtcl%name.so*
%dir %_tcldatadir/sqlite3
%_tcldatadir/sqlite3/pkgIndex.tcl

%files doc
%pkgdocdir

%files -n lemon
%dir %_docdir/lemon
%_docdir/lemon/lemon.html
%_bindir/lemon
%_datadir/lemon

%changelog
