%define name sqsh
%define release alt1
%define version 2.1.5

Name: 		%name
Version: 	%version
Release: alt1.qa1

Summary: 	SQL Shell. It is intended as a replacement for the Sybase 'isql'.
License: 	GPL
Group: 		Databases
Url: 		http://www.sqsh.org/

Source0: 	http://www.sqsh.org/%name-%version.tar.bz2
Patch0:		%name-2.1.5-alt-makefile.patch
Patch1:		%name-2.1.5-alt-configure.patch

# Automatically added by buildreq on Sat May 22 2004
BuildRequires: libncurses-devel libreadline-devel
BuildRequires: libfreetds-devel >= 0.64
Requires: libfreetds >= 0.64

%description
Sqsh (pronounced skwish) is short for SQshelL (pronounced s-q-shell),
it is intended as a replacement for the venerable 'isql' program supplied
by Sybase. 

Sqsh is much more than a nice prompt (a la 'dsql', from David B. Joyner),
it is intended to provide much of the functionality provided by a good
shell, such as variables, aliasing, redirection, pipes, back-grounding,
job control, history, command substitution, and dynamic configuration.
Also, as a by-product of the design, it is remarkably easy to extend
and add functionality.

Sqsh can be used for make connection to any databases with TDS-protocol
support (eg. MS-SQL or Sybase). This package is build with FreeTDS
library (http://www.freetds.org).

%prep

%setup -q
%patch0 -p1 -b .alt-p0
%patch1 -p1 -b .alt-p1

%build
export SYBASE=/usr
export SYBASE_LIBDIR=%_libdir
%configure --with-readline=yes

%make_build

%install
make DESTDIR=%buildroot install
make DESTDIR=%buildroot install.man

%files
%config(noreplace) %_sysconfdir/sqshrc
%_bindir/sqsh
%_mandir/man1/sqsh.1*
%doc COPYING ChangeLog INSTALL README
%doc doc/FAQ doc/RELEASE doc/sample.* doc/*.sqshrc doc/sqsh.html

%changelog
