Name: squashfs
Version: 4.2
Release: alt1

Summary: squashfs support
License: GPL
Group: System/Kernel and hardware
Url: http://squashfs.sourceforge.net

Source0: %name%version.tar

BuildRequires: zlib-devel liblzma-devel liblzo2-devel

%description
Squashfs is a compressed read-only filesystem for Linux. Squashfs is
intended for general read-only filesystem use, for archival use
(i.e. in cases where a .tar.gz file may be used), and in constrained
block device/memory systems (e.g. embedded systems) where low overhead
is needed. The filesystem is currently stable, and has been tested on
PowerPC, i586, Sparc and ARM architectures.

%package -n squashfsprogs
Summary: Utilities to operate w/ squashfs
Group: System/Kernel and hardware
%description -n squashfsprogs
Squashfs is a compressed read-only filesystem for Linux. Squashfs is
intended for general read-only filesystem use, for archival use
(i.e. in cases where a .tar.gz file may be used), and in constrained
block device/memory systems (e.g. embedded systems) where low overhead
is needed. The filesystem is currently stable, and has been tested on
PowerPC, i586, Sparc and ARM architectures.

This package includes utilities to operate w/ squashfs.
Currently it includes mksquashfs and unsquashfs tools

%prep
%setup -q -n %name%version

%build
pushd squashfs-tools
%make_build XZ_SUPPORT=1 LZO_SUPPORT=1 COMP_DEFAULT=xz
popd


%install
%__mkdir_p %buildroot/sbin %buildroot/%_bindir
%__install -m 0755 squashfs-tools/mksquashfs %buildroot/sbin/
%__install -m 0755 squashfs-tools/unsquashfs %buildroot/%_bindir
ln -sf mksquashfs %buildroot/sbin/mkfs.squashfs
ln -sf ../../sbin/mksquashfs %buildroot%_bindir/mksquashfs

%files -n squashfsprogs
%doc ACKNOWLEDGEMENTS README CHANGES
/sbin/*
%_bindir/*

%changelog
