%def_disable poll
%def_enable epoll
%def_enable ecap
%def_enable esi

Name: squid
Version: 3.2.13
Release: alt5.M70P.1
%define langpack_ver 20121005
Summary: The Squid proxy caching server
License: GPLv2
Group: System/Servers
Url: http://www.squid-cache.org/
Source0: %name-%version.tar
Source1: %name-langpack-%langpack_ver.tar
Source2: %name.init
Source3: %name.logrotate
Source4: wbinfo_group.sh
Source5: %name.sysconfig
Source6: %name.pam
Source7: %name.service
Patch: %name-%version-%release.patch
Obsoletes: %name-novm %name-pinger
PreReq: net-snmp-mibs
Provides: %name-common = %version-%release
Obsoletes: %name-common
Provides: %name-server = %version-%release
Obsoletes: %name-server
Provides: %name-cachemgr = %version-%release
Obsoletes: %name-cachemgr
Conflicts: %name-conf-host2cat < 1.01-alt5
Provides: %name-conf-default = %version-%release
Obsoletes: %name-conf-default

# epoll is enabled by default, so disable it if plain poll is enabled
%{?_enable_poll:%force_disable epoll}

BuildConflicts: bind-devel
BuildPreReq: rpm-build >= 4.0.4-alt10
BuildRequires: doxygen  graphviz fonts-ttf-freefont
#BuildRequires: fonts-otf-drehatlas-widelands fonts-ttf-msimonson-anonymouspro
BuildRequires: gcc-c++ libcap-devel libdb4-devel libldap-devel libltdl-devel
BuildRequires: libpam-devel libsasl2-devel libssl-devel perl-Pod-Parser
BuildRequires: w3c-libwww-devel cppunit-devel
BuildRequires: libkrb5-devel
%{?_enable_ecap:BuildRequires: libecap-devel >= 0.2.0}
%{?_enable_esi:BuildRequires: libxml2-devel libexpat-devel}
# Used by smb_auth.pl,pop3.pl and squid_db_auth, required on find-requires stage:
BuildRequires: perl-Authen-Smb perl-libnet perl-DBI

%description
Squid is a high-performance proxy caching server for Web clients,
supporting FTP, gopher, and HTTP data objects. Unlike traditional
caching software, Squid handles all requests in a single,
non-blocking, I/O-driven process. Squid keeps meta data and especially
hot objects cached in RAM, caches DNS lookups, supports non-blocking
DNS lookups, and implements negative caching of failed requests.


%package doc
Summary: Squid documantation
Group: Documentation
Conflicts: %name < 3.1.22-alt3
BuildArch: noarch

%description doc
Squid is a high-performance proxy caching server for Web clients,
supporting FTP, gopher, and HTTP data objects. Unlike traditional
caching software, Squid handles all requests in a single,
non-blocking, I/O-driven process. Squid keeps meta data and especially
hot objects cached in RAM, caches DNS lookups, supports non-blocking
DNS lookups, and implements negative caching of failed requests.
Install squid if you need a proxy caching server.

This package contains documentation for Squid.


%package helpers
Summary: Squid helpers
Group: System/Servers
Requires: %name >= 3.1
Conflicts: %name <= 2.5.STABLE9-alt3
Provides: %name-helpers-perl = %version-%release
Obsoletes: %name-helpers-perl

%description helpers
This package contains Squid helpers for different kinds of authentication.


%prep
%setup -q %{?langpack_ver:-a 1}
%patch -p1

sed -i -r '1s|^(#!/usr/)local(/bin/perl)|\1\2|' {contrib,scripts}/*.pl


%build
%define _localstatedir %_var
./bootstrap.sh
%configure \
	CPPFLAGS="$(pkg-config --cflags-only-I libxml-2.0)" \
	--bindir=%_sbindir \
	--libexecdir=%_libexecdir/%name \
	--sysconfdir=%_sysconfdir/%name \
	--datadir=%_datadir/%name \
	--with-logdir=%_logdir/%name \
	--with-swapdir=%_localstatedir/spool/%name \
	--enable-strict-error-checking \
	--with-dl \
	--with-openssl \
	--with-libcap \
	--enable-forw-via-db \
%if_enabled debug
	--with-valgrind-debug \
	--disable-optimizations --enable-debug-cbdata --enable-stacktraces --enable-cpu-profiling \
%else
	--without-valgrind-debug \
	--enable-optimizations --enable-inline --disable-debug-cbdata --disable-stacktraces --disable-cpu-profiling \
%endif
	%{subst_enable poll} \
	%{subst_enable epoll} \
	%{subst_enable esi} \
	%{subst_enable ecap} \
	--enable-ipv6 \
	--enable-unlinkd \
	--enable-cachemgr-hostname=localhost \
	--enable-follow-x-forwarded-for \
	--enable-default-hostsfile=%_sysconfdir/hosts \
	--enable-snmp \
	--enable-removal-policies="lru heap" \
	--enable-delay-pools \
	--enable-icmp \
	--enable-htcp \
	--enable-async-io=16 \
	--enable-wccp \
	--enable-wccpv2 \
	--enable-arp-acl \
	--enable-ssl \
	--enable-forw-via-db \
	--enable-useragent-log \
	--enable-referer-log \
	--enable-ident-lookups \
	--enable-carp \
	--enable-ntlm-fail-open \
	--enable-cache-digests \
	--enable-x-accelerator-vary \
	--enable-auth \
	--enable-basic-auth-helpers="DB LDAP MSNT MSNT-multi-domain NCSA NIS PAM POP3 RADIUS SASL SMB fake getpwnam" \
	--enable-ntlm-auth-helpers="fake smb_lm" \
	--enable-digest-auth-helpers="LDAP eDirectory file" \
	--enable-negotiate-auth-helpers="kerberos wrapper" \
	--enable-external-acl-helpers="AD_group LDAP_group LM_group eDirectory_userip file_userip kerberos_ldap_group session unix_group wbinfo_group" \
	--enable-storeio="aufs diskd rock ufs" \
	--enable-disk-io \
	--enable-default-err-language="English" \
	--enable-icap-client \
	--disable-ipfw-transparent --disable-ipf-transparent --disable-pf-transparent \
	--enable-linux-netfilter \
	--enable-linux-tproxy \
	--with-large-files \
	--with-filedescriptors=16384 \
	--with-default-user="%name"

%make_build
sed -r 's/dyn/html/g;s/CALL(|ER_GRAPH)/#/' squid3.dox | doxygen -


%install
%makeinstall_std

install -pD -m 0755 %SOURCE2 %buildroot%_initddir/%name
install -pD -m 0644 %SOURCE3 %buildroot%_sysconfdir/logrotate.d/%name

install -d -m 0755 %buildroot{%_logdir,%_spooldir}/%name

install -p -m 0644 helpers/{external_acl/{AD,LM,kerberos_ldap}_group,negotiate_auth/kerberos}/*.8 %buildroot%_man8dir/

install -p -m 0755 %SOURCE4 %buildroot%_libexecdir/%name/
install -d -m 0755 %buildroot%_datadir/snmp/mibs
mv %buildroot%_datadir/%name/mib.txt %buildroot%_datadir/snmp/mibs/SQUID-MIB.txt

install -pD -m 0644 %SOURCE5 %buildroot%_sysconfdir/sysconfig/%name
install -pD -m 0644 %SOURCE6 %buildroot%_sysconfdir/pam.d/%name
install -pD -m 0644 %SOURCE7 %buildroot%_unitdir/%name.service

install -d -m 0755 %buildroot%_docdir/%name-%version/{helpers,html/Programming-Guide,scripts}
install -p -m 0644 doc/Programming-Guide/html/*{css,html,png} %buildroot%_docdir/%name-%version/html/Programming-Guide/
install -p -m 0644 doc/release-notes/*.html %buildroot%_docdir/%name-%version/html/
install -p -m 0644 COPYRIGHT README ChangeLog QUICKSTART SPONSORS doc/debug-sections.txt %buildroot%_docdir/%name-%version/
install -p -m 0644 scripts/*.pl %buildroot%_docdir/%name-%version/scripts/
install -p -m 0644 helpers/basic_auth/LDAP/README %buildroot%_docdir/%name-%version/helpers/README.LDAP
install -p -m 0644 helpers/basic_auth/SMB/COPYING-2.0 %buildroot%_docdir/%name-%version/helpers/SMB.COPYING-2.0
for i in LDAP RADIUS; do
	install -p -m 0644 helpers/basic_auth/$i/README %buildroot%_docdir/%name-%version/helpers/README.$i
done
for i in LDAP_group file_userip kerberos_ldap_group; do
	install -p -m 0644 helpers/external_acl/$i/README %buildroot%_docdir/%name-%version/helpers/README.$i
done
for i in kerberos; do
	install -p -m 0644 helpers/negotiate_auth/$i/README %buildroot%_docdir/%name-%version/helpers/README.$i
done
install -p -m 0644 helpers/basic_auth/SMB/ChangeLog %buildroot%_docdir/%name-%version/helpers/ChangeLog.$i
install -p -m 0644 helpers/basic_auth/MSNT/README.html %buildroot%_docdir/%name-%version/helpers/README.MSNT.html
install -p -m 0644 helpers/basic_auth/MSNT-multi-domain/README.txt %buildroot%_docdir/%name-%version/helpers/README.MSNT-multi-domain
install -p -m 0644 helpers/basic_auth/MSNT/msntauth.conf.default %buildroot%_docdir/%name-%version/helpers/


%check
%make_build check


%post
%post_service %name


%preun
%preun_service %name


%pre
%_sbindir/groupadd -r -f %name 2>/dev/null ||:
%_sbindir/useradd -r -N -M -g %name -d %_spooldir/%name -s /dev/null %name 2>/dev/null ||:
# fixing #6321, step 1/2
%_bindir/gpasswd -a squid shadow >/dev/null ||:

chown %name:%name %_logdir/%name/*.log >/dev/null 2>&1 ||:
chmod 660 %_logdir/%name/*.log >/dev/null 2>&1 ||:


%triggerpostun -- squid < 2.4.STABLE4-alt1
[ $2 -gt 0 ] || exit 0
chown -R %name:%name %_spooldir/%name >/dev/null 2>&1 ||:


%files
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/COPYRIGHT
%attr(750,root,%name) %dir %_sysconfdir/%name
%attr(750,root,%name) %dir %_libexecdir/%name
%config(noreplace) %_sysconfdir/%name/*
%config(noreplace) %_sysconfdir/sysconfig/*
%_initddir/*
%systemd_unitdir/%name.service
%config %_sysconfdir/logrotate.d/%name
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/snmp
%_sbindir/*
%_man8dir/squid.*
%_man1dir/*
%_libexecdir/%name/log_file_daemon
%attr(4710,root,%name) %_libexecdir/%name/pinger
%_libexecdir/%name/unlinkd
%_libexecdir/%name/diskd
%attr(3770,root,%name) %dir %_logdir/%name
%attr(2770,root,%name) %dir %_spooldir/%name
%exclude %_sysconfdir/%name/msntauth.conf*


%files doc
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/ChangeLog
%doc %_docdir/%name-%version/QUICKSTART
%doc %_docdir/%name-%version/README
%doc %_docdir/%name-%version/SPONSORS
%doc %_docdir/%name-%version/debug-sections.txt
%doc %_docdir/%name-%version/html
%doc %_docdir/%name-%version/helpers


%files helpers
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/scripts
%config(noreplace) %_sysconfdir/%name/msntauth.conf
%config(noreplace) %_sysconfdir/%name/msntauth.conf.default
%_libexecdir/%name/*
%attr(640,root,auth) %config(noreplace) %_sysconfdir/pam.d/%name
# fixing #6321, step 2/2
%attr(2711,root,auth) %_libexecdir/%name/basic_pam_auth
%_man8dir/*
%exclude %_libexecdir/%name/log_file_daemon
%exclude %_libexecdir/%name/pinger
%exclude %_libexecdir/%name/unlinkd
%exclude %_libexecdir/%name/diskd
%exclude %_libexecdir/%name/cachemgr.cgi
%exclude %_man8dir/squid.*
%exclude %_man8dir/cachemgr.cgi.*


%changelog
