Name: squidGuard
Version: 1.4
Release: alt1.qa1

%define _dbhomedir %_localstatedir/%name

Summary: Filter, redirector and access controller plugin for squid
License: GPLv2
Group: System/Servers
Url: http://www.squidguard.org/

Packager: Vladimir Scherbaev <vladimir at altlinux.org>

Source0: %name-%version.tar.gz
Source1: %name.conf
Source2: blacklists.tgz
Source3: squidGuard.logrotate
Source4: sg-utils-0.2.tar.gz
Source5: %name-ru.cgi

Patch0: %name-alt-fix-perm.patch
#Patch1: %name-alt-fix-req.patch
Patch2: %name-%version-alt-make.patch

Requires: squid-server logrotate
BuildRequires: flex libdb4.7-devel perl-DBM

%description
squidGuard can be used to
    - limit the web access for some users to a list of accepted/well known
    web servers and/or URLs only.
    - block access to some listed or blacklisted web servers and/or URLs
    for some users. **)
    - block access to URLs matching a list of regular expressions or words
    for some users. **)
    - enforce the use of domainnames/prohibit the use of IP address in
    URLs. **)
    - redirect blocked URLs to an "intelligent" CGI based info page. **)
    - redirect unregistered user to a registration form.
    - redirect popular downloads like Netscape, MSIE etc. to local copies.
    - redirect banners to an empty GIF. **)
    - have different access rules based on time of day, day of the week,
     date etc.
     - have different rules for different user groups.
     - and much more..

Neither squidGuard nor Squid can be used to
     - filter/censor/edit text inside documents
     - filter/censor/edit embeded scripting languages like JavaScript or
      VBscript inside HTML

%prep
%setup -q
%patch0
#%patch1 -p1
%patch2

%build
%configure \
#--with-sg-logdir=/var/log/squid \
#--with-sg-dbhome=%_dbhomedir \


%__make

%install
%makeinstall DESTDIR=%buildroot
%__mkdir_p %buildroot%_sysconfdir/%name
%__mkdir_p %buildroot%_dbhomedir
%__install -p -m 0644 %SOURCE1 %buildroot%_sysconfdir/%name/%name.conf
#%__tar xCf %buildroot%_dbhomedir %SOURCE2

%files
%doc ANNOUNCE CHANGELOG CONFIGURATION COPYING FAQ GPL INSTALL ISSUES.txt README README.LDAP
%doc doc/*.txt doc/*.html
%doc samples/*.conf samples/*.cgi
%_bindir/*
%config(noreplace) %_sysconfdir/%name/squidGuard.conf
#%_dbhomedir

%changelog
