%def_disable poll
%def_enable epoll
%def_enable ecap
%def_enable esi

%define bname squid
%define ver 3.1

Name: %{bname}_%ver
Version: %ver.23
%define langpack_ver 20121005
Release: alt6
Summary: The Squid proxy caching server
License: GPLv2
Group: System/Servers
Url: http://www.squid-cache.org/
Source0: %bname-%version.tar
Source1: %bname-langpack-%langpack_ver.tar
Source2: %bname.init
Source3: %bname.logrotate
Source4: wbinfo_group.sh
Source5: %bname.sysconfig
Source6: %bname.pam
Source7: %bname.service
Patch: %bname-%version-%release.patch
Obsoletes: %bname-novm %bname-pinger
PreReq: net-snmp-mibs
Provides: %bname-common = %version-%release
Obsoletes: %bname-common < %version-%release
Provides: %bname-server = %version-%release
Obsoletes: %bname-server < %version-%release
Provides: %bname-cachemgr = %version-%release
Obsoletes: %name-cachemgr < %version-%release
Conflicts: %bname-conf-host2cat < 1.01-alt5
Provides: %bname = %version-%release
Conflicts: %bname > %version-%release
Provides: %bname-helpers = %version-%release
Conflicts: %bname-helpers > %version-%release
Provides: %name-helpers-perl = %version-%release
Obsoletes: %name-helpers-perl < %version-%release

# epoll is enabled by default, so disable it if plain poll is enabled
%{?_enable_poll:%force_disable epoll}

BuildConflicts: bind-devel
BuildPreReq: rpm-build >= 4.0.4-alt10
BuildRequires: doxygen  graphviz fonts-ttf-freefont
#BuildRequires: fonts-otf-drehatlas-widelands fonts-ttf-msimonson-anonymouspro
BuildRequires: gcc-c++ libcap-devel libdb4-devel libldap-devel libltdl-devel
BuildRequires: libpam-devel libsasl2-devel libssl-devel perl-Pod-Parser
BuildRequires: w3c-libwww-devel cppunit-devel
BuildRequires: libkrb5-devel
%{?_enable_ecap:BuildRequires: libecap-devel = 0.0.3}
%{?_enable_esi:BuildRequires: libxml2-devel libexpat-devel}
# Used by smb_auth.pl,pop3.pl and squid_db_auth, required on find-requires stage:
BuildRequires: perl-Authen-Smb perl-libnet perl-DBI

%description
Squid is a high-performance proxy caching server for Web clients,
supporting FTP, gopher, and HTTP data objects. Unlike traditional
caching software, Squid handles all requests in a single,
non-blocking, I/O-driven process. Squid keeps meta data and especially
hot objects cached in RAM, caches DNS lookups, supports non-blocking
DNS lookups, and implements negative caching of failed requests.


%package doc
Summary: Squid documantation
Group: Documentation
Conflicts: %bname < 3.1.22-alt3
BuildArch: noarch
Provides: %bname-doc = %version-%release

%description doc
Squid is a high-performance proxy caching server for Web clients,
supporting FTP, gopher, and HTTP data objects. Unlike traditional
caching software, Squid handles all requests in a single,
non-blocking, I/O-driven process. Squid keeps meta data and especially
hot objects cached in RAM, caches DNS lookups, supports non-blocking
DNS lookups, and implements negative caching of failed requests.
Install squid if you need a proxy caching server.

This package contains documentation for Squid.


%prep
%setup -q -n %bname-%version %{?langpack_ver:-a 1}
%patch -p1

sed -i -r '1s|^(#!/usr/)local(/bin/perl)|\1\2|' {contrib,scripts}/*.pl


%build
./bootstrap.sh
%configure \
	CPPFLAGS="$(pkg-config --cflags-only-I libxml-2.0)" \
	--bindir=%_sbindir \
	--libexecdir=%_libexecdir/%bname \
	--localstatedir=%_var \
	--sysconfdir=%_sysconfdir/%bname \
	--datadir=%_datadir/%bname \
	--enable-strict-error-checking \
	--with-dl \
	--with-openssl \
	--with-libcap \
%if_enabled debug
	--with-valgrind-debug \
	--disable-optimizations --enable-debug-cbdata --enable-stacktraces --enable-cpu-profiling \
%else
	--without-valgrind-debug \
	--enable-optimizations --enable-inline --disable-debug-cbdata --disable-stacktraces --disable-cpu-profiling \
%endif
	%{subst_enable poll} \
	%{subst_enable epoll} \
	%{subst_enable esi} \
	%{subst_enable ecap} \
	--enable-ipv6 \
	--enable-unlinkd \
	--enable-cachemgr-hostname=localhost \
	--enable-follow-x-forwarded-for \
	--enable-default-hostsfile=%_sysconfdir/hosts \
	--enable-snmp \
	--enable-removal-policies="lru heap" \
	--enable-delay-pools \
	--enable-icmp \
	--enable-htcp \
	--enable-async-io=16 \
	--enable-wccp \
	--enable-wccpv2 \
	--enable-arp-acl \
	--enable-ssl \
	--enable-forw-via-db \
	--enable-useragent-log \
	--enable-referer-log \
	--enable-ident-lookups \
	--enable-carp \
	--enable-ntlm-fail-open \
	--enable-cache-digests \
	--enable-x-accelerator-vary \
	--enable-auth="basic ntlm digest negotiate" \
	--enable-basic-auth-helpers="DB LDAP MSNT NCSA PAM POP3 SASL SMB YP getpwnam multi-domain-NTLM squid_radius_auth" \
	--enable-ntlm-auth-helpers="smb_lm fakeauth no_check" \
	--enable-digest-auth-helpers="ldap password eDirectory" \
	--enable-negotiate-auth-helpers="squid_kerb_auth" \
	--enable-external-acl-helpers="ip_user ldap_group unix_group session wbinfo_group" \
	--enable-storeio="aufs diskd ufs" \
	--enable-disk-io \
	--enable-default-err-language="English" \
	--enable-icap-client \
	--disable-ipfw-transparent --disable-ipf-transparent --disable-pf-transparent \
	--enable-linux-netfilter \
	--enable-linux-tproxy \
	--with-large-files \
	--with-filedescriptors=16384 \
	--with-default-user="%bname"

%make_build
sed -r 's/dyn/html/g;s/CALL(|ER_GRAPH)/#/' squid3.dox | doxygen -


%install
%makeinstall_std

install -pD -m 0755 %SOURCE2 %buildroot%_initddir/%bname
install -pD -m 0644 %SOURCE3 %buildroot%_sysconfdir/logrotate.d/%bname

install -d -m 0755 %buildroot{%_logdir,%_spooldir}/%bname

install -p -m 0644 {doc,helpers/{basic_auth/{LDAP,PAM},external_acl/{ldap,unix}_group}}/*.8 %buildroot%_man8dir/

install -p -m 0755 %SOURCE4 %buildroot%_libexecdir/%bname/
install -d -m 0755 %buildroot%_datadir/snmp/mibs
mv %buildroot%_datadir/%bname/mib.txt %buildroot%_datadir/snmp/mibs/SQUID-MIB.txt

install -pD -m 0644 %SOURCE5 %buildroot%_sysconfdir/sysconfig/%bname
install -pD -m 0644 %SOURCE6 %buildroot%_sysconfdir/pam.d/%bname
install -pD -m 0644 %SOURCE7 %buildroot%_unitdir/%bname.service

install -d -m 0755 %buildroot%_docdir/%bname-%version/{helpers,html/Programming-Guide,scripts}
install -p -m 0644 doc/Programming-Guide/html/*{css,html,png} %buildroot%_docdir/%bname-%version/html/Programming-Guide/
install -p -m 0644 doc/release-notes/*.html %buildroot%_docdir/%bname-%version/html/
install -p -m 0644 COPYRIGHT README ChangeLog QUICKSTART SPONSORS doc/debug-sections.txt %buildroot%_docdir/%bname-%version/
install -p -m 0644 scripts/*.pl %buildroot%_docdir/%bname-%version/scripts/
install -p -m 0644 helpers/basic_auth/LDAP/README %buildroot%_docdir/%bname-%version/helpers/README.LDAP
install -p -m 0644 helpers/basic_auth/SMB/README %buildroot%_docdir/%bname-%version/helpers/README.SMB
for i in SMB MSNT; do
	install -p -m 0644 helpers/basic_auth/$i/COPYING-2.0 %buildroot%_docdir/%bname-%version/helpers/$i.COPYING-2.0
done
for i in LDAP SASL SMB; do
	install -p -m 0644 helpers/basic_auth/$i/README %buildroot%_docdir/%bname-%version/helpers/README.$i
done
for i in ip_user unix_group; do
	install -p -m 0644 helpers/external_acl/$i/README %buildroot%_docdir/%bname-%version/helpers/README.$i
done
install -p -m 0644 helpers/basic_auth/SMB/ChangeLog %buildroot%_docdir/%bname-%version/helpers/ChangeLog.$i
install -p -m 0644 helpers/basic_auth/MSNT/README.html %buildroot%_docdir/%bname-%version/helpers/README.MSNT.html
install -p -m 0644 helpers/basic_auth/multi-domain-NTLM/README.txt %buildroot%_docdir/%bname-%version/helpers/README.NTLM
install -p -m 0644 helpers/basic_auth/{MSNT/msntauth.conf.default,SMB/smb_auth.sh,SASL/squid_sasl_auth*} \
	helpers/{external_acl/ip_user/*.conf,ntlm_auth/no_check/README.no_check_ntlm_auth} \
	%buildroot%_docdir/%bname-%version/helpers/


%check
%make_build check


%post
%post_service %bname


%preun
%preun_service %bname


%pre
%_sbindir/groupadd -r -f %bname 2>/dev/null ||:
%_sbindir/useradd -r -N -M -g %bname -d %_spooldir/%bname -s /dev/null %bname 2>/dev/null ||:
# fixing #6321, step 1/2
%_bindir/gpasswd -a squid shadow >/dev/null ||:

chown %bname:%bname %_logdir/%bname/*.log >/dev/null 2>&1 ||:
chmod 660 %_logdir/%bname/*.log >/dev/null 2>&1 ||:


%triggerpostun -- squid < 2.4.STABLE4-alt1
[ $2 -gt 0 ] || exit 0
chown -R %bname:%bname %_spooldir/%bname >/dev/null 2>&1 ||:


%files
%doc %dir %_docdir/%bname-%version
%doc %_docdir/%bname-%version/COPYRIGHT
%attr(750,root,%bname) %dir %_sysconfdir/%bname
%attr(750,root,%bname) %dir %_libexecdir/%bname
%config(noreplace) %_sysconfdir/%bname/*
%config(noreplace) %_sysconfdir/sysconfig/*
%_initddir/*
%systemd_unitdir/%bname.service
%config %_sysconfdir/logrotate.d/%bname
%dir %_datadir/%bname
%_datadir/%bname/*
%_datadir/snmp/mibs
%_sbindir/*
%_man8dir/squid.*
%_man1dir/*
%attr(4710,root,%bname) %_libexecdir/%bname/pinger
%_libexecdir/%bname/unlinkd
%_libexecdir/%bname/diskd
%attr(3770,root,%bname) %dir %_logdir/%bname
%attr(2770,root,%bname) %dir %_spooldir/%bname
# helpers
%doc %_docdir/%bname-%version/scripts
%config(noreplace) %_sysconfdir/%bname/msntauth.conf
%config(noreplace) %_sysconfdir/%bname/msntauth.conf.default
%attr(640,root,auth) %config(noreplace) %_sysconfdir/pam.d/%bname
%_libexecdir/%bname/*
# fixing #6321, step 2/2
%attr(2711,root,auth) %_libexecdir/%bname/pam_auth
%_man8dir/*


%files doc
%doc %dir %_docdir/%bname-%version
%doc %_docdir/%bname-%version/ChangeLog
%doc %_docdir/%bname-%version/QUICKSTART
%doc %_docdir/%bname-%version/README
%doc %_docdir/%bname-%version/SPONSORS
%doc %_docdir/%bname-%version/debug-sections.txt
%doc %_docdir/%bname-%version/html
%doc %_docdir/%bname-%version/helpers


%changelog
