# User and group name for ss5
%define ss5_user ss5
%define ss5_group ss5
# Home for ss5 user
%define ss5_home /dev/null
# Shell for ss5 user
%define ss5_shell /dev/null
# Default address to bind
%define ss5_bindaddr 127.0.0.1
# Default port to bind
%define ss5_bindport 1080

Name: ss5
Version: 3.6.4
Release: alt2.rel3.2.qa1

Summary: Full featured SOCKS4 and SOCKS5 server
Summary(ru_RU.UTF-8): Многофункциональный сервер SOCKS4 и SOCKS5
License: GPL
Group: System/Servers

Url: http://ss5.sourceforge.net/

Source: %name-%version.tar.gz
Source1: %name.init
Source2: %name.pam
Source3: %name.sysconfig
Source4: %name.conf

# Fix hardcoded peers file path
#Patch0: %name-peerspath.patch
# Pid file support
Patch1: %name-pidfilesupport.patch
# Improved signal handling
Patch2: %name-signalhandling.patch
# Added libraries to fix unresolved symbols
Patch3: %name-makefile.patch
# More correct daemonize
Patch4: %name-daemon.patch
# array index overflow
Patch5: ss5-3.6.4-CVE-2009-2368.patch

Requires: openldap pam
BuildRequires: openldap-devel pam-devel

%description
ss5 is a full featured socks server, which supports both SOCKS4 and SOCKS5 protocols,
that runs on Linux/Solaris platforms.

%description -l ru_RU.UTF-8
ss5 - это многофункциональный socks-сервер, который поддерживает протоколы
SOCKS4 и SOCKS5 и работает на платформах Linux/Solaris.

%prep
%setup -q
#%%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p2
%patch5 -p2

%build
%configure  --with-configfile=%_sysconfdir/%name/%name.conf \
			--with-passwordfile=%_sysconfdir/%name/%name.passwd \
			--with-logfile=%_var/log/%name/%name.log \
			--with-profilepath=%_sysconfdir/%name \
			--with-libpath=%_libdir \
			--with-tracepath=%_var/log/%name \
			--with-defaultuser=%ss5_user \
			--with-defaultaddr=%ss5_bindaddr \
			--with-defaultport=%ss5_bindport \	

%make

%install
%__mkdir_p %buildroot%_sysconfdir/%name
%__mkdir_p %buildroot%_initdir
%__mkdir_p %buildroot%_sysconfdir/{sysconfig,pam.d}
%__mkdir_p %buildroot%_libdir/%name
%__mkdir_p %buildroot%_bindir
%__mkdir_p %buildroot%_var/run/%name
%__mkdir_p %buildroot%_var/log/%name
%__mkdir_p %buildroot%_man1dir
%__mkdir_p %buildroot%_man5dir

find . -type f -name *.so -exec %__install -m644 '{}' %buildroot%_libdir/%name/ \;
%__install -m755 src/%name %buildroot%_bindir/
%__install -m755 %SOURCE1 %buildroot%_initdir/%name
%__install -m640 %SOURCE2 %buildroot/%_sysconfdir/pam.d/%name
%__install -m640 %SOURCE3 %buildroot/%_sysconfdir/sysconfig/%name
%__install -m640 %SOURCE4 %buildroot%_sysconfdir/%name/
%__install -m644 man/Linux/*\.1\.* %buildroot%_man1dir/
%__install -m644 man/Linux/*\.5\.* %buildroot%_man5dir/

%pre
/usr/sbin/groupadd -r -f %ss5_group
/usr/sbin/useradd -r -g %ss5_group -d %ss5_home -M -s %ss5_shell -n -c "Socks5 server" %ss5_user >/dev/null 2>&1 ||:

%post
%post_service %name

%preun
%preun_service %name

%files
%doc doc/* conf/* ChangeLog INSTALL License SOLARIS.NOTES
%attr(0750,root,%ss5_group) %dir %_sysconfdir/%name
%attr(0640,root,%ss5_group) %config(noreplace) %_sysconfdir/%name/*
%config(noreplace) %_sysconfdir/pam.d/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%_initdir/*
%_bindir/*
%attr(1770,root,%ss5_group) %dir %_var/run/%name
%attr(1770,root,%ss5_group) %dir %_var/log/%name
%_man1dir/*
%_man5dir/*
%_libdir/%name


%changelog
