Name: stardict
Version: 3.0.3
Release: alt3

Summary: StarDict dictionary
License: GPLv3+
Group: System/Internationalization
Url: http://www.stardict.org

# http://stardict-3.googlecode.com/files/%name-%version.tar.bz2
Source: %name-%version.tar
Source3: docklet_normal.png
Source4: docklet_scan.png
Source5: docklet_stop.png
Source6: slovnyktodict.awk
Source7: mueller2stardict.sh

Patch1: stardict-3.0.3-rh-gcc46.patch
Patch2: stardict-3.0.3-rh-glib2.patch
Patch3: stardict-3.0.3-alt-dsl2dict.patch
Patch4: stardict-3.0.3-alt-linkage.patch
Patch5: stardict-3.0.3-alt-desktop.patch
Patch6: stardict-3.0.3-alt-tabfile.patch
Patch7: stardict-3.0.3-alt-zlib.patch
Patch8: stardict-3.0.3-alt-buffer.patch

Provides: %name-common = %version
Obsoletes: %name-common < %version
Provides: %name-gtk = %version
Obsoletes: %name-gtk < %version
Provides: %name-gnome = %version
Obsoletes: %name-gnome < %version

%def_disable dictdotcn

# Automatically added by buildreq on Mon May 28 2012
# optimized out: docbook-dtds fontconfig fontconfig-devel glib2-devel gnome-doc-utils-xslt libICE-devel libX11-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libgpg-error libgtk+2-devel libpango-devel libstdc++-devel libwayland-client libwayland-server perl-Encode perl-XML-Parser pkg-config python-base python-module-libxml2 python-modules python-modules-encodings xml-common xml-utils xorg-xproto-devel xsltproc zlib-devel
BuildRequires: gcc-c++ gnome-doc-utils hardlink imake intltool libSM-devel libenchant-devel libespeak-devel libgucharmap7-devel libmysqlclient-devel libsigc++2-devel libxml2-devel xorg-cf-files

%description
StarDict is a Cross-Platform and international dictionary written in
Gtk2.  It has powerful features such as glob-style pattern matching,
scan selection, and fuzzy matching.

%package tools
Summary: Tools for making dictionary files for stardict
Group: Development/Other

%description tools
This package contains various tools for converting dictionaries in
stardict format.

%package plugin-espeak
Summary: Espeak plugin
Group: System/Internationalization
Requires: %name = %version-%release

%description plugin-espeak
This package contains espeak plugin for stardict.

%package plugin-gucharmap
Summary: Gucharmap plugin
Group: System/Internationalization
Requires: %name = %version-%release

%description plugin-gucharmap
This package contains gucharmap plugin for stardict.

%package plugin-spell
Summary: Spell plugin
Group: System/Internationalization
Requires: %name = %version-%release

%description plugin-spell
This package contains spell plugin for stardict.

%package plugin-dictdotcn
Summary: dictdotcn plugin
Group: System/Internationalization
Requires: %name = %version-%release

%description plugin-dictdotcn
This package contains dictdotcn netdict plugin for stardict,
querying dict.cn via network.
Warning: this package is insecure. Use at your own risk.

%prep
%setup
# remove bundled sigc++ header files
rm -r dict/src/sigc++*
sed -i '/src\/sigc++/d' dict/configure.ac
sed -i 's/ sigc++ sigc++config//' dict/src/Makefile.am
# remove bundled libtool files
rm */m4/{lt*,libtool}.m4 dict/m4/{gnome-doc-utils,intltool}.m4
# remove use of gconf macros
sed -i '/AM_GCONF_SOURCE_2/d' dict/configure.ac

%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
install -pm644 %_sourcedir/docklet_*.png dict/src/pixmaps/

%build
%autoreconf
export CPPFLAGS="$(getconf LFS_CFLAGS)"
%configure \
 --enable-spell \
 --enable-gucharmap \
 --enable-espeak \
 --disable-gnome-support \
 --disable-festival \
 --disable-man \
 --disable-updateinfo \
 --disable-advertisement \
 --disable-gpe-support \
 --disable-maemo-support \
 %{subst_enable dictdotcn} \
 #
%make_build

%install
%makeinstall_std scrollkeeper_localstate_dir=%buildroot%_var/lib/scrollkeeper
find %buildroot%_libdir -name '*.la' -delete

cd tools/src
install -pm755 *2dic stardict-dict-update stardict-verify \
	       stardict-repair stardict2txt tabfile \
	%buildroot%_bindir/
install -pm755 mova %buildroot%_bindir/mova2dic
cd - >/dev/null

install -pm755 %_sourcedir/{slovnyktodict.awk,mueller2stardict.sh} \
	%buildroot%_bindir/

%find_lang --with-gnome %name

hardlink -cv %buildroot%_datadir

%set_verify_elf_method strict

%files -f %name.lang
%_bindir/%name
%_datadir/%name
%_pixmapsdir/*
%_desktopdir/%name.desktop
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/stardict_html_parsedata.*
%_libdir/%name/plugins/stardict_powerword_parsedata.*
%_libdir/%name/plugins/stardict_wiki_parsedata.*
%_libdir/%name/plugins/stardict_xdxf_parsedata.*
%_libdir/%name/plugins/stardict_qqwry.*
%_libdir/%name/plugins/stardict_wordnet.*
%_libdir/%name/plugins/stardict_wordnet_parsedata.*
%_man1dir/*
%doc dict/AUTHORS dict/ChangeLog
%doc dict/doc/{StarDictFileFormat,FAQ,HACKING,HowToCreateDictionary}

%files tools
%_bindir/*
%exclude %_bindir/%name
%doc tools/AUTHORS tools/ChangeLog tools/README tools/src/example.ifo

%files plugin-espeak
%_libdir/%name/plugins/stardict_espeak.*

%files plugin-gucharmap
%_libdir/%name/plugins/stardict_gucharmap.*

%files plugin-spell
%_libdir/%name/plugins/stardict_spell.*

%if_enabled dictdotcn
%files plugin-dictdotcn
%_libdir/%name/plugins/stardict_dictdotcn.*
%endif

%changelog
