Name: strace
Version: 4.10
Release: alt1

Summary: Tracks and displays system calls associated with a running process
License: BSD-style
Group: Development/Debuggers
Url: http://sourceforge.net/projects/strace/

# http://git.altlinux.org/gears/s/strace.git
Source: %name-%version-%release.tar

# due to use of deprecated -k option
Conflicts: rpm-utils <= 0:0.9.11-alt1

BuildRequires: libacl-devel libaio-devel
# for test suite
%{?!_without_check:%{?!_disable_check:BuildRequires: /proc}}

%package utils
Summary: Processes strace output and displays a graph of invoked subprocesses
Group: Development/Debuggers
BuildArch: noarch
Requires: %name = %version-%release

%description
The strace program intercepts and records the system calls called and
the signals received by a running process.  strace can print a record of
each system call, its arguments and its return value.  strace is useful
for diagnosing problems and debugging, as well as for instructional
purposes.

%description utils
The strace-graph Perl script processes strace -f output and displays
a graph of invoked subprocesses.  It is useful for finding out what
complex commands do.

%prep
%setup -n %name-%version-%release
echo -n %version-%release > .tarball-version

%build
./bootstrap -sv
mkdir build
cd build
%define _configure_script ../configure
%configure --enable-gcc-Werror #--enable-maintainer-mode
%make_build

%install
%makeinstall_std -C build
%set_verify_elf_method strict

%check
export SLEEP_A_BIT='sleep 0.1'
%make_build -k check -C build VERBOSE=1

%files
%_bindir/strace
%_bindir/strace-log-merge
%_mandir/man?/*
%doc COPYING CREDITS NEWS README README-linux-ptrace

%files utils
%_bindir/strace-graph

%changelog
