# hey Emacs, its -*- mode: rpm-spec; coding: cyrillic-cp1251; -*-
# Subversion
# Notes:
# * Do not build subversion on the system where an older version is
#   installed. Subversion links against system-installed libraries in
#   that case which may lead to failed tests or other failures during
#   validation stage. Prefer to build subversion in hasher.
# * Update alt-bdb patch when libdb version changes. Otherwise you may
#   have failures in tests for FS_TYPE=bdb.
%set_verify_elf_method unresolved=relaxed
%def_without doc
%def_disable static

%def_enable sqlite_external
%def_with server
%def_with dav
%ifarch %arm
%def_without javahl
%else
%def_with javahl
%endif
%def_with swig_py
%def_with swig_pl
%def_with kwallet
%def_with gnome_keyring
# Temporarily disbled due to fail on x86_64
%def_without swig_rb
# Note: this spec does not have support for building with swig_java
%def_without swig_java

# Global switch to enable/diable all tests
%def_disable check
# Use these switches to selectively turn on/off some of tests
# These make sence only if tests enabled
%def_with fsfs_check
%def_with bdb_check
%def_with pl_check
%def_without rb_check
%def_with javahl_check

%define check_lops 5

%define svn_ver_pre %nil
%define svn_rel alt1

# for %%libdb_soname_req macros
%define apr_name libapr1
%define apr_ver 1.4.6-alt0.M60P.1
%define apu_name libaprutil1
%define apu_ver 1.5.1-alt0.M60P.1

# solo's macros for full libdb version to point it in requires
# set %%libdb_soname_req (for Requires: <libname>-libdb = %%libdb_soname_req)
%define libdb_soname_req 4%(rpm -q --whatprovides libdb4-devel | sed -r 's/^libdb4(\\.[^-]+)-devel-.+$/\\1/')

%define svn_user subversion
%define svn_group subversion
%define svn_repo_dir %_localstatedir/subversion
%define svn_service svnserve

%define module_name dav_svn
%define modname dav_svn_module

Name:     subversion
Version:  1.8.13
Release:  alt0.M70P.2

Summary:  A version control system
Group:    Development/Other
License:  Apache
Url:      http://subversion.apache.org/
Packager: Andrey Cherepanov <cas@altlinux.org>

Source:  %name-%version%svn_ver_pre.tar.bz2
Source1: %name.el
Source2: %name-config-1.4.0.tar
Source3: svnserve.init
Source4: svnserve.sysconfig
Source5: %module_name.conf
Source6: svnwrapper

Source9: %module_name.load
Source10: %module_name.start

Source11: sqlite3-amalgamation-3.6.11.c

Patch4: %name-1.5.4-alt-perl-DESTROY.patch
Patch5: %name-1.7.8-alt-custom-libtool.patch
Patch6: %name-1.8.13-alt-kwallet-build.patch

# http://bugs.gentoo.org/show_bug.cgi?id=219959
Patch16: %name-1.6.0-gentoo-java-headers.patch

# http://svn.haxx.se/dev/archive-2008-07/0494.shtml
Patch17: %name-1.6.6-deb-ssh-no-controlmaster.patch

# Patches from Fedora
Patch20: subversion-1.8.0-rpath.patch
Patch21: subversion-1.8.0-pie.patch
Patch22: subversion-1.8.0-rubybind.patch
Patch23: subversion-1.8.5-swigplWall.patch
Patch24: subversion-1.8.13-r1655262+.patch
Patch25: subversion-1.8.13-swigpython.patch
Patch26: subversion-1.8.11-ruby22-fixes.rb
Patch27: subversion-1.8-sqlite-r1672295.patch

Requires: lib%name = %version-%release

# Automatically added by buildreq on Mon Nov 03 2008
BuildRequires: libcom_err-devel zlib-devel libexpat-devel

# unconditionally need by configure
BuildRequires: libapr1-devel >= %apr_ver
BuildRequires: libaprutil1-devel >= %apu_ver

# it is not nesessary for simple build, but dav require this
BuildRequires: libneon-devel libkeyutils-devel

BuildRequires: libserf-devel
BuildRequires: libsasl2-devel

# since 1.6.0 subversion requires sqlite
# if sqlite_external is enabled subversion will be linked with system's sqlite
# else subversion will use sqlite-amalgamation ($SOURCE9)
%{?_enable_sqlite_external:BuildRequires: libsqlite3-devel >= 3.4.0}

%{?_enable_static:BuildPreReq: glibc-devel-static}

%{?_with_gnome_keyring:BuildRequires: libdbus-devel libgnome-keyring-devel}
%{?_with_kwallet:BuildRequires: gcc-c++ libdbus-devel kde4libs-devel}
%{?_with_swig_py:BuildPreReq: swig python-devel}
%{?_with_swig_pl:BuildPreReq: swig perl-devel perl(PerlIO.pm)}
%{?_with_swig_rb:BuildPreReq: swig libruby-devel}
%{?_with_javahl:BuildPreReq: gcc-c++ junit java-devel-default /proc}
%{?_with_dav:BuildPreReq: apache2-devel}

# For tests
BuildRequires: python-modules-sqlite3

%add_findprov_lib_path %_libdir/libsvn_swig

%description
The goal of the Subversion project is to build a revision system that is
a compelling replacement for CVS in the open community.  The software is
released under an Apache/BSD-style source license.  See the status page
for current progress.
This package contains command-line subversion utilities: svn and
svnversion. For more utilities please look for package
subversion-server-common.

%package -n lib%name
Summary: Shared libraries required for subversion
Group: System/Libraries
Requires: %apr_name >= %apr_ver
Requires: %apu_name >= %apu_ver
Requires: libaprutil1-libdb = %libdb_soname_req

%description -n lib%name
The goal of the Subversion project is to build a revision system that is
a compelling replacement for CVS in the open community.  The software is
released under an Apache/BSD-style source license.  See the status page
for current progress.

%package -n lib%name-devel
Summary: Development files for applications which will use subversion libraries
Group: Development/C
Provides: %name-devel = %version-%release
Requires: lib%name = %version-%release
%{?_with_kwallet:Requires: lib%name-auth-kwallet = %version-%release}
%{?_with_gnome_keyring:Requires: lib%name-auth-gnome-keyring = %version-%release}
Requires: %apr_name-devel >= %apr_ver
Requires: %apu_name-devel >= %apu_ver
Requires: libneon-devel

%description -n lib%name-devel
The goal of the Subversion project is to build a revision system that is
a compelling replacement for CVS in the open community.  The software is
released under an Apache/BSD-style source license.  See the status page
for current progress.

%package -n lib%name-devel-static
Summary: Static libraries for developing statically linked applications which will use subversion libraries
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
The goal of the Subversion project is to build a revision system that is
a compelling replacement for CVS in the open community.  The software is
released under an Apache/BSD-style source license.  See the status page
for current progress.

%package -n lib%name-auth-kwallet
Summary: KDE4 KWallet auth module
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-auth-kwallet
The goal of the Subversion project is to build a revision system that is
a compelling replacement for CVS in the open community.  The software is
released under an Apache/BSD-style source license.  See the status page
for current progress.

This package contains the KDE4 KWallet auth module.

%package -n lib%name-auth-gnome-keyring
Summary: Gnome Keyring auth module
Group: Development/Other
Requires: lib%name = %version-%release

%description -n lib%name-auth-gnome-keyring
The goal of the Subversion project is to build a revision system that is
a compelling replacement for CVS in the open community.  The software is
released under an Apache/BSD-style source license.  See the status page
for current progress.

This package contains the Gnome Keyring auth module.

%if_with swig_py
%package python
Summary: Pyhton bindings for Subversion
Group: Development/Other
Requires: lib%name = %version-%release

%description python
The goal of the Subversion project is to build a revision system that is
a compelling replacement for CVS in the open community.  The software is
released under an Apache/BSD-style source license.  See the status page
for current progress.
This package contains the files necessary to use the subversion library
functions within python scripts.
%endif

%if_with swig_pl
%package perl
Summary: Perl bindings for Subversion
Group: Development/Other
Requires: lib%name = %version-%release

# The following dependecies where found before 'relaxed' _perl_req_method:
#   perl(File/Temp.pm)
#   perl(IO/Handle.pm)
#   perl(Symbol.pm)
#   perl(overload.pm)
#   perl(warnings.pm) - still found automatically
# Now we need to specify dependencies manually (except thouse still found automatically)
Requires: perl(File/Temp.pm)
Requires: perl(IO/Handle.pm)
Requires: perl(Symbol.pm)
Requires: perl(overload.pm)

%description perl
The goal of the Subversion project is to build a revision system that is
a compelling replacement for CVS in the open community.  The software is
released under an Apache/BSD-style source license.  See the status page
for current progress.
This package contains the files necessary to use the subversion library
functions within perl scripts.
%endif

%if_with swig_rb
%package ruby
Summary: Ruby bindings for Subversion
Group: Development/Other
Requires: lib%name = %version-%release

%description ruby
The goal of the Subversion project is to build a revision system that is
a compelling replacement for CVS in the open community.  The software is
released under an Apache/BSD-style source license.  See the status page
for current progress.
This package contains the files necessary to use the subversion library
functions within ruby scripts.
%endif

%if_with swig_java
%package java
Summary: Java bindings for Subversion
Group: Development/Other
Requires: lib%name = %version-%release
%endif

%if_with javahl
%package javahl
Summary: JavaHL bindings for Subversion
Group: Development/Other
Requires: lib%name = %version-%release

%description javahl
The goal of the Subversion project is to build a revision system that is
a compelling replacement for CVS in the open community.  The software is
released under an Apache/BSD-style source license.  See the status page
for current progress.
This package contains the files necessary to use the subversion library
functions within java.
%endif

%package doc
Summary: Subversion documentation
Group: Books/Other

%description doc
This package contains subversion documentation:
+ the "Version Control with Subversion" book,
+ documents for Subversion programmers,
+ documents for Subversion users.

%package server-common
Summary: Common files required to maintain subversion server
Group: System/Servers
Requires: lib%name = %version-%release

%description server-common
The goal of the Subversion project is to build a revision system that is
a compelling replacement for CVS in the open community.  The software is
released under an Apache/BSD-style source license.  See the status page
for current progress.
This package contains common files required for maintaing subversion
repositories.

%package server-standalone
Summary: Subversion standalone server
Group: System/Servers
Requires: %name-server-common = %version-%release
Requires: /bin/su
BuildArch: noarch

%description server-standalone
The goal of the Subversion project is to build a revision system that is
a compelling replacement for CVS in the open community.  The software is
released under an Apache/BSD-style source license.  See the status page
for current progress.
This package contains scripts for running standalone subversion server.

%package server-dav
Summary: Subversion server module for Apache
Group: System/Servers
Requires: %name-server-common = %version-%release

%description server-dav
The goal of the Subversion project is to build a revision system that is
a compelling replacement for CVS in the open community.  The software is
released under an Apache/BSD-style source license.  See the status page
for current progress.
This package contains the apache2 server shared module for running
subversion server.

%prep
%setup -q -n %name-%version%svn_ver_pre
%if_disabled sqlite_external
install -pD -m644 %SOURCE11 sqlite-amalgamation/sqlite3.c
%endif

%patch4 -p1
%patch5 -p2
%patch6 -p2
%patch16 -p1
%patch17 -p1
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p0
%patch27 -p0

%build
%add_optflags %optflags_shared

LIBTOOL_M4=%{_datadir}/libtool/aclocal ./autogen.sh
%autoreconf
%configure \
        %{subst_enable static} --enable-shared \
	--disable-debug \
	--disable-mod-activation \
        --with-custom-libtool=/usr/bin/libtool \
        --with-berkeley-db=db.h:/usr/include/db4:%_libdir:db-4 \
        --with-apr=%prefix --with-apr-util=%prefix \
	--with-apache-libexecdir=%apache2_moduledir \
	--with-swig --with-serf=%prefix \
	--with-sasl \
        %{?_with_gnome_keyring:--with-gnome-keyring} \
        %{subst_with kwallet} \
        %{?_with_dav:--with-apxs=%apache2_apxs} \
        %{?_with_swig_rb:RUBY='%ruby_vendor' --with-ruby-sitelibdir=%ruby_sitelibdir --with-ruby-sitearchdir=%ruby_sitearchdir} \
        %{?_with_javahl:--enable-javahl --with-jdk=/usr/lib/jvm/java --with-jikes=no --with-junit=/usr/share/java/junit.jar} \
        %{!?_with_javahl:--disable-javahl}

%make_build

%if_with swig_py
%make_build libdir=%_libdir/libsvn_swig swig_pydir=%python_sitelibdir/libsvn swig_pydir_extra=%python_sitelibdir/svn swig-py
%endif

%if_with swig_pl
%make_build libdir=%_libdir/libsvn_swig swig-pl-lib
%make_build libdir=%_libdir/libsvn_swig autogen-swig-pl

SVN_VER_MAJOR=`awk '/^#define SVN_VER_MAJOR/ {print $3}' subversion/include/svn_version.h`
SVN_VER_MINOR=`awk '/^#define SVN_VER_MINOR/ {print $3}' subversion/include/svn_version.h`
SVN_VER_PATCH=`awk '/^#define SVN_VER_PATCH/ {print $3}' subversion/include/svn_version.h`

pushd subversion/bindings/swig/perl/native
# This does not work (libraries are being build with RPATH entries, #9307)
#%%perl_vendor_build all

perl Makefile.PL INSTALLDIRS=vendor PREFIX=%_prefix
sed -i 's|^\(LD_RUN_PATH =\).*|\1 %_libdir/libsvn_swig|' Makefile Makefile.[a-z]*
%make_build libdir=%_libdir/libsvn_swig all

sed -i "s/\$SVN::Core::VERSION = .*/\$SVN::Core::VERSION = '$SVN_VER_MAJOR.$SVN_VER_MINOR.$SVN_VER_PATCH';/" Core.pm

popd
%endif

%if_with swig_rb
%make_build libdir=%_libdir/libsvn_swig swig-rb
%endif

%if_with javahl
%make_build javahl
%endif

%if_with doc
# Build subversion documentation
%make XSL_DIR=/usr/share/xml/docbook/xsl-stylesheets \
    doc-all-html doc-all-info

doxygen doc/doxygen.conf
%endif

sed -i 's:#!/usr/bin/env python2:#!/usr/bin/env python:' tools/hook-scripts/mailer/mailer.py
sed -i 's:/usr/bin/env python2$:/usr/bin/env python:' tools/hook-scripts/*.py

%check
# Running tests
%if_enabled check

# There is a workaround to run tests in a chrooted environment
# We need to set LD_LIBRARY_PATH to make all tests executed successfuly
PWD=`pwd`
LDLP=`find subversion -type d -name .libs|while read dir; do echo "$PWD/$dir"; done|xargs echo|tr ' ' ':'`

# Perform generic tests against bdb and fsfs
run_make_check(){
	fs_type=$1
	for ((i=1; i <= %check_lops ; i++))
	do
		LD_LIBRARY_PATH="$LDLP" %make FS_TYPE=$fs_type CLEANUP=true check && return 0 ||:
	done
	exit 1
}

%if_with fsfs_check
run_make_check fsfs
%endif

%if_with bdb_check
run_make_check bdb
%endif

%if %with swig_pl && %with pl_check
LD_LIBRARY_PATH="$LDLP" %make check-swig-pl
%endif

%if %with swig_rb && %with rb_check
LD_LIBRARY_PATH="$LDLP" %make check-swig-rb
%endif

# Perform JavaHL tests
%if %with javahl && %with javahl_check
LD_LIBRARY_PATH="$LDLP" %make JAVA_CLASSPATH=%_javadir/junit.jar check-javahl
%endif

%endif # enabled check

%install
# Setting to relaxed untill #9307 resolved
# The following dependecies where found before 'relaxed':
#   perl(File/Temp.pm)
#   perl(IO/Handle.pm)
#   perl(Symbol.pm)
#   perl(overload.pm)
#   perl(warnings.pm)
%set_perl_req_method relaxed

%make_install DESTDIR=%buildroot INSTALL_LOCALE='install -p -m644 -D' install
mkdir -p %buildroot%_sysconfdir/%name
tar -xf %SOURCE2 -C %buildroot%_sysconfdir/%name

use_svnwrapper()
{
	local destbindir=%buildroot%_bindir
	local target=$1
	local suffix=".bin"
	local wrappername="svnwrapper"
	mv "$destbindir/$target" "$destbindir/$target$suffix"
	ln -s "$wrappername" "$destbindir/$target"
}

# Installing svnwrapper
cp %SOURCE6 %buildroot%_bindir
# Making svnserve to use svnwrapper
# Do not forget to update %%files section if using wrappers for other binaries
use_svnwrapper svnserve
#use_svnwrapper svn
#use_svnwrapper svnadmin

# Create directory for libsvn_swig libraries
mkdir -p %buildroot%_libdir/libsvn_swig

%if_with swig_py
%make_install DESTDIR=%buildroot libdir=%_libdir/libsvn_swig swig_py_libdir=%_libdir/libsvn_swig \
    swig_pydir=%python_sitelibdir/libsvn swig_pydir_extra=%python_sitelibdir/svn install-swig-py
rm -f %buildroot%_libdir/libsvn_swig/libsvn_swig_py*.la
cp -r %_builddir/%buildsubdir/subversion/bindings/swig/python/svn %buildroot%python_sitelibdir
%endif

%if_with swig_pl
%make_install DESTDIR=%buildroot PREFIX=%_prefix libdir=%_libdir/libsvn_swig swig_pl_libdir=%_libdir/libsvn_swig install-swig-pl
rm -f %buildroot%_libdir/libsvn_swig/libsvn_swig_pl*.la
%endif

%if_with swig_rb
%make_install DESTDIR=%buildroot swig_rb_libdir=%_libdir/libsvn_swig install-swig-rb
rm -f %buildroot%ruby_sitearchdir/svn/ext/*.la
rm -f %buildroot%_libdir/libsvn_swig/libsvn_swig_ruby*.la
%endif

%if_with swig_java
%make_install DESTDIR=%buildroot install-swig-java
%endif

# Installing javahl bindings
%if_with javahl
%make_install DESTDIR=%buildroot \
	javahl_javadir=%_javadir javahl_javahdir=%_includedir/svn-javahl \
	install-javahl
%endif

%if_with doc
# Installing subversion-doc files
%make_install DESTDIR=%buildroot install-docs
#%make_install XSL_DIR=/usr/share/xml/docbook/xsl-stylesheets \
#    INSTALL_DIR=%buildroot%docdir/doc/book \
#    -C doc/book install-misc-html
%make_install INSTALL_DIR=%buildroot%docdir/ -C ./doc install-misc-html

mkdir -p %buildroot%docdir/book/
#bzip2 -qc9 doc/book/book/book.ps >%buildroot%docdir/doc/book/book.ps.bz2
# TODO: svn-book.{pdf,html} temporary disabled (Hope, until release)
#install -p -m644 doc/book/svn-book.pdf %buildroot%docdir/book/
#install -p -m644 doc/book/svn-book.html %buildroot%docdir/book/
cp -r doc/user %buildroot%docdir/
cp doc/README %buildroot%docdir/DOCS.README
mkdir -p %buildroot%docdir/programmer/design
install -pm644 doc/programmer/*.txt %buildroot%docdir/programmer/
install -pm644 doc/programmer/design/*.html %buildroot%docdir/programmer/design/
#cp -r doc/translations %buildroot%docdir/

install -m644 doc/programmer/design/*.info* %buildroot%_infodir/

# Install API docs
#mkdir %buildroot%docdir/api
cp -r doc/doxygen/html/ %buildroot%docdir/api
%endif

%if_with server
# Installing subversion-server files
mkdir -p %buildroot%svn_repo_dir
mkdir -p %buildroot%_sysconfdir/rc.d/init.d %buildroot%_sysconfdir/sysconfig
install -pm755 %SOURCE3 %buildroot%_sysconfdir/rc.d/init.d/%svn_service
install -pm644 %SOURCE4 %buildroot%_sysconfdir/sysconfig/%svn_service

%if_with dav
install -d -m755 -- %buildroot%apache2_mods_available
install -d -m755 -- %buildroot%apache2_mods_start
install -p -m644 -- %SOURCE9 %buildroot%apache2_mods_available/%module_name.load
install -p -m644 -- %SOURCE5 %buildroot%apache2_mods_available/%module_name.conf
sed -i 's,@a_libexecdir@,%apache2_libexecdir,g' %buildroot%apache2_mods_available/%module_name.load
install -pm644 -- %SOURCE10 %buildroot%apache2_mods_start/100-%module_name.conf

%endif
%endif

# Installing bash-completion file
mkdir -p %buildroot/etc/bash_completion.d
install -pm644 tools/client-side/bash_completion %buildroot/etc/bash_completion.d/svn

%find_lang %name

%pre server-common
/usr/sbin/groupadd -r -f %svn_group
/usr/sbin/useradd -r -g %svn_group -d %svn_repo_dir -s /dev/null -c 'Subversion' %svn_user >/dev/null 2>&1 ||:
if [ $1 -gt 1 ]; then
	/usr/sbin/usermod -d %svn_repo_dir %svn_user
fi

%post server-standalone
%post_service %svn_service

%preun server-standalone
%preun_service %svn_service

%if_with dav
%post server-dav
# Reconfigure Apache2:
%apache2_sbindir/a2chkconfig ||:

if [ -e %apache2_mods_enabled/%module_name.load ]; then
    CONF_OK=0
    %apache2_sbindir/apachectl2 configtest && CONF_OK=1 ||:
    if [ "$CONF_OK" = "1" ]; then
        service %apache2_dname condrestart ||:
    else
        echo "Some errors detected in Apache2 configuration!"
        echo "To use %modname check configuration and start %apache2_dname service."
    echo
    fi
else
    echo "Apache2 %modname module had been installed, but does't enabled."
    echo "Check %apache2_mods_start directory for files with '%module_name=no' lines."
    echo
fi

%preun server-dav
if [ "$1" = "0" ] ; then # last uninstall
    [ -e %apache2_mods_enabled/%module_name.load ] && %apache2_sbindir/a2dismod %module_name 2>&1 >/dev/null ||:
fi


%postun server-dav
# Reconfigure Apache2:
%apache2_sbindir/a2chkconfig ||:
if [ "$1" = "0" ] ; then # last uninstall
    CONF_OK=0
    %apache2_sbindir/apachectl2 configtest && CONF_OK=1 ||:
    if [ "$CONF_OK" = "1" ]; then
	service %apache2_dname condrestart ||:
    else
        echo "Some errors detected in Apache2 configuration!"
	echo "To complete %module_name uninstalling check configuration and restart %apache2_dname service."
	echo
    fi
fi
%endif

%files -f %name.lang
%doc BUGS CHANGES COMMITTERS INSTALL LICENSE NOTICE README
%dir %_sysconfdir/%name
%config(noreplace) %_sysconfdir/%name/config
%config(noreplace) %_sysconfdir/%name/servers
%_sysconfdir/%name/README.txt
%_bindir/svn
%_bindir/svnversion
%_bindir/svnrdump
%_bindir/svnsync
%_bindir/svnmucc
%_man1dir/svn.1.*
%_man1dir/svnversion.1.*
%_man1dir/svnrdump.1*
%_man1dir/svnsync.1.*
%_man1dir/svnmucc.1.*
%_sysconfdir/bash_completion.d/svn

%files -n lib%name
%_libdir/libsvn_*-*.so.*
%dir %_libdir/libsvn_swig
%exclude %_libdir/libsvn_auth*

%files -n lib%name-devel
%_libdir/libsvn_*-*.so
%_includedir/%name-1
%exclude %_libdir/libsvn_swig*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/libsvn_*.a
%endif

%if_with gnome_keyring
%files -n lib%name-auth-gnome-keyring
%_libdir/libsvn_auth_gnome_keyring-1.so.*
%endif

%if_with kwallet
%files -n lib%name-auth-kwallet
%_libdir/libsvn_auth_kwallet-1.so.*
%endif

%if_with swig_py
%files python
%_libdir/libsvn_swig/libsvn_swig_py*.so.*
%python_sitelibdir/svn
%python_sitelibdir/libsvn
%endif

%if_with swig_pl
%files perl
%_libdir/libsvn_swig/libsvn_swig_perl*.so.*
%perl_vendor_archlib/SVN
%perl_vendor_autolib/SVN
%endif

%if_with swig_rb
%files ruby
%_libdir/libsvn_swig/libsvn_swig_ruby*.so.*
%dir %ruby_sitelibdir/svn/
%ruby_sitelibdir/svn/*.rb
%dir %ruby_sitearchdir/svn/
%dir %ruby_sitearchdir/svn/ext/
%ruby_sitearchdir/svn/ext/*.so
%endif

%if_with swig-java
%files java
%endif

%if_with javahl
%files javahl
%_libdir/libsvnjavahl*.so*
%_javadir/svn-javahl.jar
%endif

%if_with doc
%files doc
%_infodir/svn-design*
%docdir/DOCS.README
%docdir/book
%docdir/misc-docs
%docdir/programmer
%docdir/user
%docdir/api
%endif

%if_with server
%files server-common
%_bindir/svnserve*
%_bindir/svnadmin
%_bindir/svnlook
%_bindir/svndumpfilter
%_bindir/svnwrapper
%_mandir/man1/svnadmin.1.*
%_mandir/man1/svnlook.1.*
%_mandir/man1/svndumpfilter.1.*
%_mandir/man5/svnserve.conf.5.*
%_mandir/man8/svnserve.8.*
%defattr(640,%svn_user,%svn_group,2710)
%dir %svn_repo_dir

%files server-standalone
%_sysconfdir/rc.d/init.d/%svn_service
%config(noreplace) %_sysconfdir/sysconfig/%svn_service

%if_with dav
%files server-dav
%apache2_libexecdir/*.so
%config(noreplace) %apache2_mods_available/%module_name.conf
%config            %apache2_mods_available/%module_name.load
%config            %apache2_mods_start/100-%module_name.conf
%endif
%endif

%changelog
