Name: sudo
Version: 1.6.8p12
Release: alt12
Epoch: 1

Summary: Allows command execution as another user
License: BSD-style
Group: System/Base
Url: http://www.courtesan.com/sudo/

# ftp://ftp.courtesan.com/pub/sudo/sudo-%version.tar.gz
Source: sudo-%version.tar

Patch: sudo-%version-%release.patch

PreReq: control
Requires: vitmp
Provides: %_sysconfdir/sudoers.d

# Automatically added by buildreq on Wed Apr 09 2003
BuildRequires: flex libpam-devel perl-podlators

%define _libexecdir %_prefix/libexec/sudo
%define timedir /var/lib/sudo

Summary(ru_RU.UTF-8): Запускает команды в контексте другого пользователя

%description
Sudo is a program designed to allow a sysadmin to give limited root
privileges to users and log root activity.  The basic philosophy is
to give as few privileges as possible but still allow people to get
their work done.

%description -l ru_RU.UTF-8
Sudo - программа, разработанная в помощь системному администратору
делегировать те или иные привилегированные ресурсы пользователям,
с ведением протокола их деятельности.  Основная идея - делегировать
как можно меньше прав, но ровно столько, сколько необходимо для
решения поставленных задач.

%prep
%setup
%patch -p1
bzip2 -9k CHANGES
rm acsite.m4
mv aclocal.m4 acinclude.m4

%build
%autoreconf
export ac_cv_prog_NROFFPROG=nroff
configure_options='
--with-logging=syslog
--with-logfac=authpriv
--enable-shell-sets-home
--enable-log-host
--disable-log-wrap
--disable-saved-ids
--with-pam
--with-ignore-dot
--with-env-editor
--with-tty-tickets
--with-sudoers-mode=0400
--with-editor=/bin/vitmp
--with-sendmail=/usr/sbin/sendmail
--with-timedir=%timedir
--with-secure-path=/sbin:/usr/sbin:/usr/local/sbin:/bin:/usr/bin:/usr/local/bin'

%configure $configure_options --with-passprompt='[sudo] password for %%u:'
rm sudoers.man.in sudo.man.in visudo.man.in
%make_build sudoers.man.in sudo.man.in visudo.man.in

%configure $configure_options --with-passprompt='[sudo] password for %%u:'
rm lex.yy.c sudo.tab.h sudo.tab.c
%make_build

%install
%makeinstall_std sudoers_uid=`id -un` sudoers_gid=`id -gn`
install -pD -m600 sample.pam %buildroot%_sysconfdir/pam.d/sudo
mkdir -p %buildroot%_sysconfdir/sudoers.d
mkdir -p %buildroot%timedir
chmod u+rwx %buildroot%prefix/*bin/*
install -pD -m755 sudo.control %buildroot/etc/control.d/facilities/sudo
install -pD -m755 sudoers.control %buildroot/etc/control.d/facilities/sudoers

# sudoedit
ln -snf sudo %buildroot%_bindir/sudoedit
ln -snf sudo.8 %buildroot%_man8dir/sudoedit.8
rm %buildroot%_libexecdir/*.la

%pre
%pre_control sudo
%pre_control sudoers

%post
%post_control -s wheelonly sudo
%post_control -s strict sudoers

%files
%config /etc/control.d/facilities/sudo*
%attr(400,root,root) %config(noreplace) %_sysconfdir/sudoers
%attr(600,root,root) %config(noreplace) %_sysconfdir/pam.d/sudo
%_bindir/sudoedit
%_libexecdir
%attr(700,root,root) %_bindir/sudo
%attr(755,root,root) %_sbindir/visudo
%attr(700,root,root) %timedir
%attr(700,root,root) %_sysconfdir/sudoers.d
%_mandir/man?/*
%doc BUGS CHANGES.bz2 HISTORY LICENSE PORTING README TODO
%doc TROUBLESHOOTING UPGRADE sample.sudoers rpminst.sudoers

%changelog
