Packager: Igor Vlasenko <viy@altlinux.ru>
BuildRequires: /proc
BuildRequires: jpackage-compat
# Copyright (c) 2000-2010, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%define gcj_support 0

%define bname xsom

Name:           sun-xsom
Version:        20070515
Release:        alt2_3jpp6
Epoch:          0
Summary:        XML Schema Object Model
License:        CDDL
Group:          Development/Java
URL:            https://xsom.dev.java.net/
# cvs -d:pserver:guest@cvs.dev.java.net:/cvs export -r jaxws211-fcs -d sun-xsom jaxb2-sources/xsom
Source0:        sun-xsom.tar.gz
Source1:        http://download.java.net/maven/1/com.sun.xsom/java-sources/xsom-20070515-sources.jar
Source2:        http://download.java.net/maven/1/com.sun.xsom/poms/xsom-20070515.pom
Patch0:         sun-xsom-build.patch
Requires: relaxngDatatype
Requires(post): jpackage-utils >= 0:1.7.5
Requires(postun): jpackage-utils >= 0:1.7.5
BuildRequires: jpackage-utils >= 0:1.7.5
BuildRequires: ant >= 0:1.7
BuildRequires: ant-nodeps
BuildRequires: junit
BuildRequires: isorelax
BuildRequires: javacc
BuildRequires: msv-msv
BuildRequires: msv-xsdlib
#BuildRequires:  objectweb-asm >= 0:3.1
BuildRequires: relaxngDatatype
BuildRequires: relaxngcc
%if %{gcj_support}
BuildRequires: java-gcj-compat-devel
%endif
%if ! %{gcj_support}
BuildArch:      noarch
%endif

%description
XML Schema Object Model (XSOM) is a Java library that 
allows applications to easily parse XML Schema documents 
and inspect information in them. It is expected to be useful
for applications that need to take XML Schema as an input. 
The library is a straight-forward implement of 
"schema components" as defined in the XML Schema spec part 1. 
Refer to this specification of how this object model works. 

%package javadoc
Summary:        Javadoc for %{name}
Group:          Development/Documentation
BuildArch: noarch

%description javadoc
%{summary}.

%prep
%setup -q -n %{name}
%patch0 -p0 -b .sav0
find . -name "*.jar" | xargs -t rm
rm -r src/com
pushd src
%{jar} xf %{SOURCE1}
popd
# the following classes, which are contained in the source jar, will be
# regenerated by ant thru javacc
rm src/com/sun/xml/xsom/impl/scd/ParseException.java
rm src/com/sun/xml/xsom/impl/scd/SCDParser.java
rm src/com/sun/xml/xsom/impl/scd/SCDParserConstants.java
rm src/com/sun/xml/xsom/impl/scd/SCDParserTokenManager.java
rm src/com/sun/xml/xsom/impl/scd/SimpleCharStream.java
rm src/com/sun/xml/xsom/impl/scd/Token.java
rm src/com/sun/xml/xsom/impl/scd/TokenMgrError.java

ln -s $(build-classpath isorelax) lib/
ln -s $(build-classpath relaxngcc) lib/
#ln -s $(build-classpath retroweaver) lib/retroweaver
#ln -s $(build-classpath retroweaver-rt) lib/retroweaver
#ln -s $(build-classpath objectweb-asm/asm) lib/retroweaver
#ln -s $(build-classpath objectweb-asm/asm-commons) lib/retroweaver
#ln -s $(build-classpath objectweb-asm/asm-util) lib/retroweaver
ln -s $(build-classpath javacc) lib/
ln -s $(build-classpath xsdlib) lib/
ln -s $(build-classpath msv-msv) lib/msv.jar
ln -s $(build-classpath relaxngDatatype) lib/
ln -s $(build-classpath junit) lib/

%build
mkdir results
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 jar
cp build/xsom.jar results
ant -Dant.build.javac.source=1.5 -Dant.build.javac.target=1.5 javadoc
mv build/javadoc results

%install

# jars
install -d -m 755 $RPM_BUILD_ROOT%{_javadir}/%{name}
install -m 644 results/%{bname}.jar $RPM_BUILD_ROOT%{_javadir}/%{name}/%{bname}-%{version}.jar

%add_to_maven_depmap com.sun.xsom xsom %{version} JPP/%{name} %{bname}

(cd $RPM_BUILD_ROOT%{_javadir}/%{name}
for jar in *-%{version}*.jar; do ln -sf ${jar} `echo $jar| sed  "s|-%{version}||g"`; done)

# poms
install -d -m 755 $RPM_BUILD_ROOT%{_datadir}/maven2/poms
install -pm 644 %{SOURCE2} \
    $RPM_BUILD_ROOT%{_datadir}/maven2/poms/JPP.%{name}-%{bname}.pom

# javadoc
install -d -m 755 $RPM_BUILD_ROOT%{_javadocdir}/%{name}-%{version}
cp -pr results/javadoc/* $RPM_BUILD_ROOT%{_javadocdir}/%{name}-%{version}
ln -s %{name}-%{version} $RPM_BUILD_ROOT%{_javadocdir}/%{name} # ghost symlink

%if %{gcj_support}
%{_bindir}/aot-compile-rpm
%endif

%files
%doc license.txt
%{_javadir}/%{name}/%{bname}-%{version}.jar
%{_javadir}/%{name}/%{bname}.jar
%{_datadir}/maven2/poms/*
%{_mavendepmapfragdir}/*
%if %{gcj_support}
%dir %{_libdir}/gcj/%{name}
%{_libdir}/gcj/%{name}/%{bname}-%{version}.jar.*
%endif

%files javadoc
%{_javadocdir}/%{name}-%{version}
%{_javadocdir}/%{name}

%changelog
