%define oname superlu
%define over 4.0
%define somver 4
%define sover %somver.2.0
Name: %oname%over
Version: 4.3
Release: alt3
Summary: A set of subroutines to solve a sparse linear system A*X=B
License: BSD-like
Group: Sciences/Mathematics
Url: http://acts.nersc.gov/superlu/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %{oname}_%version.tar.gz
Source1: http://www.netlib.org/clapack/what/testing/matgen/clatm1.c
Source2: http://www.netlib.org/clapack/what/testing/matgen/zlatm1.c
Source3: http://www.netlib.org/clapack/CLAPACK-3.1.1/TESTING/MATGEN/blaswrap.h

Provides: %oname = %version-%release
Requires: lib%name = %version-%release

BuildPreReq: gcc-fortran gcc-c++ liblapack-devel
BuildPreReq: csh doxygen graphviz ghostscript-utils
#BuildPreReq: texlive-latex-recommended texlive-extra-utils

%description
SuperLU contains a set of subroutines to solve a sparse linear system
A*X=B. It uses Gaussian elimination with partial pivoting (GEPP).
The columns of A may be preordered before factorization; the
preordering for sparsity is completely separate from the factorization.
SuperLU provides functionality for both real and complex matrices, in both
single and double precision.

%package -n lib%name
Summary: Shared libraries of SuperLU
Group: System/Libraries
Provides: lib%oname = %version-%release

%description -n lib%name
SuperLU contains a set of subroutines to solve a sparse linear system
A*X=B. It uses Gaussian elimination with partial pivoting (GEPP).
The columns of A may be preordered before factorization; the
preordering for sparsity is completely separate from the factorization.
SuperLU provides functionality for both real and complex matrices, in both
single and double precision.

This package contains shared libraries of SuperLU.

%package -n lib%oname-devel
Summary: Development files of SuperLU
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%oname-devel
SuperLU contains a set of subroutines to solve a sparse linear system
A*X=B. It uses Gaussian elimination with partial pivoting (GEPP).
The columns of A may be preordered before factorization; the
preordering for sparsity is completely separate from the factorization.
SuperLU provides functionality for both real and complex matrices, in both
single and double precision.

This package contains development files of SuperLU.

%package -n lib%oname-devel-doc
Summary: Documentation for SuperLU
Group: Development/Documentation
BuildArch: noarch

%description -n lib%oname-devel-doc
SuperLU contains a set of subroutines to solve a sparse linear system
A*X=B. It uses Gaussian elimination with partial pivoting (GEPP).
The columns of A may be preordered before factorization; the
preordering for sparsity is completely separate from the factorization.
SuperLU provides functionality for both real and complex matrices, in both
single and double precision.

This package contains documentation for SuperLU.

%prep
%setup
install -m644 %SOURCE1 %SOURCE2 %SOURCE3 TESTING/MATGEN
mkdir lib

%build
sed -i "s|(HOME)|$PWD|" make.inc
sed -i "s|(LIBDIR)|%_libdir|" make.inc
%make install
%make lib
%make testing

pushd EXAMPLE
%make_build
popd

#pushd DOC/latex
#make_build
#popd

pushd TESTING
%make_build
popd

%install
install -d %buildroot%_bindir
install -d %buildroot%_datadir/%name/examples
install -d %buildroot%_libdir
install -d %buildroot%_includedir
install -d %buildroot%_docdir/%name/html
install -d %buildroot%_docdir/%name/pdf
install -m644 SRC/*.h %buildroot%_includedir
install -m644 lib/*.a TESTING/MATGEN/libtmglib.a %buildroot%_libdir
install -m644 DOC/*.pdf %buildroot%_docdir/%name/pdf
install -m644 DOC/html/* %buildroot%_docdir/%name/html

install -m755 TESTING/?test TESTING/?test.csh %buildroot%_bindir
pushd EXAMPLE
rm -f *.o Makefile
chmod -x cg20.cua
mv README cg20.cua *.c %buildroot%_datadir/%name/examples/
install -m755 * %buildroot%_bindir
popd

pushd %buildroot%_bindir
for i in $(ls); do
	mv $i %name.$i
done
popd

# shared libraries

pushd %buildroot%_libdir
for i in libsuperlu_%over libtmglib; do
	if [ "$i" = "libtmglib" ]; then
		ADDLIB="-L. -lsuperlu_%over"
	fi
	ar x $i.a
%ifarch %arm
	g++ -shared *.o $ADDLIB -llapack -lblas -lgfortran -lm \
%else
	g++ -shared *.o $ADDLIB -llapack -lopenblas -lgfortran -lm \
%endif
		-Wl,-soname,$i.so.%somver -o $i.so.%sover
	ln -s $i.so.%sover $i.so.%somver
	ln -s $i.so.%somver $i.so
	rm -f *.o
done
popd

%files
%doc README
%_bindir/*
%_datadir/%name

%files -n lib%name
%_libdir/*.so.*

%files -n lib%oname-devel
%_libdir/*.so
%_includedir/*

%files -n lib%oname-devel-doc
%_docdir/%name

%changelog
