Name: supertux2
Version: 0.3.4
Release: alt6

Summary: Classic 2D jump'n run sidescroller game in a Super Mario style
License: GPLv3
Group: Games/Arcade
URL: http://supertux.lethargik.org/

Packager: Igor Zubkov <icesik@altlinux.org>

Source0: supertux-%version.tar.bz2

Source1: supertux-16x16.png
Source2: supertux-32x32.png
Source3: supertux-48x48.png

Patch0: supertux-alt-desktop-file.patch

Conflicts: supertux

Requires: %name-data = %version-%release

# Automatically added by buildreq on Mon Oct 01 2012 (-bi)
# WTF? vorbis-tools? really?
BuildRequires: boost-devel-headers cmake gcc-c++ libSDL_image-devel libSM-devel libXau-devel libXdmcp-devel libXft-devel libcurl-devel libglew-devel libopenal-devel libphysfs-devel libvorbis-devel

%description
SuperTux is a jump'n run like game, with strong inspiration from the
Super Mario Bros games for Nintendo.

Run and jump through multiple worlds, fighting off enemies by jumping
on them or bumping them from below.  Grabbing power-ups and other stuff
on the way.

Note! This is a still development version.

%package data
Summary: Data files for supertux2
Group: Games/Arcade
Requires: %name = %version-%release
BuildArch: noarch

%description data
SuperTux is a jump'n run like game, with strong inspiration from the
Super Mario Bros games for Nintendo.

Run and jump through multiple worlds, fighting off enemies by jumping
on them or bumping them from below. Grabbing power-ups and other stuff
on the way.

This is package contains data files for supertux2.

%prep
%setup -q -n supertux-%version
%patch0

%build
cmake \
        -D CMAKE_INSTALL_PREFIX=%_prefix \
%if %_lib == lib64
        -D LIB_SUFFIX=64 \
%endif
        -D CMAKE_CXX_FLAGS:STRING="%optflags" \
        -D INSTALL_SUBDIR_BIN=bin \
        -D INSTALL_SUBDIR_SHARE=share/supertux2 \
        -D CMAKE_BUILD_TYPE="Release" \
        -D CMAKE_SKIP_RPATH=YES .

%make_build

%install
%makeinstall_std
%find_lang %name

install -m644 %SOURCE1 -D %buildroot/%_miconsdir/supertux.png
install -m644 %SOURCE2 -D %buildroot/%_niconsdir/supertux.png
install -m644 %SOURCE3 -D %buildroot/%_liconsdir/supertux.png

# install game man file
install -D -m 644 man/man6/%name.6 %buildroot/%_man6dir/%name.6

rm -rf %buildroot/%_docdir/supertux2/

%files -f %name.lang
%doc README WHATSNEW.txt docs
%_bindir/supertux2
%_desktopdir/supertux2.desktop
%_miconsdir/*.png
%_niconsdir/*.png
%_liconsdir/*.png
%_pixmapsdir/supertux.*
%_man6dir/*

%files data
%dir %_datadir/supertux2
%_datadir/supertux2/*
%exclude %_datadir/supertux2/sounds/normalize.sh

%changelog
