# vim:set ft=spec:
Name: swig
Epoch: 1
Version: 3.0.5
Release: alt1

Summary: Simplified Wrapper and Interface Generator (SWIG)
License: Open Source
Group: Development/C
Url: http://www.swig.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: http://download.sourceforge.net/swig/%name-%version.tar.gz
Patch1: %name-1.3.21-alt-configure.patch
#Patch2: %name-1.3.22-runtime.patch
Patch3: %name-1.3.22-no_ansi.patch
Patch4: %name-1.3.25-runtime.patch
#Patch5: %name-1.3.39-swig-user-ruby-1.9-fixes.patch
Patch6: %name-1.3.39-alt-ruby-includes.patch

BuildRequires(pre): rpm-build-python3
BuildPreReq: python-devel yodl chicken libracket-devel
BuildPreReq: racket R-devel libpcre-devel boost-devel
BuildPreReq: python3-devel python-tools-2to3 zlib-devel
# Automatically added by buildreq on Thu Sep 04 2008
BuildRequires: findlib gcc-c++ guile18-devel imake java-devel
BuildRequires: libXt-devel liblua5-devel libruby-devel lua5 mono-mcs
BuildRequires: perl-devel php5-devel python-devel ruby ruby-module-etc
BuildRequires: tcl-devel xorg-cf-files tidy htmldoc perl-devel

Provides: %name-devel = %version
Obsoletes: %name-deve
Obsoletes: %name-runtime-guile  %name-runtime-php  %name-runtime-python  %name-runtime-perl  %name-runtime-ruby  %name-runtime-tcl

%package doc
BuildArch: noarch
Summary: SWIG documentation
Group: Books/Other
Requires: %name = %version-%release

%package runtime-guile
Group: System/Libraries
Summary: SWIG runtime guile library

%package runtime-php
Group: System/Libraries
Summary: SWIG runtime php library

%package runtime-perl
Group: System/Libraries
Summary: SWIG runtime perl library
Requires: %name = %EVR

%package runtime-python
Group: System/Libraries
Summary: SWIG runtime python library

%package runtime-ruby
Group: System/Libraries
Summary: SWIG runtime ruby library

%package runtime-tcl
Group: System/Libraries
Summary: SWIG runtime tcl library

%description
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

%description doc
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG documentation.

%description runtime-guile
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime guile library.

%description runtime-php
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime php library.

%description runtime-perl
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime perl library.

%description runtime-python
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime python library.

%description runtime-ruby
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime ruby library.

%description runtime-tcl
SWIG takes an interface description file written in a combination of C/C++
and special directives and produces interfaces to Perl, Python, and Tcl.
It allows scripting languages to use C/C++ code with minimal effort.

This package contains SWIG runtime tcl library.

%prep
%setup
#patch1 -p1
#patch4 -p1
#patch5 -p2
#patch6 -p2

%build
./autogen.sh
subst 's/PYLIBDIR="lib"/PYLIBDIR="%_lib"/' configure
subst 's/PY3LIBDIR="lib"/PY3LIBDIR="%_lib"/' configure
%configure \
	--with-python=python \
	--with-python3=python3 \
	--with-boost \
	--with-pyinc=%_includedir/python%_python_version \
	--with-pylib=%_libdir/python%_python_version \
	--with-tclconfig=%_libdir \
	--with-perl5
	#--with-tcl --with-python --with-perl5 --with-java --with-guile --with-ruby --with-php4

#%__subst -p 's,/usr/local/include/Py,%_includedir/python%__python_version,g' Runtime/Makefile
# SMP incompatible
# no `all' target
%make_build
%make docs
#%make runtime
#pushd Runtime
#%make
#popd
bzip2 -9fk CHANGES TODO

%install
%makeinstall_std \
	M4_INSTALL_DIR=%buildroot%_datadir/aclocal
mkdir -p %buildroot%_includedir
cp -aL Source/Swig/*.h Source/DOH/*.h Source/Include/*.h \
	%buildroot%_includedir/
# symlinks
#__rm -fv Examples/perl Examples/test-suite/perl Examples/GIFPlot/Php4

%define docdir %_docdir/%name-%version
rm -rf %buildroot%docdir
mkdir -p %buildroot%docdir
install -p -m644 ANNOUNCE CHANGES* COPYRIGHT LICENSE* README RELEASENOTES TODO* \
	%buildroot%docdir/
cp -a Examples Doc %buildroot%docdir/

#pushd Runtime
#%make_install install DESTDIR=%buildroot
#popd

%files
%_bindir/*
#%_datadir/aclocal/%name.m4
%_includedir/*
%_datadir/%{name}
%dir %docdir
%docdir/[A-Z][A-Z]*

%files doc
%dir %docdir
%docdir/[A-Z][a-z]*
%_man1dir/*

#%files runtime-guile
#%_libdir/libswigguile*.so*
#%doc CHANGES.current LICENSE

#%files runtime-php
#%_libdir/libswigphp*.so*
#%doc CHANGES.current LICENSE

#files runtime-perl
#_libdir/libswigpl*.so*
#doc CHANGES.current LICENSE

#%files runtime-python
#%_libdir/libswigpy*.so*
#%doc CHANGES.current LICENSE

#%files runtime-ruby
#%_libdir/libswigrb*.so*
#%doc CHANGES.current LICENSE

#%files runtime-tcl
#%_libdir/libswigtcl*.so*
#%doc CHANGES.current LICENSE

%changelog
