%define major 1.7
Name: sword
Version: %major.4
Release: alt0.M70P.1

Summary: The SWORD Project framework for manipulating Bible texts
Summary(ru_RU.UTF-8): Проект SWORD - оболочка для работы с текстами Библии

License: GPL
Url: http://www.crosswire.org/sword
Group: Databases

Packager: Vitaly Lipatov <lav@altlinux.ru>

#Source0: http://www.crosswire.org/download/ftpmirror.tmp/pub/sword/source/v1.5/%name-%version.tar.bz2
Source: http://www.crosswire.org/ftpmirror/pub/sword/source/v%major/%name-%version.tar
Source1: ftp://ftp.zedz.net/pub/crypto/libraries/sapphire/sapphire.zip
Source2: sword_icons.tar
Patch: %name-gcc44.patch
Patch1: %name-curl-7.21.7.patch

Requires: lib%name = %version

# Automatically added by buildreq on Fri Mar 30 2007
BuildRequires: bc cppunit-devel gcc-c++ glibc-devel libclucene-devel libcurl-devel libicu-devel unzip

%description
The SWORD Project is an effort to create an ever expanding software package
for research and study of God and His Word.  The SWORD Framework
allows easy manipulation of Bible texts, commentaries, lexicons, dictionaries,
etc.  Many frontends are build using this framework.  An installed module
set may be shared between any frontend using the framework.

%package -n lib%name
Summary: Main library for sword
Group: System/Libraries

%description -n lib%name
This package contains the library needed to run programs dynamically
linked with sword.

%package -n lib%name-devel
Summary: Include files for developing sword applications
Group: Development/C
Requires: lib%name = %version
Requires: libcurl-devel >= 7.10.5
Requires: zlib-devel

%description -n lib%name-devel
This package contains the headers that programmers
will need to develop applications which will use the SWORD Bible Framework.

%prep
%setup
#patch -p0
#patch1 -p2

unzip -d sapphire %SOURCE1
cp sapphire/SAPPHIRE.H include/sapphire.h
cp sapphire/SAPPHIRE.CPP src/modules/common/sapphire.cpp

%build
%add_optflags -fpermissive
%configure --with-lucene --with-icu --with-curl --disable-static
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%makeinstall_std

pushd utilities
install -m755 mkfastmod mod2vpl vpl2mod %buildroot/%_bindir
popd

%files
%_bindir/*
%_sysconfdir/sword.conf
%_datadir/%name/
%doc README AUTHORS NEWS INSTALL ChangeLog
%doc samples doc/*.*

%files -n lib%name
%_libdir/lib%name-%version.so
#_libdir/%name/

%files -n lib%name-devel
%_includedir/%name/
%_libdir/lib%name.so
%_pkgconfigdir/*.pc

%changelog
