Name: sysstat
Version: 10.0.4
Release: alt1

Summary: The sar and iostat system monitoring commands
License: GPLv2+
Group: System/Base

URL: http://sebastien.godard.pagesperso-orange.fr/
Source: http://pagesperso-orange.fr/sebastien.godard/sysstat-%version.tar.bz2
Source1: sysstat.init
Patch1: sysstat-10.0.0-cpu.patch

# Automatically added by buildreq on Wed Aug 04 2010
BuildRequires: libsensors3-devel

%description
This package provides the sar and iostat commands for the Linux operating
system, similar to their traditional UNIX counterparts. They enable system
monitoring of disk, network, and other IO activity.

%package isag
Summary: Interactive System Activity Graph
License: GPLv2+
Group: System/Base
Requires: gnuplot, sysstat = %version

BuildArch: noarch

%description isag
isag is a command that enables you to plot data stored in a daily data file
by a previous sar run.

%prep
%setup
%patch1 -p1

%build
export CFLAGS="%optflags"
export sa_lib_dir=%_libdir/sa
# we build script for daily summary that takes yesterday's data and will
# run it by cron after midnight
./configure --prefix=/usr \
	--enable-yesterday \
	--enable-sensors \
	--mandir=%_mandir \
	--disable-compress-manpg \
	--enable-install-isag

%make_build SA_LIB_DIR="%_libdir/sa" LFLAGS="-lsensors"

%install
%makeinstall_std IGNORE_MAN_GROUP=y

install -p -m644 -D sysstat.ioconf %buildroot%_sysconfdir/sysconfig/
install -p -m644 -D sysstat.sysconfig %buildroot/etc/sysconfig/sysstat

install -d %buildroot%_sysconfdir/cron.d/
# Create cronjob file inline. We can easily use here rpm macros for libdir and
# thus allows for multiarch build.
cat > %buildroot%_sysconfdir/cron.d/%name <<EOF
# run system activity accounting tool every 10 minutes
*/10 * * * * root %_libdir/sa/sa1 -S DISK 1 1
# generate a daily summary of process accounting
0 2 * * * root %_libdir/sa/sa2 -A
EOF

install -pD -m755 %_sourcedir/sysstat.init %buildroot%_initrddir/sysstat
subst 's@LIBDIR@%_libdir@' %buildroot%_initrddir/sysstat

# sysstat makefiles install the docs, blow them away
rm -rf %buildroot/usr/doc

%find_lang %name

%preun -p "%preun_service sysstat"
%post -p "%post_service sysstat"

%files -f %name.lang
%config(noreplace) %attr(644,root,root) %_sysconfdir/cron.d/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%config %_sysconfdir/sysconfig/sysstat.ioconf
%_bindir/*
%exclude %_bindir/isag
%_libdir/sa
%_initrddir/*
%_man1dir/*
%exclude %_man1dir/isag.*
%_man5dir/*
%_man8dir/*
%attr(750,root,adm) %_logdir/sa
%doc CHANGES CREDITS FAQ

%files isag
%_bindir/isag
%_man1dir/isag.*

%changelog
