%define firmwaredir             /lib/firmware
%define _localstatedir %_var

%def_enable libcryptsetup
%def_enable logind
%def_enable vconsole
%def_enable readahead
%def_enable quotacheck
%def_enable randomseed
%def_disable coredump
%def_disable gcrypt
%def_disable qrencode
%def_enable microhttpd
%def_enable myhostname
%def_enable bootchart
%def_enable polkit
%def_enable efi

Name: systemd
Version: 201
Release: alt1.M70P.5
Summary: A System and Session Manager
Url: http://www.freedesktop.org/wiki/Software/systemd
Group: System/Configuration/Boot and Init
License: LGPLv2.1+

Source:%name-%version.tar
Source2: rc-local.service
Source4: prefdm.service
Source6: altlinux-idetune.service
Source7: altlinux-update_chrooted.service
Source8: altlinux-clock-setup.service
Source14: systemd-bash3
Source15: network.service
Source16: altlinux-kmsg-loglevel.service
Source17: altlinux-save-dmesg.service
Source18: altlinux-save-dmesg
Source19: udevd.init
Source20: udevd-final.init
Source21: 40-ignore-remove.rules
Source22: scsi_id.config
Source23: var-lock.mount
Source24: var-run.mount
Source27: altlinux-first_time.service
Source28: systemd-tmpfiles.filetrigger
Source29: tmpfile-systemd-startup-nologin.conf
Source31: 60-raw.rules
# ALTLinux's default preset policy
Source32: 99-default.preset

# udev rule generator
Source41: rule_generator.functions
Source42: write_net_rules
Source43: 75-persistent-net-generator.rules
Source44: write_cd_rules
Source45: 75-cd-aliases-generator.rules
Source46: udev-bash3

Patch1: %name-snapshot.patch
Patch2: %name-alt-patches.patch
Patch3: systemd-204-disable-tmp-mount.patch
# ALT bug #29280
Patch4: fedora18-network-device-renaming.patch

%define dbus_ver 1.4.6

BuildRequires: glibc-kernheaders
BuildRequires: intltool >= 0.40.0
BuildRequires: gperf
BuildRequires: libcap-devel libcap-utils
BuildRequires: libwrap-devel
BuildRequires: libpam-devel
BuildRequires: libacl-devel
BuildRequires: libattr-devel
BuildRequires: xsltproc
BuildRequires: docbook-style-xsl docbook-dtds
BuildRequires: libdbus-devel >= %dbus_ver
BuildRequires: libselinux-devel
BuildRequires: libaudit-devel
BuildRequires: glib2-devel >= 2.26 libgio-devel
BuildRequires: gobject-introspection-devel
BuildRequires: liblzma-devel
BuildRequires: kmod-devel >= 5
BuildRequires: python-devel python-module-sphinx
BuildRequires: quota
BuildRequires: gtk-doc
BuildRequires: libblkid-devel >= 2.20

%{?_enable_libcryptsetup:BuildRequires: libcryptsetup-devel}
BuildRequires: libgcrypt-devel
%{?_enable_qrencode:BuildRequires: libqrencode-devel}
%{?_enable_microhttpd:BuildRequires: libmicrohttpd-devel}

Requires: dbus >= %dbus_ver
Requires: udev = %version-%release
Requires: libudev1 = %version-%release
Requires: libnss-myhostname = %version-%release
Requires: filesystem >= 2.3.10-alt1
Requires: agetty
Requires: acl

# Requires: selinux-policy >= 3.8.5

Requires: libsystemd-daemon = %version-%release
Requires: libsystemd-login = %version-%release
Requires: libsystemd-journal = %version-%release

# Copy from SysVinit
PreReq: coreutils
Requires: /sbin/sulogin
Requires: sysvinit-utils

Obsoletes: systemd-units < 43-alt1
Provides: systemd-units = %version-%release
Provides: syslogd-daemon

%description
systemd is a system and session manager for Linux, compatible with
SysV and LSB init scripts. systemd provides aggressive parallelization
capabilities, uses socket and D-Bus activation for starting services,
offers on-demand starting of daemons, keeps track of processes using
Linux cgroups, supports snapshotting and restoring of the system
state, maintains mount and automount points and implements an
elaborate transactional dependency-based service control logic. It can
work as a drop-in replacement for sysvinit.

%package -n libsystemd-daemon
Group: System/Libraries
Summary: Systemd Daemon Utility Library

%description -n libsystemd-daemon
The sd-daemon library provides a reference implementation of various
APIs for new-style daemons, as implemented by the systemd init system.


This package contains the development files.

%package -n libsystemd-login
Group: System/Libraries
Summary: Systemd Login Utility Library
Requires: libsystemd-daemon = %version-%release

%description -n libsystemd-login
The libsystemd-login library provides an interface for the
systemd-logind service which is used to track user sessions and seats.

%package -n libsystemd-id128
Group: System/Libraries
Summary: Systemd 128 Bit ID Utility Library
Requires: libsystemd-daemon = %version-%release

%description -n libsystemd-id128
The libsystemd-id128 library provides utility functions for generating 128 bit IDs.

%package -n libsystemd-journal
Group: System/Libraries
Summary: Systemd Journal Utility Library
Requires: libsystemd-daemon = %version-%release

%description -n libsystemd-journal
The libsystemd-journal library provides an interface for the systemd journal service.

%package -n libsystemd-daemon-devel
Group: Development/C
Summary: Development headers for systemd Daemon Utility Library
License: MIT
Requires: libsystemd-daemon = %version-%release

%description -n libsystemd-daemon-devel
The sd-daemon library provides a reference implementation of various
APIs for new-style daemons, as implemented by the systemd init system.

%package -n libsystemd-login-devel
Group: Development/C
Summary: Development headers for systemd Login Utility Library
Requires: libsystemd-login = %version-%release

%description -n libsystemd-login-devel
The libsystemd-login library provides an interface for the
systemd-logind service which is used to track user sessions and seats.

This package contains the development files.

%package -n libsystemd-id128-devel
Group: Development/C
Summary: Development headers for systemd 128 Bit ID Utility Library
Requires: libsystemd-id128 = %version-%release

%description -n libsystemd-id128-devel
The libsystemd-id128 library provides utility functions for generating 128 bit IDs.

This package contains the development files.

%package -n libsystemd-journal-devel
Group: Development/C
Summary: Development headers for systemd Journal Utility Library
Requires: libsystemd-journal = %version-%release
Requires: libsystemd-id128-devel = %version-%release

%description -n libsystemd-journal-devel
The libsystemd-journal library provides an interface for the systemd journal service.

This package contains the development files.

%package -n libnss-myhostname
Group: System/Libraries
Summary: glibc plugin for local system host name resolution
Requires(pre): chrooted >= 0.3.5-alt1 chrooted-resolv sed
Requires(postun): chrooted >= 0.3.5-alt1 sed


%description -n libnss-myhostname
nss-myhostname is a plugin for the GNU Name Service Switch (NSS)
functionality of the GNU C Library (glibc) providing host name
resolution for the locally configured system hostname as returned by
gethostname(2). Various software relies on an always resolvable local
host name. When using dynamic hostnames this is usually achieved by
patching /etc/hosts at the same time as changing the host name. This
however is not ideal since it requires a writable /etc file system and
is fragile because the file might be edited by the administrator at
the same time. nss-myhostname simply returns all locally configure
public IP addresses, or -- if none are configured -- the IPv4 address
127.0.0.2 (wich is on the local loopback) and the IPv6 address ::1
(which is the local host) for whatever system hostname is configured
locally. Patching /etc/hosts is thus no longer necessary.

It is necessary to change "hosts" in /etc/nsswitch.conf to
hosts: files myhostname

%package devel
Group: Development/C
Summary: Development headers for systemd
License: LGPLv2.1+ MIT
BuildArch: noarch

%description devel
Development headers and library files for developing applications for systemd.

%package sysvinit
Group: System/Configuration/Boot and Init
Summary: systemd System V init tools
Requires: %name = %version-%release
# Obsoletes: SysVinit
Provides: SysVinit = 2.88-alt0.1
#Obsoletes:      upstart
Conflicts: upstart
Conflicts: SysVinit
BuildArch: noarch

%description sysvinit
Drop-in replacement for the System V init tools of systemd.

%package analyze
Group: System/Configuration/Boot and Init
Summary: Analyze tool for systemd.
Requires: %name = %version-%release

%description analyze
Analyze tool for systemd.

%package journal-gateway
Group: System/Servers
Summary: Journal Gateway Daemon
Requires: %name = %version-%release

%description journal-gateway
This service provides access to the journal via HTTP and JSON.

%package -n bash-completion-%name
Summary: Bash completion for systemd utils
Group: Shells
BuildArch: noarch
Requires: bash-completion
Requires: systemd = %version-%release

%description -n bash-completion-%name
Bash completion for %name.

%package -n zsh-completion-%name
Summary: Zsh completion for systemd utils
Group: Shells
BuildArch: noarch

%description -n zsh-completion-%name
Zsh completion for %name.

%package -n python-module-%name
Summary: Python Bindings for systemd
License: LGPLv2+
Group: Development/Python
Requires: libsystemd-journal = %version-%release

%description -n python-module-%name
This package contains python binds for systemd APIs

%package -n udev
Group: System/Configuration/Hardware
Summary: udev - an userspace implementation of devfs
License: GPLv2+
PreReq: shadow-utils dmsetup kmod >= 5 util-linux >= 2.20 losetup >= 2.19.1
PreReq: udev-rules = %version-%release
PreReq: udev-hwdb = %version-%release
Requires: libudev1 = %version-%release
Provides: hotplug = 2004_09_23-alt18
Obsoletes: hotplug
Conflicts: systemd < %version-%release
Conflicts: util-linux <= 2.22-alt2
Conflicts: DeviceKit

%description -n udev
Starting with the 2.5 kernel, all physical and virtual devices in a
system are visible to userspace in a hierarchal fashion through
sysfs. /sbin/hotplug provides a notification to userspace when any
device is added or removed from the system. Using these two features,
a userspace implementation of a dynamic /dev is now possible that can
provide a very flexible device naming policy

%package -n udev-extras
Summary: Extra rules and tools for udev
Group: System/Configuration/Hardware
License: GPLv2+
Requires: udev = %version-%release
Requires: libudev1 = %version-%release

%description -n udev-extras
The udev-extras package contains an additional rules and tools
to create and identify devices

%package -n udev-rules
Summary: Rule files for udev
Group: System/Configuration/Hardware
License: GPLv2+
Provides: %_sysconfdir/udev/rules.d /lib/udev/rules.d
Conflicts: udev < %version-%release
BuildArch: noarch

%description -n udev-rules
This package contains the default set of rule files used by udev,
which control names and permission of device files in /dev.  Rule
files which have corresponding symlinks in /lib/udev/initramfs-rules.d
are also used by the make-initrd package when creating initramfs images

%package -n udev-hwdb
Summary: Hardware database for udev
Group: System/Configuration/Hardware
License: GPLv2+
Provides: %_sysconfdir/udev/hwdb.d /lib/udev/hwdb.d
Conflicts: udev < %version-%release
BuildArch: noarch

%description -n udev-hwdb
This package contains internal hardware database for udev.

%package -n udev-rule-generator-cdrom
Summary: CD rule generator for udev
Group: System/Configuration/Hardware
License: GPLv2+
BuildArch: noarch
PreReq: udev-rules = %version-%release
Provides: udev-rule-generator = %version-%release
Obsoletes: udev-rule-generator < %version-%release

%description -n udev-rule-generator-cdrom
This package contains CD rule generator for udev

%package -n udev-rule-generator-net
Summary: Net rule generator for udev
Group: System/Configuration/Hardware
License: GPLv2+
BuildArch: noarch
PreReq: udev-rules = %version-%release

%description -n udev-rule-generator-net
This package contains Net rule generator for udev

%package -n bash-completion-udev
Summary: Bash completion for udev utils
Group: Shells
BuildArch: noarch
Requires: bash-completion
Requires: udev = %version-%release

%description -n bash-completion-udev
Bash completion for udev.

%package -n libudev1
Summary: Shared library to access udev device information
Group: System/Libraries
License: LGPLv2.1+
Conflicts: libudev < 181-alt5
Requires: libsystemd-daemon = %version-%release

%description -n libudev1
This package provides shared library to access udev device information

%package -n libudev-devel
Summary: Libraries and headers for libudev
Group: Development/C
License: LGPLv2.1+
Requires: libudev1 = %version-%release

%description -n libudev-devel
Shared library and headers for libudev

%package -n libgudev
Summary: GObject bindings for libudev
Group: System/Libraries
Requires: libudev1 = %version-%release

%description -n libgudev
This package provides shared library to access udev device information

%package -n libgudev-gir
Summary: GObject introspection data for the GUdev library
Group: System/Libraries
Requires: libgudev = %version-%release

%description -n libgudev-gir
GObject introspection data for the GUdev library

%package -n libgudev-devel
Summary: Libraries and headers for libgudev
Group: Development/C
Requires: libgudev = %version-%release

%description -n libgudev-devel
Shared library and headers for libgudev

%package -n libgudev-gir-devel
Summary: GObject introspection devel data for the GUdev library
Group: System/Libraries
BuildArch: noarch
Requires: libgudev-gir = %version-%release libgudev-devel = %version-%release

%description -n libgudev-gir-devel
GObject introspection devel data for the GUdev library

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

%build
export QUOTAON="/sbin/quotaon"
export QUOTACHECK="/sbin/quotacheck"
export SETCAP="/sbin/setcap"
export KILL="/bin/kill"
export CHKCONFIG="/sbin/chkconfig"

gtkdocize --docdir docs/
intltoolize --force --automake
%autoreconf
%configure  \
	--disable-static \
	--with-rootprefix="" \
	--with-rootlibdir=/%_lib \
	--with-pamlibdir=/%_lib/security \
	--enable-split-usr \
	--with-sysvinit-path=/etc/rc.d/init.d \
	--with-rc-local-script-path-start=/etc/rc.d/rc.local \
	--with-kbd-loadkeys=/bin/loadkeys \
	--with-kbd-setfont=/bin/setfont \
	%{subst_enable libcryptsetup} \
	%{subst_enable logind} \
	%{subst_enable vconsole} \
	%{subst_enable readahead} \
	%{subst_enable quotacheck} \
	%{subst_enable randomseed} \
	%{subst_enable coredump} \
	%{subst_enable gcrypt} \
	%{subst_enable qrencode} \
	%{subst_enable microhttpd} \
	%{subst_enable myhostname} \
	%{subst_enable bootchart} \
	%{subst_enable polkit} \
	%{subst_enable efi} \
	--with-firmware-path="/lib/firmware/updates:/lib/firmware" \
	--enable-introspection

%make_build

%install
%make DESTDIR=%buildroot install

# Make sure these directories are properly owned
mkdir -p %buildroot%_unitdir/basic.target.wants
mkdir -p %buildroot%_unitdir/default.target.wants
mkdir -p %buildroot%_unitdir/dbus.target.wants
mkdir -p %buildroot%_unitdir/syslog.target.wants

install -m644 %SOURCE2 %buildroot%_unitdir/rc-local.service
ln -s rc-local.service %buildroot%_unitdir/local.service
install -m644 %SOURCE4 %buildroot%_unitdir/prefdm.service
ln -s prefdm.service %buildroot%_unitdir/dm.service
ln -s prefdm.service %buildroot%_unitdir/display-manager.service
mkdir -p %buildroot%_unitdir/graphical.target.wants
ln -s ../display-manager.service %buildroot%_unitdir/graphical.target.wants
install -m644 %SOURCE6 %buildroot%_unitdir/altlinux-idetune.service
ln -s ../altlinux-idetune.service %buildroot%_unitdir/sysinit.target.wants
install -m644 %SOURCE7 %buildroot%_unitdir/altlinux-update_chrooted.service
ln -s ../altlinux-update_chrooted.service %buildroot%_unitdir/sysinit.target.wants
install -m644 %SOURCE8 %buildroot%_unitdir/altlinux-clock-setup.service
ln -s ../altlinux-clock-setup.service %buildroot%_unitdir/sysinit.target.wants
ln -s altlinux-clock-setup.service %buildroot%_unitdir/clock.service
install -m644 %SOURCE15 %buildroot%_unitdir/network.service
ln -s ../network.service %buildroot%_unitdir/multi-user.target.wants
install -m644 %SOURCE16 %buildroot%_unitdir/altlinux-kmsg-loglevel.service
ln -s ../altlinux-kmsg-loglevel.service %buildroot%_unitdir/sysinit.target.wants
install -m755 %SOURCE18 %buildroot/lib/systemd/altlinux-save-dmesg
install -m644 %SOURCE17 %buildroot%_unitdir/altlinux-save-dmesg.service
ln -s ../altlinux-save-dmesg.service %buildroot%_unitdir/basic.target.wants
install -m644 %SOURCE27 %buildroot%_unitdir/altlinux-first_time.service
ln -s ../altlinux-first_time.service %buildroot%_unitdir/basic.target.wants

# restore bind-mounts /var/run -> run and /var/lock -> /run/lock
# we don't have those directories symlinked
install -m644 %SOURCE23 %buildroot%_unitdir/var-lock.mount
install -m644 %SOURCE24 %buildroot%_unitdir/var-run.mount
ln -s ../var-lock.mount %buildroot%_unitdir/local-fs.target.wants
ln -s ../var-run.mount %buildroot%_unitdir/local-fs.target.wants

ln -s systemd-random-seed-load.service %buildroot%_unitdir/random.service

find %buildroot \( -name '*.a' -o -name '*.la' \) -exec rm {} \;
mkdir -p %buildroot/sbin
ln -s ../lib/systemd/systemd %buildroot/sbin/init
ln -s ../lib/systemd/systemd %buildroot/bin/systemd
ln -s ../bin/systemctl %buildroot/sbin/reboot
ln -s ../bin/systemctl %buildroot/sbin/halt
ln -s ../bin/systemctl %buildroot/sbin/poweroff
ln -s ../bin/systemctl %buildroot/sbin/shutdown
ln -s ../bin/systemctl %buildroot/sbin/telinit
ln -s ../bin/systemctl %buildroot/sbin/runlevel
rm -rf %buildroot%_docdir/systemd

# add defaults services
ln -s ../remote-fs.target %buildroot%_unitdir/multi-user.target.wants
ln -s ../systemd-quotacheck.service %buildroot%_unitdir/local-fs.target.wants
ln -s ../quotaon.service %buildroot%_unitdir/local-fs.target.wants
mkdir -p %buildroot%_unitdir/getty.target.wants
ln -s ../getty@.service %buildroot%_unitdir/getty.target.wants/getty@tty1.service
ln -s ../getty@.service %buildroot%_unitdir/getty.target.wants/getty@tty2.service
ln -s ../getty@.service %buildroot%_unitdir/getty.target.wants/getty@tty3.service
ln -s ../getty@.service %buildroot%_unitdir/getty.target.wants/getty@tty4.service
ln -s ../getty@.service %buildroot%_unitdir/getty.target.wants/getty@tty5.service
ln -s ../getty@.service %buildroot%_unitdir/getty.target.wants/getty@tty6.service

# move systemd-vconsole-setup.service from sysinit.target.wants to getty.target.wants
rm -f %buildroot%_unitdir/sysinit.target.wants/systemd-vconsole-setup.service
ln -s ../systemd-vconsole-setup.service %buildroot%_unitdir/getty.target.wants/systemd-vconsole-setup.service

# disable legacy services
ln -s /dev/null %buildroot%_unitdir/fbsetfont.service
ln -s /dev/null %buildroot%_unitdir/keytable.service
ln -s /dev/null %buildroot%_unitdir/killall.service
ln -s /dev/null %buildroot%_unitdir/halt.service
ln -s /dev/null %buildroot%_unitdir/single.service
ln -s /dev/null %buildroot%_unitdir/netfs.service

# Use mingetty as default
#%__subst 's,/sbin/agetty,/sbin/mingetty,'  %buildroot%_unitdir/getty@.service

# We create all wants links manually at installation time to make sure
# they are not owned and hence overriden by rpm after the used deleted
# them.
rm -r %buildroot%_sysconfdir/systemd/system/*.target.wants
rm -f %buildroot%_sysconfdir/systemd/system/display-manager.service

# And the default symlink we generate automatically based on inittab
rm -f %buildroot%_sysconfdir/systemd/system/default.target

# create modules.conf as a symlink to /etc/modules
mkdir -p %buildroot%_sysconfdir/modules-load.d
ln -s ../modules %buildroot%_sysconfdir/modules-load.d/modules.conf

# add load rtc module at boot time
mkdir -p %buildroot/lib/modules-load.d

# Make sure the NTP units dir exists
mkdir -p %buildroot/lib/systemd/ntp-units.d
mkdir -p %buildroot%_sysconfdir/systemd/ntp-units.d

# Make sure directories in /var exist
mkdir -p %buildroot%_localstatedir/lib/systemd/coredump
mkdir -p %buildroot%_localstatedir/lib/systemd/catalog
mkdir -p %buildroot%_localstatedir/log/journal
touch %buildroot%_localstatedir/lib/systemd/catalog/database
touch %buildroot%_sysconfdir/udev/hwdb.bin

# Add completion for bash3
mkdir -p %buildroot%_sysconfdir/bash_completion.d
rm -f %buildroot%_sysconfdir/bash_completion.d/*
rm -f %buildroot%_datadir/bash-completion/completions/*
install -m644 %SOURCE14 %buildroot%_sysconfdir/bash_completion.d/systemd
# Add completion for zsh
install -D shell-completion/systemd-zsh-completion.zsh %buildroot%_datadir/zsh/Completion/Unix/_systemd

# Make sure the ghost-ing below works
touch %buildroot%_sysconfdir/systemd/system/runlevel2.target
touch %buildroot%_sysconfdir/systemd/system/runlevel3.target
touch %buildroot%_sysconfdir/systemd/system/runlevel4.target
touch %buildroot%_sysconfdir/systemd/system/runlevel5.target


# Create new-style configuration files so that we can ghost-own them
touch %buildroot%_sysconfdir/hostname
touch %buildroot%_sysconfdir/vconsole.conf
touch %buildroot%_sysconfdir/locale.conf
touch %buildroot%_sysconfdir/os-release
touch %buildroot%_sysconfdir/machine-id
touch %buildroot%_sysconfdir/machine-info

# Install ALTLinux default preset policy
mkdir -p %buildroot/lib/systemd/system-preset
mkdir -p %buildroot%_sysconfdir/systemd/system-preset
mkdir -p %buildroot/lib/systemd/user-preset
mkdir -p %buildroot%_sysconfdir/systemd/user-preset
mkdir -p %buildroot/usr/lib/systemd/user-preset
install -m 0644 %SOURCE32 %buildroot/lib/systemd/system-preset/

# The following services are currently installed by initscripts
#pushd %buildroot%_unitdir/graphical.target.wants && {
#	rm -f display-manager.service
#	rm -f dm.service
#popd
#}

# Set up the pager to make it generally more useful
mkdir -p %buildroot%_sysconfdir/profile.d
cat > %buildroot%_sysconfdir/profile.d/systemd.sh << EOF
export SYSTEMD_PAGER="/usr/bin/less -FR"
EOF
chmod 755 %buildroot%_sysconfdir/profile.d/systemd.sh

# move libnss_myhostname to /lib
mv %buildroot%_libdir/libnss_myhostname.so.2 %buildroot/%_lib/libnss_myhostname.so.2

#######
# UDEV
#######
mkdir -p %buildroot%_initdir
install -p -m755 %SOURCE19 %buildroot%_initdir/udevd
#install -p -m755 %SOURCE20 %buildroot%_initdir/udevd-final

ln -s systemd-udevd.service %buildroot%_unitdir/udevd.service
#ln -s systemd-udev-settle.service %buildroot%_unitdir/udevd-final.service

# compatibility symlinks to udevd binary
ln -s ../systemd/systemd-udevd %buildroot/lib/udev/udevd
ln -s ../lib/systemd/systemd-udevd %buildroot/sbin/udevd

# move udevadm to /sbin
mv %buildroot/bin/udevadm %buildroot/sbin/udevadm
sed -i -e 's|/bin/udevadm|/sbin/udevadm|g' \
	%buildroot/lib/udev/rules.d/71-seat.rules \
	%buildroot%_unitdir/systemd-udev-settle.service \
	%buildroot%_unitdir/systemd-udev-trigger.service \
	%buildroot%_unitdir/initrd-udevadm-cleanup-db.service \
	%buildroot%_unitdir/initrd-switch-root.target

install -p -m644 %SOURCE21 %buildroot/lib/udev/rules.d/40-ignore-remove.rules
install -p -m644 %SOURCE22 %buildroot%_sysconfdir/scsi_id.config

cat >>%buildroot%_sysconfdir/udev/udev.conf <<EOF
# Whether to mount a tmpfs filesystem to \$udev_root
udev_tmpfs="1"

# tmpfs options. Note that size shouldn't be less than several
# megabytes due to insane format of current udev database
# (in /dev/.udevdb)
tmpfs_options="size=5m"
EOF

mkdir -p %buildroot/lib/udev/devices

# Install symlinks for rules which are needed in initramfs
mkdir -p %buildroot/lib/udev/initramfs-rules.d
for f in \
	50-udev-default.rules \
	60-persistent-storage.rules \
	80-drivers.rules
do
	ln -s ../rules.d/"$f" \
		%buildroot/lib/udev/initramfs-rules.d/
done
# firmware dirs
mkdir -p %buildroot%firmwaredir/updates
mkdir -p %buildroot/lib/mkinitrd/udev/%firmwaredir/updates
# Create ghost files
touch %buildroot%_sysconfdir/udev/rules.d/70-persistent-net.rules
touch %buildroot%_sysconfdir/udev/rules.d/70-persistent-cd.rules
touch %buildroot%_sysconfdir/udev/hwdb.bin

# udev rule generator
install -p -m644 %SOURCE41 %buildroot/lib/udev/
install -p -m755 %SOURCE42 %buildroot/lib/udev/
install -p -m644 %SOURCE43 %buildroot/lib/udev/rules.d/
install -p -m755 %SOURCE44 %buildroot/lib/udev/
install -p -m644 %SOURCE45 %buildroot/lib/udev/rules.d/
ln -s /dev/null %buildroot%_sysconfdir/udev/rules.d/80-net-name-slot.rules

# Add completion for bash3
install -m644 %SOURCE46 %buildroot%_sysconfdir/bash_completion.d/udev

echo ".so man8/systemd-udevd.8" > %buildroot%_man8dir/udevd.8

install -p -m644 %SOURCE31 %buildroot%_sysconfdir/udev/rules.d/

install -m644 %SOURCE29 %buildroot/lib/tmpfiles.d/systemd-startup-nologin.conf
# rpm posttrans filetriggers
install -pD -m755 %SOURCE28 %buildroot%_rpmlibdir/systemd-tmpfiles.filetrigger

%pre
%_sbindir/groupadd -r -f systemd-journal ||:

%post
/bin/systemd-machine-id-setup >/dev/null 2>&1 || :
/lib/systemd/systemd-random-seed save >/dev/null 2>&1 || :
/bin/systemctl daemon-reexec >/dev/null 2>&1 || :
/bin/journalctl --update-catalog >/dev/null 2>&1 || :
/usr/bin/setfacl -Rnm g:wheel:rx,d:g:wheel:rx,g:adm:rx,d:g:adm:rx /var/log/journal/ >/dev/null 2>&1 || :

if [ $1 -eq 1 ] ; then
        # Try to read default runlevel from the old inittab if it exists
        runlevel=$(/bin/awk -F ':' '$3 == "initdefault" && $1 !~ "^#" { print $2 }' /etc/inittab 2> /dev/null)
        if [ -z "$runlevel" ] ; then
                target="%_unitdir/graphical.target"
        else
                target="%_unitdir/runlevel$runlevel.target"
        fi

        # And symlink what we found to the new-style default.target
        /bin/ln -sf "$target" %_sysconfdir/systemd/system/default.target 2>&1 || :

        # Enable the services we install by default
        /bin/systemctl enable \
                getty@.service \
                remote-fs.target \
                systemd-readahead-replay.service \
                systemd-readahead-collect.service >/dev/null 2>&1 || :
fi

%postun
if [ $1 -ge 1 ] ; then
	/bin/systemctl daemon-reload > /dev/null 2>&1 || :
	/bin/systemctl try-restart systemd-logind.service >/dev/null 2>&1 || :
fi

%preun
if [ $1 -eq 0 ] ; then
        /bin/systemctl disable \
                getty@.service \
                remote-fs.target \
                systemd-readahead-replay.service \
                systemd-readahead-collect.service >/dev/null 2>&1 || :

        /bin/rm -f /etc/systemd/system/default.target > /dev/null 2>&1 || :
fi

%post -n libnss-myhostname
if [ "$1" = "1" ]; then
    grep -q '^hosts:[[:blank:]].\+myhostname' \
    /etc/nsswitch.conf || \
    sed -i.rpmorig 's/^\(hosts:.\+\)$/\1 myhostname/' /etc/nsswitch.conf >/dev/null 2>&1 || :
fi
update_chrooted all

%postun -n libnss-myhostname
if [ "$1" = "0" ]; then
    grep -q '^hosts:[[:blank:]].\+myhostname' \
        /etc/nsswitch.conf && \
    sed -i 's/ myhostname//' /etc/nsswitch.conf
fi
update_chrooted all

%if_enabled microhttpd
%pre journal-gateway
%_sbindir/groupadd -r -f systemd-journal-gateway ||:
%_sbindir/useradd -g systemd-journal-gateway -c 'Journal Gateway' \
    -d %_localstatedir/log/journal -s /dev/null -r systemd-journal-gateway >/dev/null 2>&1 ||:
%endif

%pre -n udev
%_sbindir/groupadd -r -f video ||:
%_sbindir/groupadd -r -f dialout ||:
%_sbindir/groupadd -r -f tape ||:

%post -n udev
%post_service udevd
/sbin/udevadm hwdb --update >/dev/null 2>&1 || :

%preun -n udev
%preun_service udevd

%files
%dir %_sysconfdir/systemd
%dir %_sysconfdir/systemd/system
%dir %_sysconfdir/systemd/user
%dir %_sysconfdir/systemd/ntp-units.d


%_sysconfdir/profile.d/systemd.sh
/lib/tmpfiles.d/*.conf
%_sysconfdir/modules-load.d/modules.conf
%_sysconfdir/xdg/systemd
/lib/sysctl.d/*.conf

%config(noreplace) %_sysconfdir/dbus-1/system.d/*.conf
%config(noreplace) %_sysconfdir/systemd/*.conf
%ghost %config(noreplace) %_sysconfdir/hostname
%ghost %config(noreplace) %_sysconfdir/vconsole.conf
%ghost %config(noreplace) %_sysconfdir/locale.conf
%ghost %config(noreplace) %_sysconfdir/os-release
%ghost %config(noreplace) %_sysconfdir/machine-id
%ghost %config(noreplace) %_sysconfdir/machine-info

# Make sure we don't remove runlevel targets from F14 alpha installs,
# but make sure we don't create then anew.
%ghost %config(noreplace) %_sysconfdir/systemd/system/runlevel2.target
%ghost %config(noreplace) %_sysconfdir/systemd/system/runlevel3.target
%ghost %config(noreplace) %_sysconfdir/systemd/system/runlevel4.target
%ghost %config(noreplace) %_sysconfdir/systemd/system/runlevel5.target

/bin/*
%dir /lib/systemd
/lib/systemd/*
%dir /usr/lib/systemd
/usr/lib/systemd/*
%_bindir/*
%exclude %_bindir/systemd-analyze
/lib/udev/rules.d/70-uaccess.rules
/lib/udev/rules.d/71-seat.rules
/lib/udev/rules.d/73-seat-late.rules
/lib/udev/rules.d/99-systemd.rules
/%_lib/security/pam_systemd.so
%_rpmlibdir/systemd-tmpfiles.filetrigger
%_man1dir/*
%exclude %_man1dir/init.*
%_man5dir/*
%_man7dir/*
%exclude %_man7dir/udev*
%_man8dir/*
%exclude %_man8dir/systemd-udevd*
%exclude %_man8dir/udevadm.*
%exclude %_man8dir/udevd.*
%exclude %_man8dir/halt.*
%exclude %_man8dir/reboot.*
%exclude %_man8dir/shutdown.*
%exclude %_man8dir/poweroff.*
%exclude %_man8dir/telinit.*
%exclude %_man8dir/runlevel.*
%if_enabled myhostname
%exclude %_man8dir/nss-myhostname.*
%endif
%_datadir/systemd
%_datadir/dbus-1/services/*.service
%_datadir/dbus-1/system-services/*.service
%_datadir/dbus-1/interfaces/*.xml
%if_enabled polkit
%_datadir/polkit-1/actions/*.policy
%endif
%dir %_localstatedir/log/journal
%dir %_localstatedir/lib/systemd
%dir %_localstatedir/lib/systemd/catalog
%ghost %_localstatedir/lib/systemd/catalog/database
%dir %_localstatedir/lib/systemd/coredump
# %%_docdir/systemd
%doc DISTRO_PORTING LICENSE.LGPL2.1 README NEWS TODO
%_localstatedir/log/README
%exclude %_unitdir/*udev*
%exclude %_unitdir/sockets.target.wants/systemd-udevd*.socket
%exclude %_unitdir/sysinit.target.wants/systemd-udev*.service
%exclude /lib/systemd/systemd-udevd
%if_enabled microhttpd
%exclude /lib/systemd/systemd-journal-gatewayd
%exclude %_unitdir/systemd-journal-gatewayd.*
%exclude %_datadir/systemd/gatewayd
%endif

%files -n libsystemd-daemon
/%_lib/libsystemd-daemon.so.*

%files -n libsystemd-login
/%_lib/libsystemd-login.so.*

%files -n libsystemd-id128
/%_lib/libsystemd-id128.so.*

%files -n libsystemd-journal
/%_lib/libsystemd-journal.so.*

%if_enabled myhostname
%files -n libnss-myhostname
/%_lib/libnss_myhostname.so.2
%_man8dir/nss-myhostname.*
%endif

%files devel
%doc LICENSE.LGPL2.1 LICENSE.MIT
%dir %_includedir/systemd
%_includedir/systemd/sd-shutdown.h
%_datadir/pkgconfig/systemd.pc
%_man3dir/*

%files -n libsystemd-daemon-devel
%doc LICENSE.MIT
%_libdir/libsystemd-daemon.so
%_pkgconfigdir/libsystemd-daemon.pc
%_includedir/systemd/sd-daemon.h

%files -n libsystemd-login-devel
%_libdir/libsystemd-login.so
%_pkgconfigdir/libsystemd-login.pc
%_includedir/systemd/sd-login.h

%files -n libsystemd-id128-devel
%_libdir/libsystemd-id128.so
%_pkgconfigdir/libsystemd-id128.pc
%_includedir/systemd/sd-id128.h

%files -n libsystemd-journal-devel
%_libdir/libsystemd-journal.so
%_pkgconfigdir/libsystemd-journal.pc
%_includedir/systemd/sd-journal.h
%_includedir/systemd/sd-messages.h

%files sysvinit
/sbin/init
/sbin/reboot
/sbin/halt
/sbin/poweroff
/sbin/shutdown
/sbin/telinit
/sbin/runlevel
%_man1dir/init.*
%_man8dir/halt.*
%_man8dir/reboot.*
%_man8dir/shutdown.*
%_man8dir/poweroff.*
%_man8dir/telinit.*
%_man8dir/runlevel.*
%_initdir/README

%files analyze
%_bindir/systemd-analyze

%if_enabled microhttpd
%files journal-gateway
/lib/systemd/systemd-journal-gatewayd
%_unitdir/systemd-journal-gatewayd.*
%_datadir/systemd/gatewayd
%endif

%files -n bash-completion-%name
%_sysconfdir/bash_completion.d/systemd
#%_datadir/bash-completion/completions/hostnamectl
#%_datadir/bash-completion/completions/journalctl
#%_datadir/bash-completion/completions/localectl
#%_datadir/bash-completion/completions/loginctl
#%_datadir/bash-completion/completions/systemctl
#%_datadir/bash-completion/completions/systemd-coredumpctl
#%_datadir/bash-completion/completions/timedatectl

%files -n zsh-completion-%name
%_datadir/zsh/Completion/Unix/_systemd

%files -n python-module-%name
%python_sitelibdir/%name

%files -n bash-completion-udev
%_sysconfdir/bash_completion.d/udev
#%_datadir/bash-completion/completions/udevadm

%files -n libudev1
/%_lib/libudev.so.*

%files -n libudev-devel
%_includedir/libudev.h
%_libdir/libudev.so
%_pkgconfigdir/libudev.pc
%_datadir/pkgconfig/udev.pc

%files -n libgudev
%_libdir/libgudev-*.so.*

%files -n libgudev-devel
%_includedir/gudev-1.0
%_libdir/libgudev-*.so
%_pkgconfigdir/gudev-*.pc

%files -n libgudev-gir
%_libdir/girepository-1.0/*.typelib

%files -n libgudev-gir-devel
%_datadir/gir-1.0/*.gir

%files -n udev
%doc README TODO NEWS LICENSE.GPL2
%dir %_sysconfdir/udev
%config(noreplace) %_sysconfdir/udev/*.conf
%ghost %_sysconfdir/udev/hwdb.bin
%config %_sysconfdir/scsi_id.config
%_initdir/udev*
%_unitdir/*udev*
%_unitdir/sockets.target.wants/systemd-udevd*.socket
%_unitdir/sysinit.target.wants/systemd-udev*.service
%dir %firmwaredir
%dir %firmwaredir/updates
%dir /lib/udev
%dir /lib/udev/devices
/lib/udev/udevd
/lib/udev/ata_id
/lib/udev/cdrom_id
/lib/udev/mtd_probe
/lib/udev/scsi_id
/sbin/udevadm
/sbin/udevd
/lib/systemd/systemd-udevd
%_man8dir/udevadm*
%_man8dir/systemd-udevd*
%_man8dir/udevd*
%_man7dir/udev*

%files -n udev-extras
%doc src/udev/keymap/README.keymap.txt
/lib/udev/accelerometer
/lib/udev/keymaps
/lib/udev/findkeyboards
/lib/udev/keymap
/lib/udev/keyboard-force-release.sh
/lib/udev/v4l_id
/lib/udev/collect
/lib/udev/rules.d/61-accelerometer.rules
/lib/udev/rules.d/78-sound-card.rules
/lib/udev/rules.d/95-keyboard-force-release.rules
/lib/udev/rules.d/95-keymap.rules

%files -n udev-rules
%dir %_sysconfdir/udev/rules.d
%config(noreplace) %_sysconfdir/udev/rules.d/*
/lib/udev/initramfs-rules.d
/lib/udev/rules.d
# rule-generator
/lib/udev/rule_generator.functions

%exclude %_sysconfdir/udev/rules.d/70-persistent-*.rules
%exclude %_sysconfdir/udev/rules.d/80-net-name-slot.rules
%exclude /lib/udev/rules.d/75-*-generator.rules
# extras
%exclude /lib/udev/rules.d/61-accelerometer.rules
%exclude /lib/udev/rules.d/78-sound-card.rules
%exclude /lib/udev/rules.d/95-keyboard-force-release.rules
%exclude /lib/udev/rules.d/95-keymap.rules
# systemd
%exclude /lib/udev/rules.d/70-uaccess.rules
%exclude /lib/udev/rules.d/71-seat.rules
%exclude /lib/udev/rules.d/73-seat-late.rules
%exclude /lib/udev/rules.d/99-systemd.rules

%files -n udev-hwdb
%dir %_sysconfdir/udev/hwdb.d
/lib/udev/hwdb.d

%files -n udev-rule-generator-cdrom
%config(noreplace,missingok) %verify(not md5 size mtime) %ghost %_sysconfdir/udev/rules.d/70-persistent-cd.rules
/lib/udev/rules.d/75-cd-aliases-generator.rules
/lib/udev/write_cd_rules

%files -n udev-rule-generator-net
%config(noreplace,missingok) %verify(not md5 size mtime) %ghost %_sysconfdir/udev/rules.d/70-persistent-net.rules
%_sysconfdir/udev/rules.d/80-net-name-slot.rules
/lib/udev/rules.d/75-persistent-net-generator.rules
/lib/udev/write_net_rules

%changelog
