Name: tbb
Version: 41_20130116
Release: alt1
Summary: Threading Building Blocks
License: GPL
Group: Development/Tools
Url: http://threadingbuildingblocks.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar.gz

Requires: lib%name = %version-%release

BuildPreReq: gcc-c++

%description
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

%package -n lib%name
Summary: Shared libraries of Threading Building Blocks
Group: Development/C++

%description -n lib%name
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains shared libraries of Threading Building Blocks.

%package headers
Summary: Headers for Threading Building Blocks
Group: Development/C++
BuildArch: noarch
Conflicts: lib%name-devel < %version-%release

%description headers
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains headers for Threading Building Blocks.

%package -n lib%name-devel
Summary: Development libraries of Threading Building Blocks
Group: Development/C++
Requires: lib%name = %version-%release
Requires: %name-headers = %version-%release
%ifarch x86_64
Provides: libtbb.so()(64bit)
Provides: libtbbmalloc.so()(64bit)
%else
Provides: libtbb.so
Provides: libtbbmalloc.so
%endif

%description -n lib%name-devel
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains development libraries for Threading Building
Blocks.

%package docs
Summary: Documentation for Threading Building Blocks
Group: Development/Documentation
BuildArch: noarch

%description docs
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains development documentation for Threading Building
Blocks.

%package examples
Summary: Examples for Threading Building Blocks
Group: Development/Documentation
Requires: lib%name = %version-%release

%description examples
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains examples for Threading Building Blocks.

%prep
%setup

%build
%make
%make_build rml

%install
install -d %buildroot%_libdir
install -m644 build/linux*release/*.so.* \
	%buildroot%_libdir
pushd %buildroot%_libdir
for i in *.so.*
do
	devlib=$(echo $i|sed 's|\.1||')
	devlib=$(echo $devlib|sed 's|\.2||')
	ln -s $i $devlib
done
popd
install -d %buildroot%_bindir
install -m755 build/linux*release/*.exe \
	%buildroot%_bindir
pushd %buildroot%_bindir
for i in $(ls *.exe|sed 's|\.exe||'); do
	mv $i.exe $i
done
popd

install -d %buildroot%_includedir
cp -fR include/%name %buildroot%_includedir/

install -d %buildroot%_libdir/%name
cp -fR examples %buildroot%_libdir/%name/

for i in $(find ./ -name '*.html'); do
	install -Dm644 $i %buildroot%_docdir/%name/$i
done

install -p -m644 CHANGES COPYING README %buildroot%_docdir/%name

%files
%_bindir/*

%files headers
%_includedir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so

%files docs
%_docdir/%name

%files examples
%_libdir/%name/

%changelog
