Name: tcb
Version: 1.1
Release: alt1

Summary: Libraries and tools implementing the %name password shadowing scheme
License: GPL or BSD
Group: System/Base
Url: http://www.openwall.com/tcb/

Source: ftp://ftp.openwall.com/pub/projects/tcb/%name-%version.tar
Source1: tcb_chkpwd.control

Patch1: tcb-0.9.9-alt-makefile-pam.patch
Patch2: tcb-0.9.9-alt-tcb_convert-try_auth.patch

# due to PAM policy.
BuildRequires(pre): libpam-devel
# due to change in format of PAM modules requirements.
BuildRequires: rpm-build >= 0:4.0.4-alt55
# due to crypt_gensalt.
#BuildPreReq: libcrypt.so.1(GLIBC_2.2.2)

%description
This package consists of three components: pam_tcb, libnss_tcb, and
libtcb.  pam-tcb is a PAM module which supersedes pam_unix.  It also
implements the tcb password shadowing scheme (see tcb(5) for details).
The tcb scheme allows many core system utilities (passwd(1) being the
primary example) to operate with little privilege.  libnss_tcb is the
accompanying NSS module.  libtcb contains code shared by the PAM and
NSS modules and is also used by programs from the shadow-utils package.

%package -n lib%name
Summary: %name shared library
License: GPL or BSD
Group: System/Libraries

%package -n lib%name-devel
Summary: Libraries and header files for building %name-aware applications
License: GPL or BSD
Group: Development/C
PreReq: lib%name = %version-%release

%package -n lib%name-devel-static
Summary: Static libraries for building statically linked %name-aware applications
License: GPL or BSD
Group: Development/C
Requires: lib%name-devel = %version-%release

%package -n nss_%name
Summary: %name NSS module
License: GPL or BSD
Group: System/Libraries
PreReq: lib%name = %version-%release

%set_pam_name pam_%name
%package -n %pam_name
Summary: %name PAM module
License: GPL or BSD
Group: System/Base
PreReq: nss_%name = %version-%release, libpam%_pam_name_suffix, control
Requires: glibc-crypt_blowfish >= 1.2
Provides: pam_%name = %version-%release
Obsoletes: pam_%name

%package utils
Summary: %name utilities
License: GPL
Group: System/Base
Provides: /etc/tcb
PreReq: %pam_name = %version-%release, shadow-convert

%description -n lib%name
This package contains code shared by the PAM and NSS modules and is also used
by programs from the shadow-utils package.

%description -n lib%name-devel
This package contains library and header files needed for
building %name-aware applications.

%description -n lib%name-devel-static
This package contains static library needed for
building statically linked %name-aware applications.

%description -n nss_%name
This package contains nss_%name - %name NSS module.

%description -n %pam_name
This package contains %pam_name - %name PAM module which supersedes pam_unix.

%description utils
This package contains utilities to convert to and from the tcb
password shadowing scheme.

%prep
%setup
%patch1 -p1
%patch2 -p1

# /usr/libexec is hardcoded in the sources.
if [ "%_libexecdir" != '/usr/libexec' ]; then
	find -type f -print0 |
		xargs -r0 grep -FZl /usr/libexec -- |
		xargs -r0 %__subst -p 's,/usr/libexec,%_libexecdir,g' --
fi

%build
CFLAGS='%optflags -W -DENABLE_SETFSUGID -DENABLE_NLS -DNLS_PACKAGE=\"Linux-PAM\"' make

%install
%make_install install-non-root install-pam_unix install-pam_pwdb \
	DESTDIR=%buildroot \
	MANDIR=%_mandir \
	LIBDIR=%_libdir \
	SLIBDIR=/%_lib \
	#
install -pD -m755 %_sourcedir/tcb_chkpwd.control \
	%buildroot%_controldir/tcb_chkpwd
%__subst -p 's,@libexecdir@,%_libexecdir,g' \
	%buildroot%_controldir/tcb_chkpwd
mkdir -p %buildroot/etc/tcb

%pre -n %pam_name
groupadd=/usr/sbin/groupadd
$groupadd -r -f chkpwd >/dev/null 2>&1 ||:
$groupadd -r -f shadow >/dev/null 2>&1 ||:
%pre_control tcb_chkpwd

%post -n %pam_name
%post_control -s tcb tcb_chkpwd

%triggerpostun -n %pam_name -- pam_tcb < 0:0.9.8.3-alt1
/usr/sbin/control tcb_chkpwd tcb

%pre utils
groupadd=/usr/sbin/groupadd
$groupadd -r -f auth >/dev/null 2>&1 ||:

%post utils
if [ $1 = 1 -a ! -e /etc/tcb ]; then
	/sbin/tcb_convert
fi

%files -n lib%name
/%_lib/lib%name.so.*
%doc ChangeLog LICENSE

%files -n lib%name-devel
%_libdir/lib*.so
%_includedir/*

%files -n lib%name-devel-static
%_libdir/*.a

%files -n nss_%name
/%_lib/libnss_*

%files -n %pam_name
/%_lib/security/pam_*.so*
%attr(710,root,chkpwd) %dir %_libexecdir/chkpwd
%attr(700,root,root) %verify(not mode group) %_libexecdir/chkpwd/tcb_chkpwd
%config %_controldir/tcb_chkpwd
%_man8dir/pam_*

%files utils
%attr(710,root,shadow) %ghost /etc/tcb
/sbin/%{name}_*convert
%_man5dir/%name.*
%_man8dir/tcb_*

%changelog
