%define major 3.4

Name: tcl-incrtcl
Version: 3.4.0
Release: alt1.qa1

Summary: [Incr Tcl] is an object-oriented extension of the Tcl language
License: BSD
Group: Development/Tcl
Url: http://incrtcl.sourceforge.net/

Source: %name-%version-%release.tar

BuildRequires: rpm-build-tcl >= 0.4-alt1 tk-devel >= 8.5.0

%package devel
Summary: Header files and C programming manual for [Incr Tcl]
Group: Development/C
Requires: %name = %version-%release

%package -n tcl-incrtk
Summary: [incr Tk] is a framework for building mega-widgets
Group: Development/Tcl

%package -n tcl-incrtk-devel
Summary: Header files and C programming manual for [Incr Tk]
Group: Development/C
Requires: tcl-incrtk = %version-%release %name-devel = %version-%release

%description
[incr Tcl] is an object-oriented extension of the Tcl language.  It
was created to support more structured programming in Tcl and
introduces the notion of objects. This object-oriented paradigm
adds another level of organization on top of the basic variable/procedure
elements, and the resulting code is easier to understand and maintain.

%description -n tcl-incrtk
[incr Tk] is a framework for building mega-widgets.  It uses [incr Tcl]
to  support  the  object  paradigm, and adds base classes which provide
default widget behaviors.

%description devel
[incr Tcl] is an object-oriented extension of the Tcl language.  It
was created to support more structured programming in Tcl and
introduces the notion of objects. This object-oriented paradigm
adds another level of organization on top of the basic variable/procedure
elements, and the resulting code is easier to understand and maintain.

This package includes header files and C programming manual for [incr Tcl].

%description -n tcl-incrtk-devel
[incr Tk] is a framework for building mega-widgets.  It uses [incr Tcl]
to  support  the  object  paradigm, and adds base classes which provide
default widget behaviors.

This package includes header files and C programming manual for [incr Tk].

%prep
%setup
%teapatch -C itcl
%teapatch -C itk
sed -i 's/\$dir \"/\$dir .. .. .. %_lib tcl \"/' itcl/pkgIndex.tcl.in itk/pkgIndex.tcl.in

%build
%configure 
%make_build

%install
%make_install DESTDIR=%buildroot install
ln -sf tcl/libitk%major.so %buildroot%_libdir/libitk.so
ln -sf tcl/libitcl%major.so %buildroot%_libdir/libitcl.so
mv %buildroot%_tcllibdir/lib*stub*.a %buildroot%_libdir/

%files
%doc README
%_tcllibdir/libitcl%major.so
%_tcldatadir/itcl%major
%_mandir/mann/body.n*
%_mandir/mann/class.n*
%_mandir/mann/code.n*
%_mandir/mann/configbody.n*
%_mandir/mann/delete.n*
%_mandir/mann/ensemble.n*
%_mandir/mann/find.n*
%_mandir/mann/is.n*
%_mandir/mann/itcl.n*
%_mandir/mann/itclvars.n*
%_mandir/mann/local.n*
%_mandir/mann/scope.n*

%files devel
%_includedir/itcl*.h
%_libdir/libitcl.so
%_libdir/libitclstub%major.a
%_libdir/itclConfig.sh

%files -n tcl-incrtk
%doc itk/examples itk/demos
%_tcllibdir/libitk%major.so
%_tcldatadir/itk%major
%_mandir/mann/Archetype.n*
%_mandir/mann/itk.n*
%_mandir/mann/itkvars.n*
%_mandir/mann/Toplevel.n*
%_mandir/mann/usual.n*
%_mandir/mann/Widget.n*

%files -n tcl-incrtk-devel
%_includedir/itk*.h
%_libdir/libitk.so
#_libdir/libitkstub%major.a

%changelog
