# -*- rpm-spec -*-
# $Id: tcl-ldap,v 1.20 2006/07/21 21:33:23 me Exp $

%define srcname ldap
%define srcver 30

Name: tcl-%srcname
Version: 3.0
Release: alt9.1.qa1

Summary: LDAP extension to TCL
License: BSD
Group: Development/Tcl
Url: http://www.sensus.org/tcl

Source0: %name-%version.tar.bz2

BuildRequires: libldap-devel rpm-build >= 4.0.4-alt41 rpm-build-tcl >= 0.2-alt1 tcl-devel >= 8.4.0-alt1

%description
This extension provides a generic binding to LDAP, adding a single
command to the Tcl interpreter that dynamically creates session
command objects each time it is called. The resultant command can be
used to exercise the full range of the LDAP protocol, with the notable
exception of extended operations (a LDAP v3 feature).

%prep
%setup -q -n %srcname%srcver
%teapatch -v

%build
%configure
%make_build

%install
%make_install install DESTDIR=%buildroot

%files
%_tcllibdir/lib%srcname%version.so
%_tcldatadir/%srcname%version/pkgIndex.tcl
%doc license.terms ldap.htm

%changelog
