Name: tcp_wrappers
Version: 7.6
Release: alt11
Epoch: 1

Summary: A security tool which acts as a wrapper for network services
License: BSD-style
Group: System/Servers
Url: http://ftp.porcupine.org/pub/security/

%define srcname tcp_wrappers_7.6
# ftp://ftp.porcupine.org/pub/security/%srcname.tar.gz
Source: %srcname.tar
Source1: ftp://ftp.porcupine.org/pub/security/tcp_wrappers_license

# ftp://ftp.porcupine.org/pub/security/tcpd-blacklist-patch
Patch0: %srcname-up-tcpd-blacklist.patch
Patch1: %srcname-owl-alt-makefile.patch
Patch2: %srcname-openbsd-owl-cleanups.patch
Patch3: %srcname-openbsd-owl-ip-options.patch
Patch4: %srcname-owl-safe_finger.patch
Patch5: %srcname-steveg-owl-match.patch
Patch6: %srcname-alt-fix_options.patch
Patch7: %srcname-alt-shared.patch
Patch8: %srcname-alt-hosts_ctl.patch
Patch9: %srcname-alt-drop-percent_m.patch

Patch10: %srcname-deb-man-quoting.patch
Patch11: %srcname-deb-man-typos.patch
Patch12: %srcname-deb-man_portability.patch
Patch13: %srcname-deb-man-fromhost.patch
Patch14: %srcname-deb-man-more-pages.patch
Patch15: %srcname-deb-restore-sigalarm.patch
Patch16: %srcname-deb-siglongjmp.patch

Requires: libwrap = %epoch:%version-%release

%package -n libwrap
Summary: Security wrapper access control shared library
Group: System/Libraries

%package -n libwrap-devel
Summary: Security wrapper access control development library
Group: Development/C
Provides: tcp_wrappers-devel = %version
Obsoletes: tcp_wrappers-devel
Requires: libwrap = %epoch:%version-%release

%package -n libwrap-devel-static
Summary: Security wrapper access control development static library
Group: Development/C
Provides: tcp_wrappers-devel-static = %version
Obsoletes: tcp_wrappers-devel-static
Requires: libwrap-devel = %epoch:%version-%release

%description
With this package you can monitor and filter incoming requests for the
SYSTAT, FINGER, FTP, TELNET, RLOGIN, RSH, EXEC, TFTP, TALK, and other
network services.

%description -n libwrap
Security wrapper access control library which implement a rule-based
access control language with optional shell commands that are executed
when a rule fires.

%description -n libwrap-devel
Security wrapper access control library which implement a rule-based
access control language with optional shell commands that are executed
when a rule fires.

%description -n libwrap-devel-static
Security wrapper access control library which implement a rule-based
access control language with optional shell commands that are executed
when a rule fires.

%prep
%setup -n %srcname
install -p -m644 %SOURCE1 LICENSE
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1

find -type f -name \*.orig -delete
bzip2 -9k README CHANGES

%build
%add_optflags %optflags_shared -D_REENTRANT -Dlint
%make_build linux BUGS=

%install
mkdir -p %buildroot{/%_lib,%_libdir,%_sbindir,%_includedir,%_mandir/man{3,5,8}}

install -pm755 safe_finger tcpd tcpdchk tcpdmatch try-from \
	%buildroot%_sbindir/

cp -a libwrap.{a,so}* %buildroot%_libdir/

# Relocate shared libraries from %_libdir/ to /%_lib/.
for f in %buildroot%_libdir/*.so; do
	t=$(readlink "$f") || continue
	ln -snf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

install -pm644 tcpd.h %buildroot%_includedir/

install -pm644 hosts_access.3 %buildroot%_man3dir/
install -pm644 hosts_access.5 hosts_options.5 %buildroot%_man5dir/
ln -s hosts_access.5 %buildroot%_man5dir/hosts.allow.5
ln -s hosts_access.5 %buildroot%_man5dir/hosts.deny.5
install -p -m644 tcpd.8 tcpdchk.8 tcpdmatch.8 %buildroot%_man8dir/

%files
%_sbindir/*
%_man8dir/*
%doc BLURB CHANGES.* README.* DISCLAIMER Banners.Makefile LICENSE

%files -n libwrap
/%_lib/*.so.*
%_man5dir/*

%files -n libwrap-devel
%_libdir/*.so
%_includedir/*
%_man3dir/*

%files -n libwrap-devel-static
%_libdir/*.a

%changelog
