Name: tcsh
Version: 6.18.01
Release: alt1

Summary: An enhanced version of csh, the C shell
License: BSD
Group: Shells

URL: http://www.tcsh.org/
Source: ftp://ftp.astron.com/pub/tcsh/tcsh-%version.tar.gz

Patch1: tcsh-6.15.00-closem.patch
Patch2: tcsh-6.17.00-alt-tinfo.patch
Patch3: tcsh-6.14.00-unprintable.patch

Patch5: tcsh-6.10.01-config-nodot.patch
Patch6: tcsh-6.17.00-alt-lscolors.patch

Patch8: tcsh-6.14.00-syntax.patch
Patch9: tcsh-6.13.00-memoryuse.patch
Patch10: tcsh-6.14.00-order.patch

Patch14: tcsh-6.17.00-glob-automount.patch

# Don't die on unknown LS_COLORS values
Patch100: tcsh-6.14.00-unknown_lscolors.patch

Patch101: tcsh-6.10.00-glibc_compat.patch

# To be rediffed, not applied for now
Patch300: tcsh-6.14.00-suse-owl-alt-shtmp.patch
Patch301: tcsh-6.10.01-deb-man.patch
Patch302: tcsh-6.10.01-alt-cleanups.patch

Provides: csh = %version

# Automatically added by buildreq on Sun Jan 15 2012
BuildRequires: groff-base libtinfo-devel

%description
Tcsh is an enhanced but completely compatible version of csh, the C shell. Tcsh
is a command language interpreter which can be used both as an interactive login
shell and as a shell script command processor. Tcsh includes a command line
editor, programmable word completion, spelling correction, a history mechanism,
job control and a C language like syntax.

%package doc
Summary: HTML doc files for tcsh
Group: Shells
Requires: tcsh = %version

BuildArch: noarch

%description doc
HTML doc files for tcsh.

%prep
%setup

%patch1 -p1
%patch2 -p1
%patch3 -p1

%patch5 -p1
%patch6 -p1

%patch8 -p1
%patch9 -p1
%patch10 -p1

%patch14 -p1

%patch100 -p1
%patch101 -p1

# To be rediffed:
#%patch300 -p1
#%patch301 -p1
#%patch302 -p1

cat > catalogs << _EOF
de ISO-8859-1 german
el ISO-8859-7 greek
en ISO-8859-1 C
es ISO-8859-1 spanish
et ISO-8859-1 et
fi ISO-8859-1 finnish
fr ISO-8859-1 french
it ISO-8859-1 italian
ja eucJP      ja
pl ISO-8859-2 pl
ru KOI8-R russian
uk KOI8-U ukrainian
_EOF

cat catalogs | while read lang charset language ; do
	if ! grep -q '^$ codeset=' nls/$language/set1 ; then
		echo '$ codeset='$charset	>  nls/$language/set1.codeset
		cat nls/$language/set1		>> nls/$language/set1.codeset
		cat nls/$language/set1.codeset	>  nls/$language/set1
		rm  nls/$language/set1.codeset
	fi
done

nroff -me eight-bit.me >eight-bit.txt

%build
# autoreconf needed for alt-tinfo patch
autoreconf
%configure --bindir=/bin
%make_build all
perl ./tcsh.man2html tcsh.man
%make_build -C nls catalogs

%install
install -pD -m755 tcsh %buildroot/bin/tcsh
install -pD -m644 tcsh.man %buildroot%_man1dir/tcsh.1
ln -s tcsh %buildroot/bin/csh
ln -s tcsh.1 %buildroot%_man1dir/csh.1

cat catalogs | while read lang charset language ; do
	dest=%buildroot%_datadir/locale/$lang/LC_MESSAGES
	if test -f tcsh.$language.cat ; then
		mkdir -p $dest
		install -m644 tcsh.$language.cat $dest/tcsh
		echo "%lang($lang) %_datadir/locale/$lang/LC_MESSAGES/tcsh"
	fi
done > tcsh.lang

%files -f tcsh.lang
/bin/csh
/bin/tcsh
%_man1dir/*
%doc NewThings FAQ Fixes complete.tcsh eight-bit.txt

%files doc
%doc tcsh.html/*

%changelog
