Name: telepathy-gabble
Version: 0.18.1
Release: alt1

Summary: Jabber/XMPP connection manager
License: LGPL
Group: Networking/Instant messaging
Url: http://telepathy.freedesktop.org/

Source: http://telepathy.freedesktop.org/releases/telepathy-gabble/%name-%version.tar.gz

%define telepathy_glib_ver 0.19.9
%define glib_ver 2.32

Requires: ca-certificates

BuildPreReq: libtelepathy-glib-devel >= %telepathy_glib_ver
BuildPreReq: glib2-devel >= %glib_ver
BuildRequires: libdbus-devel libdbus-glib-devel libxml2-devel libnice-devel
BuildRequires: libsoup-devel xsltproc libsqlite3-devel libgnutls-devel libgcrypt-devel gtk-doc
BuildRequires: python-module-twisted-words python-module-xmpp
# for tests
BuildRequires: /proc dbus-tools-gui python-module-dbus python-module-twisted-web python-module-twisted-core-gui

%description
Gabble is a Jabber/XMPP connection manager for the Telepathy framework,
currently supporting single user chats, multi user chats and voice/video
calls. Install this package to use Telepathy instant messaging clients
with Jabber/XMPP servers, including Google Talk.

%prep
%setup -q


%build
# Ahtung, automake-1.13 required
#%autoreconf
%configure \
	--disable-static \
	--with-ca-certificates="%_datadir/ca-certificates/ca-bundle.crt"
%make_build

%install
%make_build DESTDIR=%buildroot install

%check
#jingle-share/test-send-file.py --timeout error
#%%make check

%files
%_bindir/telepathy-gabble-xmpp-console
%_libexecdir/telepathy-gabble
%dir %_libdir/telepathy/gabble-0/
%dir %_libdir/telepathy/gabble-0/lib/
%_libdir/telepathy/gabble-0/lib/libgabble-plugins.so
%_libdir/telepathy/gabble-0/lib/libgabble-plugins-%version.so
%_libdir/telepathy/gabble-0/lib/libwocky-telepathy-gabble-%version.so
%_libdir/telepathy/gabble-0/lib/libwocky.so
%dir %_libdir/telepathy/gabble-0/plugins
%_libdir/telepathy/gabble-0/plugins/libgateways.so
%_libdir/telepathy/gabble-0/plugins/libconsole.so
%_datadir/dbus-1/services/org.freedesktop.Telepathy.ConnectionManager.gabble.service
%_datadir/telepathy/managers/gabble.manager
%_man8dir/*
%dir %_datadir/doc/telepathy-gabble
%doc %_datadir/doc/telepathy-gabble/*.html
%doc AUTHORS NEWS README

%exclude %_libdir/telepathy/gabble-0/*/*.la

%changelog
