%def_disable static
%def_disable gtk_doc
%def_enable introspection
%def_enable vala

Name: telepathy-glib
Version: 0.20.4
Release: alt1

Summary: Telepathy framework - GLib connection manager library
License: LGPL
Group: System/Libraries
Url: http://telepathy.freedesktop.org/wiki/TelepathyGLib

Source: http://telepathy.freedesktop.org/releases/telepathy-glib/%name-%version.tar.gz

%define glib_ver 2.32.0
%define dbus_ver 0.90
%define gir_ver 0.10.3
%define vala_ver 0.16.0

BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: libgio-devel >= %glib_ver
BuildPreReq: libdbus-glib-devel >= %dbus_ver
BuildRequires: gtk-doc  python-module-PyXML
%{?_enable_introspection:BuildPreReq: gobject-introspection-devel >= %gir_ver}
%{?_enable_vala:BuildPreReq: vala >= %vala_ver vala-tools >= %vala_ver}

# for check
BuildRequires: /proc dbus dbus-tools-gui

%description
This package contains telepathy-glib, a GLib-based library for Telepathy
components.

%package -n lib%name
Summary: Telepathy framework - GLib connection manager library
Group: System/Libraries

Obsoletes: %name
Provides: %name = %version-%release

%description -n lib%name
This package contains telepathy-glib, a GLib-based library for Telepathy
components.

%package -n lib%name-devel
Summary: Development libraries and header files for %name
Group: Development/C
Requires: lib%name = %version-%release

Obsoletes: %name-devel
Provides: %name-devel = %version-%release

%description -n lib%name-devel
Development libraries and header files for %name.

%package -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: lib%name < %version

%description -n lib%name-devel-doc
This package contains development documentation for the %name

%package -n lib%name-gir
Summary: GObject introspection data for the %name library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the %name library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the %name library

%package -n lib%name-vala
Summary: Vala language bindings for the %name library
Group: Development/Other
BuildArch: noarch
Requires: lib%name = %version-%release

%description -n lib%name-vala
This package provides Vala language bindings for the %name library

%prep
%setup -q

%build
%configure \
	%{subst_enable static} \
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{subst_enable introspection} \
	%{?_enable_vala:--enable-vala-bindings}

%make_build

%install
%make_install DESTDIR=%buildroot install

%check
%make check

%files -n lib%name
%doc AUTHORS ChangeLog
%_libdir/lib*.so.*

%files -n lib%name-devel
%_libdir/lib*.so
%_pkgconfigdir/*.pc
%dir %_includedir/telepathy-1.0/telepathy-glib
%_includedir/telepathy-1.0/telepathy-glib/*.h
%dir %_includedir/telepathy-1.0/telepathy-glib/_gen
%_includedir/telepathy-1.0/telepathy-glib/_gen/*.h

%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*

%if_enabled vala
%files -n lib%name-vala
%_datadir/vala/vapi/telepathy-glib.deps
%_datadir/vala/vapi/telepathy-glib.vapi
%endif

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*

%files -n lib%name-gir-devel
%_girdir/*
%endif


%changelog
