%define api_ver 5.5
%def_enable gnome_keyring
#monitor device suspending and resuming
%def_enable upower
# NetworkManager support
%def_enable nm

Name: telepathy-mission-control
Version: 5.14.1
Release: alt1

Summary: Telepathy mission control plugin library
License: LGPL v2.1
Group: System/Libraries
Url: http://mission-control.sourceforge.net/

Source:http://telepathy.freedesktop.org/releases/%name/%name-%version.tar.gz

BuildRequires: gtk-doc libgio-devel >= 2.28.0 libdbus-glib-devel libtelepathy-glib-devel >= 0.20.0
%{?_enable_upower:BuildRequires: libupower-devel}
%{?_enable_nm:BuildRequires: NetworkManager-glib-devel}
%{?_enable_gnome_keyring:BuildRequires: libgnome-keyring-devel}

# for check
BuildRequires: python-modules-encodings python-module-twisted-words python-module-twisted-core-gui
BuildRequires: python-module-dbus python-module-zope.interface telepathy-logger /proc dbus-tools-gui

%description
Mission Control, or MC, is a Telepathy component providing a way for
"end-user" applications to abstract some of the details of connection
managers, to provide a simple way to manipulate a bunch of connection
managers at once, and to remove the need to have in each program the
account definitions and credentials.

%package -n lib%name
Summary: Telepathy mission control plugin library
Group: System/Libraries
Obsoletes: %name
Provides: %name = %version-%release

%description -n lib%name
Mission Control, or MC, is a Telepathy component providing a way for
"end-user" applications to abstract some of the details of connection
managers, to provide a simple way to manipulate a bunch of connection
managers at once, and to remove the need to have in each program the
account definitions and credentials.

%package -n lib%name-devel
Summary: Development libraries and header files for %name
Group: Development/C
Requires: lib%name = %version-%release
Obsoletes: %name-devel
Provides: %name-devel = %version-%release

%description -n lib%name-devel
Development libraries and header files for %name.

%prep
%setup -q

%build
%autoreconf
export CFLAGS="$CFLAGS `pkg-config --cflags glib-2.0` `pkg-config --cflags dbus-glib-1`"
%configure \
	%{?_enable_gnome_keyring:--enable-gnome-keyring} \
	--disable-static \
	--disable-schemas-compile

%make_build

%install
%make_install DESTDIR=%buildroot install

%check
#%%make check

%files -n lib%name
%_bindir/*
%_libdir/libmission-control-plugins.so.*
%_libexecdir/mission-control-5
%_datadir/dbus-1/services/*.service
%_datadir/glib-2.0/schemas/im.telepathy.MissionControl.FromEmpathy.gschema.xml
%_man1dir/*
%_man8dir/*
%doc AUTHORS ChangeLog

%files -n lib%name-devel
%_libdir/libmission-control-plugins.so
%_includedir/mission-control-%api_ver/
%_pkgconfigdir/*.pc
%_datadir/gtk-doc/html/*

%changelog
