# -*- rpm-spec -*-
# $Id: tetex,v 1.25 2003/01/26 17:08:54 ab Exp $

Name: tetex
Version: 2.0
Release: alt12

%define pkgname         teTeX
%define texversion    2.0-rc1
%define _compress_method  bzip2
%set_autoconf_version 2.13
%set_automake_version 1.4
%define _perl_lib_path %_datadir/texmf/context/perltk

Summary: The TeX text formatting system
License: Distributable
Group: Publishing
Url: http://www.tug.org/teTeX/
Packager: teTeX Development Team <tetex@packages.altlinux.org>

Source0: ftp://ftp.dante.de/pub/tex-archive/systems/unix/teTeX/1.0/distrib/sources/%pkgname-src-%texversion.tar
Source1: ftp://ftp.dante.de/pub/tex-archive/systems/unix/teTeX/1.0/distrib/sources/%pkgname-texmf-%texversion.tar
Source2: ec-plain.tar
Source4: icons-xdvi.tar
Source5: context-russian.tar
Source10: tetex.cron

# Emacs command settings:
Source101: %pkgname-xdvi.el
Source102: %pkgname-dvips.el
Source103: %pkgname-dvilj.el
 
Patch1: %pkgname-fmtutil-alt.patch
Patch2: %pkgname-klibtool-ldconfig-alt.patch
Patch3: %pkgname-tfmgen-alt.patch
Patch4: %pkgname-xdvik-large-fontmap-alt.patch
Patch5: %pkgname-texmf.in-alt.patch
Patch6: %pkgname-perltk-alt.patch
Patch7: %pkgname-2.0-updmap-cnfdir-alt.patch
Patch8: %pkgname-texk-alt.patch

Patch11: %pkgname-1.0-ipl_i18n.patch
Patch12: %pkgname-texmf-cyrtex-t2a-alt.patch
Patch13: %pkgname-texmf-defaults-alt.patch
Patch14: %pkgname-2.0-gentoo-dvi-draw.patch
Patch15: %pkgname-2.0-alt-deps.patch

# Security fixes
Patch20: %pkgname-CVE-2004-0888.patch
Patch21: %pkgname-CVE-2004-1125.patch
Patch22: %pkgname-CVE-2005-0064.patch
Patch23: %pkgname-CVE-2005-3191_3192.patch

Patch24: tetex-2.0-alt-libpng15.patch

Obsoletes: tetex-texmf-src
PreReq: tetex-core = %PACKAGE_VERSION-%release, cm-super-fonts-tex

%package core
Summary: The core of TeX text formatting system
License: Distributable
Group: Publishing
Url: http://www.tug.org/teTeX/

%define lib_suffix %nil
%{expand:%%define lib_suffix %(test %_lib != lib64 && echo %%nil || echo '()(64bit)')}
#Provides: libkpathsea.so%lib_suffix
Provides: tetex-fonts-source

PreReq: coreutils
Requires: texinfo >= 0:4.13-alt1
Requires: dialog
Requires: tex-common >= 0.2
Requires: tetex-latex = %version-%release

Obsoletes: dvipdfm, tetex-fonts-source

BuildRequires(pre): rpm-build-texmf
BuildRequires: flex-old gcc-c++ imake libXaw-devel libexpat-devel libpng-devel
BuildRequires: libssl-devel perl-Tk t1lib-devel w3c-libwww-devel xorg-cf-files

%add_texmf_req_skip latex/amsjpa
%add_texmf_req_skip latex/vtexhtml
%add_texmf_req_skip latex/iilcr

%description
teTeX is an implementation of TeX for Linux or UNIX systems.  TeX takes
a text file and a set of formatting commands as input and creates a
typesetter independent .dvi (DeVice Independent) file as output.  Usually,
TeX is used in conjunction with a higher level formatting package like
LaTeX or PlainTeX, since TeX by itself is not very user-friendly.

Install teTeX if you want to use the TeX text formatting system.  If you
are installing teTeX, you would probably also need to install tetex-afm (a
PostScript(TM) font converter for TeX), tetex-dvilj (for converting .dvi
files to HP PCL format for printing on HP and HP compatible printers),
tetex-dvips (for converting .dvi files to PostScript format for printing
on PostScript printers), tetex-latex (a higher level formatting package
which provides an easier-to-use interface for TeX) and tetex-xdvi (for
previewing .dvi files in X).  Unless you're an expert at using TeX,
you'll also want to install the tetex-doc package, which includes the
documentation for TeX.

%description core
teTeX is an implementation of TeX for Linux or UNIX systems.  TeX takes
a text file and a set of formatting commands as input and creates a
typesetter independent .dvi (DeVice Independent) file as output.  Usually,
TeX is used in conjunction with a higher level formatting package like
LaTeX or PlainTeX, since TeX by itself is not very user-friendly.

%package latex
Summary: The LaTeX front end for the TeX text formatting system
Group: Publishing
PreReq: tetex-core = %PACKAGE_VERSION-%release

%description latex
LaTeX is a front end for the TeX text formatting system.  Easier to
use than TeX, LaTeX is essentially a set of TeX macros which provide
convenient, predefined document formats for users.

If you are installing teTeX, so that you can use the TeX text formatting
system, you will also need to install tetex-latex.  In addition, you will
need to install tetex-afm (for converting PostScript font description
files), tetex-dvilj (for converting .dvi files to HP PCL format for
printing on HP and HP compatible printers), tetex-dvips (for converting
.dvi files to PostScript format for printing on PostScript printers) and
tetex-xdvi (for previewing .dvi files in X).  If you're not an expert
at TeX, you'll probably also want to install the tetex-doc package,
which contains documentation for TeX.

%package xdvi
Summary: An X viewer for DVI files
Group: Publishing
PreReq: tetex-core = %PACKAGE_VERSION-%release

%description xdvi
Xdvi allows you to preview the TeX text formatting system's output .dvi
files on an X Window System.

If you are installing teTeX, so that you can use the TeX text formatting
system, you will also need to install tetex-xdvi.  In addition, you
will need to install tetex-afm (a PostScript font converter for TeX),
tetex-dvilj (for converting .dvi files to HP PCL format for printing on
HP and HP compatible printers), tetex-dvips (for converting .dvi files to
PostScript format for printing on PostScript printers), and tetex-latex
(a higher level formatting package which provides an easier-to-use
interface for TeX).  If you're not a TeX expert, you'll probably also
want to install the tetex-doc package, which contains documentation for
the TeX text formatting system.

%package dvips
Summary: A DVI to PostScript converter for the TeX text formatting system
Group: Publishing
PreReq: tetex-core = %PACKAGE_VERSION-%release

%description dvips
Dvips converts .dvi files produced by the TeX text formatting system
(or by another processor like GFtoDVI) to PostScript(TM) format.
Normally the PostScript file is sent directly to your printer.

If you are installing teTeX, so that you can use the TeX text formatting
system, you will also need to install tetex-dvips.  In addition, you will
need to install tetex-afm (for converting PostScript font description
files), tetex-dvilj (for converting .dvi files to HP PCL format for
printing on HP and HP compatible printers), tetex-latex (a higher level
formatting package which provides an easier-to-use interface for TeX)
and tetex-xdvi (for previewing .dvi files in X).  If you're installing
TeX and you're not an expert at it, you'll also want to install the
tetex-doc package, which contains documentation for the TeX system.

%package dvilj
Summary: A DVI to HP PCL (Printer Control Language) converter
Group: Publishing
PreReq: tetex-core = %PACKAGE_VERSION-%release

%description dvilj
Dvilj and dvilj's siblings (included in this package) will convert TeX
text formatting system output .dvi files to HP PCL (HP Printer Control
Language) commands.  Using dvilj, you can print TeX files to HP LaserJet+
and fully compatible printers.  With dvilj2p, you can print to HP LaserJet
IIP and fully compatible printers.  And with dvilj4, you can print to
HP LaserJet4 and fully compatible printers.

If you are installing teTeX, so that you can use the TeX text formatting
system, you will also need to install tetex-dvilj.  In addition, you will
need to install tetex-afm (for converting PostScript font description
files), tetex-dvips (for converting .dvi files to PostScript format for
printing on PostScript printers), tetex-latex (a higher level formatting
package which provides an easier-to-use interface for TeX) and tetex-xdvi
(for previewing .dvi files in X).  If you're installing TeX and you're
not a TeX expert, you'll also want to install the tetex-doc package,
which contains documentation for TeX.

%package afm
Summary: A converter for PostScript(TM) font metric files, for use with TeX
Group: Publishing
PreReq: tetex-core = %PACKAGE_VERSION-%release

%description afm
tetex-afm provides afm2tfm, a converter for PostScript font metric files.
PostScript fonts are accompanied by .afm font metric files which describe
the characteristics of each font.  To use PostScript fonts with TeX,
TeX needs .tfm files that contain similar information.  Afm2tfm will
convert .afm files to .tfm files.

If you are installing tetex in order to use the TeX text formatting
system, you will need to install tetex-afm.  You will also need to install
tetex-dvilj (for converting .dvi files to HP PCL format for printing on
HP and HP compatible printers), tetex-dvips (for converting .dvi files
to PostScript format for printing on PostScript printers), tetex-latex
(a higher level formatting package which provides an easier-to-use
interface for TeX) and tetex-xdvi (for previewing .dvi files in X).
Unless you're an expert at using TeX, you'll probably also want to
install the tetex-doc package, which includes documentation for TeX.

%package doc
Summary: The documentation files for the TeX text formatting system
Group: Publishing
AutoReq: no
Requires: tetex-core = %PACKAGE_VERSION-%release

%description doc
This package contains documentation for the TeX text formatting system.

If you want to use TeX and you're not an expert at it, you should
install the tetex-doc package.  You'll also need to install the tetex
package, tetex-afm (a PostScript font converter for TeX), tetex-dvilj
(for converting .dvi files to HP PCL format for printing on HP and HP
compatible printers), tetex-dvips (for converting .dvi files to PostScript
format for printing on PostScript printers), tetex-latex (a higher level
formatting package which provides an easier-to-use interface for TeX)
and tetex-xdvi (for previewing .dvi files).

%package devel
Summary: Development files for KPathsea library
Group: Development/C
Requires: tetex-core = %PACKAGE_VERSION-%release

%description devel
This package contains development files for KPathsea library used in
teTeX to find files in TeX source tree.

%package context
Summary: The ConTeXt frontend for the TeX text formatting system
Group: Publishing
Requires: tetex-core = %PACKAGE_VERSION-%release

%description context
ConTeXt is a front end for the TeX text formatting system.  It is well
suited for creation of complex interactive documents like ebooks or
assesments.  Documents prepared with ConTeXt's aid look good both in
PDF format and when printed on paper.

%prep
%setup -q -n %pkgname-src-%texversion
mkdir texmf
pushd texmf
tar xf %SOURCE1
tar xf %SOURCE5
popd
tar xf %SOURCE2
pushd ec-plain
    mkdir -p ../texmf/fonts/source/ec-plain
    cp *.mf ../texmf/fonts/source/ec-plain/
popd

# teTeX patches
%patch1 -p1
%patch2 -p1
%patch3 -p1
#%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1

# texmf patches
pushd texmf
%patch11 -p2
#%patch12 -p2

# Remove mappings from dvips/config as they will be re-generated in %_sysconfdir/tex-fonts
for i in builtin35.map download35.map dvipdfm_dl14.map dvipdfm.map dvipdfm_ndl14.map \
  pdftex_dl14.map pdftex.map pdftex_ndl14.map ps2pk.map psfonts.map ../base/psfonts.map \
  psfonts_pk.map psfonts_t1.map ; do
    rm -f dvips/config/$i
done

%patch13 -p1
popd

# Hack out dependencies on /bin/sh5 and /bin/bsh.
grep -ErlZ 'exec /bin/(sh5|bsh)' . |
	xargs -r0 sed -i 's,exec /bin/\(sh5\|bsh\),exec /bin/sh,g' --

# Fix dvi-draw.c
%patch14 -p1

# Fix extra deps in shell scripts
%patch15 -p1

# Security patches
%patch20 -p1
%patch21 -p1 
%patch22 -p1
%patch23 -p1

%patch24 -p2

# Fix build with glibc-2.10+
sed -i s/getline/texk_getline/g \
	texk/dvipsk/afm2tfm.c texk/web2c/mpware/mpto.c
sed -i 's|^.*grep @error@ \$output_files.*|sed -i s/getline/webc_getline/g \$output_files; &|' texk/web2c/web2c/convert

%build
sh ./reautoconf
%configure \
	--with-system-zlib \
	--with-system-pnglib \
	--with-system-t1lib \
	--with-system-ncurses \
	--with-system-tifflib \
	--with-system-wwwlib \
	--disable-multiplatform \
	--without-dialog \
	--without-texinfo \
	--without-t1utils \
	--enable-ipc \
	--enable-a4 \
	--disable-shared \
	--enable-static 
	

# SMP-incompatible build.
make

%install
mkdir -p %buildroot%_datadir/texmf
mkdir -p %buildroot%_localstatedir/texmf
mkdir -p %buildroot%_cachedir/texmf
mkdir -p %buildroot%_sysconfdir/tex-fonts{,.d}

pushd texmf
tar cf - . | tar xf - -C %buildroot%_datadir/texmf
popd

export LD_LIBRARY_PATH=%buildroot%_libdir
export MT_DONT_INSTALL_PK=1

%makeinstall texmf=%buildroot%_datadir/texmf
cp %buildroot%_datadir/texmf/web2c/updmap.cfg %buildroot%_sysconfdir/tex-fonts.d/00updmap.cfg

# Remove texinfo files.
find %buildroot -type f -name texi2pdf\* -delete
rm -r %buildroot%_datadir/texmf/tex/texinfo

#
# Generate tfm metrics for all standard fonts
#
export PATH=%buildroot%_bindir:$PATH
export TEXMFMAIN=%buildroot%_datadir/texmf
for e in T1 OT1 T2A T2B T2C X2 ; do
    allcm -n -e $e 2>/dev/null
done

unset LD_LIBRARY_PATH

rm -f %buildroot%_infodir/dir

# Explicitly remove readlink (better implementation added in coreutils).
find %buildroot -name 'readlink*' -delete

# these are links

install -pDm755 %_sourcedir/%name.cron %buildroot%_sysconfdir/cron.daily/%name

find %buildroot%_man1dir -type f -print0 |
	xargs -r0 chmod 644
ln -s mf.1 %buildroot%_man1dir/mfw.1

# call the brp-compress script before creating the file list
/usr/lib/rpm/brp.d/032-compress.brp

### Files list
find %buildroot -type f -or -type l | \
	sed -e "s|%buildroot||g" | \
	grep -v "^/etc" | grep -v '.orig$' | \
	sed -e 's|.*\.cnf$|%%config(noreplace) &|' \
            -e 's|%_datadir/texmf/dvips/config/config\.ps$|%%config(noreplace) &|' \
	    -e 's|%_datadir/texmf/dvips/config/config\.\(generic\|pdf\|www\)$|%%config &|' \
	    -e 's|%_datadir/texmf/xdvi/XDvi|%%config &|' \
	    -e 's|%%config\(noreplace\) %_datadir/texmf/web2c/texmf\.cnf$|%%config\(replace\) %_datadir/texmf/web2c/texmf\.cnf|' \
	    >filelist.full

find %buildroot%_datadir/texmf -mindepth  1 -type d | \
	sed "\,%_datadir/texmf/doc$,d; s|^%buildroot|\%%attr(755,root,root) \%%dir |" >> filelist.full

# subpackages
grep -v "/doc/" filelist.full | grep latex 	> filelist.latex

grep -v "/doc/" filelist.full | grep xdvi | \
	grep -v "%_datadir/texmf/tex"		> filelist.xdvi

# Move metafont to xdvi due to xorg deps
for f in mfw mf inimf virmf; do
	echo "%_bindir/$f"
	echo "%_man1dir/$f.1"
done >>filelist.xdvi

# Do not include dvips configs into dvips subpackage as they are now
# required by XDvi as well
grep -v "/doc/" filelist.full | grep dvips | \
	grep -v "%_datadir/texmf/tex" | \
	grep -v "%_datadir/texmf/dvips"		> filelist.dvips
echo "%_bindir/dvired" >> filelist.dvips
echo "%_bindir/dvi2fax" >> filelist.dvips

grep -v "/doc/" filelist.full | grep dvilj | \
	grep -v "%_datadir/texmf/tex/latex" 	> filelist.dvilj

grep -v "/doc/" filelist.full | grep afm 	> filelist.afm

grep "/doc/" filelist.full 			> filelist.doc_temp
grep "texdoc" filelist.full			>> filelist.doc_temp
sort -u -o filelist.doc_temp filelist.doc_temp
cat filelist.doc_temp | grep -v "/doc/context" | sort | uniq -u	> filelist.doc

grep "/usr/include/" filelist.full 		> filelist.devel

# Separate ConTeXt
egrep "%_datadir/texmf/(tex/|doc/|)context" filelist.full	> filelist.context
egrep "%_bindir/(texexec|texshow|texfind|texfont|texutil|mptopdf|fdf2tan|makempy)" filelist.full >>filelist.context
egrep "%_cachedir/texmf/web2c/(cont-.*|metafun|mptopdf)" filelist.full >>filelist.context
egrep "%_man1dir/(cont-en|cont-de|cont-nl|texexec|texshow|texutil)" filelist.full >>filelist.context

# now files listed only once, i.e. not included in any subpackage, will
# go in the main package
cat filelist.full \
    filelist.latex \
    filelist.xdvi \
    filelist.dvips \
    filelist.dvilj \
    filelist.afm \
    filelist.devel \
    filelist.doc \
    filelist.context | \
    sort | uniq -u > filelist.core
    
 find texk -type f -\( \
    -name ChangeLog -or \
    -name 'README*' \
    -\) |sed -e 's|^texk/|%%doc &|'|egrep -v "(make|etc|djgpp)/" > filelist.main

# xdvi menu things
mkdir -p %buildroot%_menudir
cat > %buildroot%_menudir/tetex-xdvi <<EOF
?package(tetex-xdvi): command="%_bindir/xdvi" needs="X11" \
icon="dvi.xpm" section="Applications/Publishing" title="xdvi" \
longtitle="DVI files viewer"
EOF

#mdk icons
install -d %buildroot%_iconsdir
tar xf %SOURCE4 -C %buildroot%_iconsdir

# Settings for Emacs' TeX mode:
%define _emacssite %_sysconfdir/emacs/site-start.d
dest="%buildroot%_emacssite"
mkdir -p "$dest"
pkg=xdvi
 install -pm644 %SOURCE101 "$dest"/$pkg.el
 echo "%%config(noreplace) %_emacssite/$pkg.el" >> filelist.$pkg
pkg=dvips
 install -p -m0644 %SOURCE102 "$dest"/$pkg.el
 echo "%%config(noreplace) %_emacssite/$pkg.el" >> filelist.$pkg
pkg=dvilj
 install -p -m0644 %SOURCE103 "$dest"/$pkg.el
 for f in $(cat filelist.dvilj | fgrep /usr/bin/dvilj); do
    name="$(basename "$f")"
    echo ";(setq tex-dvi-print-command \"$name -e- * | lpr\")" >> "$dest"/$pkg.el
 done
 echo "%%config(noreplace) %_emacssite/$pkg.el" >> filelist.$pkg
unset dest

%pre core
if [ -d %_datadir/texmf/dvipdfm/config ]; then
	rm -rf %_datadir/texmf/dvipdfm/config
fi

%post core
x=/usr/bin/updmap && [ -x "$x" ] && "$x"  2>/dev/null ||:

%preun core
x=/usr/bin/updmap && [ -x "$x" ] && "$x"  2>/dev/null ||:

%files -f filelist.core core
%attr(1777,root,root) %dir %_localstatedir/texmf
%attr(755,root,root) %dir %_sysconfdir/tex-fonts
%attr(755,root,root) %dir %_cachedir/texmf/web2c
%config %_sysconfdir/cron.daily/%name
%config %_sysconfdir/tex-fonts.d/*

%files -f filelist.latex latex
%attr(755,root,root) %dir %_cachedir/texmf/web2c

%files -f filelist.context context
%attr(755,root,root) %dir %_cachedir/texmf/web2c

%files -f filelist.xdvi xdvi
%_menudir/tetex-xdvi
%_iconsdir/*.xpm
%_iconsdir/*/*.xpm
%doc texk/xdvik/README.t1fonts

%files -f filelist.dvips dvips

%files -f filelist.dvilj dvilj

%files -f filelist.afm afm

%files -f filelist.doc doc

%files -f filelist.devel devel

%files -f filelist.main
%doc PROBLEMS* README ChangeLog

%changelog
