%define version 2.0.2
%define release alt1

%setup_python_module texml

Summary: TeXML: an XML syntax for TeX (LaTeX, ConTeXt)
Name: texml
Version: %version
Release: %release.1
Source: %modulename-%version.tar
Packager: Python Development Team <python@packages.altlinux.org>
License: MIT
Group: Publishing
Url: http://getfo.org/texml/
BuildArch: noarch

BuildRequires: python-devel python-modules-compiler
BuildPreReq: python-modules-encodings python-modules-xml

%description
TeXML is an XML syntax for TeX. The processor transforms the TeXML
markup into the TeX markup, escaping special and out-of-encoding
characters. The intended audience is developers who automatically
generate [La]TeX or ConTeXt files.

%prep
%setup

%build
%python_build_debug
               
%install
%python_build_install --optimize=2 \
                          --record=INSTALLED_FILES
# texml.1 somehow becomes texml.1.gz, INSTALLED_FILES becomes incorrect
cp INSTALLED_FILES INSTALLED_FILES.0 && /bin/sed 's/texml.1/texml.1.gz/' INSTALLED_FILES.0 >INSTALLED_FILES

%files -f INSTALLED_FILES
# The package does not own its own docdir subdirectory.
# The line below is added by repocop to fix this bug in a straightforward way. 
# Another way is to rewrite the spec to use relative doc paths.
%dir %_docdir/texml-%version 

%changelog
