%define ver 051026
%define docsver 051020
%define EVR %{?epoch:%epoch:}%version-%release

Name: tidy
Version: 0.99
Release: alt11.20%ver
Epoch: 20120522

Summary: HTML Tidy helps keep webpages clean
License: W3C license
Group: Text tools

Url: http://tidy.sourceforge.net
Source0: %url/src/tidy_src_%ver.tgz
Source1: %url/docs/tidy_docs_%docsver.tgz
Source2: man_page.txt
Packager: Michael Shigorin <mike@altlinux.org>

Summary(ru_RU.UTF-8): HTML Tidy помогает чистить web-страницы
Summary(uk_UA.UTF-8): HTML Tidy допомагає чистити web-сторінки

# Automatically added by buildreq on Tue Oct 11 2011
BuildRequires: gcc-c++

Requires: lib%name = %EVR

%description
When editing HTML it's easy to make mistakes. Wouldn't it be nice
if there was a simple way to fix these mistakes automatically and
tidy up sloppy editing into nicely layed out markup? Well now
there is! Dave Raggett's HTML TIDY is a free utility for doing
just that. It also works great on the atrociously hard to read
markup generated by specialized HTML editors and conversion
tools, and can help you identify where you need to pay further
attention on making your pages more accessible to people with
disabilities.

Tidy is able to fix up a wide range of problems and to bring to
your attention things that you need to work on yourself. Each
item found is listed with the line number and column so that you
can see where the problem lies in your markup. Tidy won't
generate a cleaned up version when there are problems that it
can't be sure of how to handle. These are logged as "errors"
rather than "warnings".

%description -l ru_RU.UTF-8
При редактировании HTML легко ошибиться.  Правда, было бы
неплохо, чтобы существовал простой путь автоматического
исправления таких ошибок и подчистки несуразного текста до
аккуратной разметки?  Теперь он есть!  Свободная утилита HTML
TIDY от Dave Ragett занимается именно этим.  Также способствует
обработке особенно нечитабельной разметки из-под
специализированных редакторов HTML и утилит конвертирования;
может помочь найти места, требующие внимания для повышения
доступности информации.

Tidy может справиться со многими проблемами и привлечь внимание
к тому, что лучше исправить вручную.  Каждая обнаруженная проблема
выдается с номером строки и колонкой, чтоб было проще ее найти.
Tidy не будет создавать обработанную версию, пока остаются
проблемы, исправить которые автоматически не выходит --
они отмечаются как "ошибки", а не "замечания".

%description -l uk_UA.UTF-8
При редагуванні HTML легко помилитися.  Дійсно, було б непогано,
якщо б існував простий шлях автоматичного виправлення таких
помилок та підчистки незграбного тексту до чемної розмітки?
Тепер він є!  Вільна утиліта HTML TIDY від Dave Ragett займається
саме цим.  Також сприяє обробці особливо нездатної до читання
розмітки з-під спеціалізованих редакторів HTML та утиліт
конвертування; може допомогти знайти місця, що потребують на
додаткову увагу для підвищення досяжності інформації.

Tidy може впоратися із багатьма проблемами та пригорнути увагу
до того, що краще виправити вручну.  Кожна знайдена помилка
видається із номером рядку та колонкою, щоб її було легше знайти.
Tidy не буде створювати оброблену версію, доки залишаються
проблеми, виправити які автоматично не виходить -- вони
відмічаються як "помилки" замість "попереджень".

%package -n lib%name
Summary: Shared libraries for %name
Group: System/Libraries

%description -n lib%name
Shared libraries for %name

%package -n lib%name-devel
Summary: Header files and libraries for %name development
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
Header files and libraries for %name development

%if_enabled static
%package -n lib%name-devel-static
Summary: Static libraries for %name development
Group: Development/C
Requires: lib%name-devel = %EVR

%description -n lib%name-devel-static
Static libraries for %name development
%endif

%prep
%setup -n %name
%setup -n %name -T -D -b1

%build
sh build/gnuauto/setup.sh
%configure %{subst_enable static}
%make_build

%install
%makeinstall
install -pDm644 %SOURCE2 %buildroot%_man1dir/tidy.1
rm htmldoc/doxygen.cfg
mv htmldoc/api _api
%if_enabled static
%else
rm %buildroot%_libdir/*.a
%endif

%files
%doc htmldoc/*
%_bindir/*
%_man1dir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%doc _api/*
%_includedir/*
%_libdir/*.so

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
