Name: tinycdb
Version: 0.77
Release: alt2

Summary: A package for maintenance of constant databases
License: GPLv2+
Group: Databases
Url: http://www.corpit.ru/mjt/tinycdb.html

# http://www.corpit.ru/mjt/tinycdb/tinycdb_%version.tar.gz
Source: tinycdb-%version.tar

Patch1: tinycdb-0.76-alt-makefile.patch
Patch2: tinycdb-0.77-alt-warnings.patch

Requires: libcdb = %version-%release

%def_disable static

%description
tinycdb is a small, fast and reliable utility set and subroutine library
for creating and reading constant databases.  The database structure is
tuned for fast reading:
+ Successful lookups take normally just two disk accesses.
+ Unsuccessful lookups take only one disk access.
+ Small disk space and memory size requirements; a database uses 2048
  bytes for the header and 24 bytes per record.
+ Maximum database size is 4GB; individual record size is not
  otherwise limited.
+ Portable file format.
+ Fast creation of new databases.
+ No locking, updates are atomical.

This package contains the cdb utility.

%package -n libcdb
Summary: The %name shared library 
License: LGPLv2+
Group: System/Libraries

%package -n libcdb-devel
Summary: Development libraries and header files for tinycdb
License: LGPLv2+
Group: Development/C
Requires: libcdb = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel

%package -n libcdb-devel-static
Summary: Development static library for tinycdb
License: LGPLv2+
Group: Development/C
Requires: libcdb-devel = %version-%release

%description -n libcdb
tinycdb is a small, fast and reliable utility set and subroutine
library for creating and reading constant databases.

This package contains tinycdb shared library.

%description -n libcdb-devel
tinycdb is a small, fast and reliable utility set and subroutine
library for creating and reading constant databases.

This package contains tinycdb development library and header files.
Required if you plan to do development using the tinycdb database.

%description -n libcdb-devel-static
tinycdb is a small, fast and reliable utility set and subroutine
library for creating and reading constant databases.

This package contains development static library.

%prep
%setup
%patch1 -p1
%patch2 -p1

%build
%def_enable Werror
%make_build CFLAGS="%optflags -W -D_GNU_SOURCE" %{?_enable_static:static} shared

%install
%make_install \
	%{?_enable_static:install-staticlib} \
	install-sharedlib \
	install-bin \
	install-data \
	bindir=%_bindir \
	libdir=%_libdir \
	syslibdir=/%_lib \
	sysconfdir=%_sysconfdir \
	includedir=%_includedir \
	mandir=%_mandir \
	DESTDIR=%buildroot \
	INSTALLPROG=cdb-shared \
	CP='cp -p'

%define docdir %_docdir/%name-%version
mkdir -p %buildroot/%docdir
install -pm644 NEWS %buildroot/%docdir/

%check
make %{?_enable_static:test} test-shared

%files
%_bindir/*
%_mandir/man1/*

%files -n libcdb
%_libdir/libcdb.so.*
%docdir

%files -n libcdb-devel
%_libdir/libcdb.so
%_mandir/man[35]/*
%_includedir/*

%if_enabled static
%files -n libcdb-devel-static
%_libdir/libcdb.a
%endif

%changelog
